/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.widgets;

import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.widgets.MultipleValueSelectionWidget;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MultipleValueEditAndSelectionWidget
extends MultipleValueSelectionWidget {
    private boolean allowEdition;
    protected Button edit;

    public MultipleValueEditAndSelectionWidget(IElementSelector selector) {
        super(selector);
    }

    public MultipleValueEditAndSelectionWidget(IElementSelector selector, boolean unique) {
        super(selector, unique);
    }

    public MultipleValueEditAndSelectionWidget(IElementSelector selector, boolean unique, boolean ordered) {
        super(selector, unique, ordered);
    }

    public MultipleValueEditAndSelectionWidget(IElementSelector selector, boolean unique, boolean ordered, int upperBound) {
        super(selector, unique, ordered, upperBound);
    }

    @Override
    protected void init() {
        super.init();
        this.allowEdition = false;
    }

    public boolean isAllowEdition() {
        return this.allowEdition;
    }

    public void setAllowEdition(boolean allowEdition) {
        this.allowEdition = allowEdition;
    }

    @Override
    protected void createRightButtonsSection(Composite parent) {
        super.createRightButtonsSection(parent);
        if (this.isAllowEdition()) {
            this.edit = new Button(this.rightButtonsSection, 8);
            this.edit.setImage(Activator.getDefault().getImage("/icons/Edit_12x12.gif"));
            this.edit.addSelectionListener((SelectionListener)this);
            this.edit.setToolTipText(Messages.MultipleValueEditAndSelectionWidget_EditSelectedElement);
        }
    }

    @Override
    public void updateControls() {
        super.updateControls();
        if (this.allowEdition) {
            this.updateControl((Control)this.edit, this.factory != null && this.factory.canEdit());
        }
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (this.edit != null && e.widget == this.edit) {
            this.edit();
            this.selectedElementsViewer.refresh();
        }
        super.widgetSelected(e);
    }

    protected boolean canEdit() {
        return this.allowEdition && this.factory.canEdit();
    }

    protected void edit() {
    }
}

