/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.io.File;
import java.lang.reflect.Constructor;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.internal.ui.OomphAdapterFactoryContentProvider;
import org.eclipse.oomph.p2.core.CertificateConfirmer;
import org.eclipse.oomph.setup.CertificatePolicy;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.LicenseInfo;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.UnsignedPolicy;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.log.ProgressLog;
import org.eclipse.oomph.setup.log.ProgressLogFilter;
import org.eclipse.oomph.setup.log.ProgressLogProvider;
import org.eclipse.oomph.setup.log.ProgressLogRunnable;
import org.eclipse.oomph.setup.ui.AbstractConfirmDialog;
import org.eclipse.oomph.setup.ui.AbstractDialogConfirmer;
import org.eclipse.oomph.setup.ui.LicenseDialog;
import org.eclipse.oomph.setup.ui.LicensePrePrompter;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.ToolTipLabelProvider;
import org.eclipse.oomph.setup.ui.UnsignedContentDialog;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.setup.ui.wizards.SetupWizardPage;
import org.eclipse.oomph.setup.util.FileUtil;
import org.eclipse.oomph.ui.BackgroundProgressPart;
import org.eclipse.oomph.ui.ButtonBar;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.Confirmer;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.Pair;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.ProgressManager;

public class ProgressPage
extends SetupWizardPage {
    public static final Object PROGRESS_FAMILY = new Object();
    public static final String PROGRESS_STATUS = "org.eclipse.oomph.setup.status";
    public static final String PAGE_NAME = "ProgressPage";
    private final Map<SetupTask, Point> setupTaskSelections = new HashMap<SetupTask, Point>();
    private Constructor<? extends ProgressLog> progressLogWrapper;
    private TreeViewer treeViewer;
    private final ISelectionChangedListener treeViewerSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object element = selection.getFirstElement();
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                while (eObject != null) {
                    Point textSelection;
                    if (eObject != ProgressPage.this.currentTask && eObject instanceof SetupTask && (textSelection = (Point)ProgressPage.this.setupTaskSelections.get(eObject)) != null) {
                        int start = textSelection.x;
                        int end = textSelection.y;
                        if (end == -1) {
                            end = ProgressPage.this.logText.getCharCount();
                        }
                        String selectedText = ProgressPage.this.logText.getText(start, end);
                        int index = 0;
                        int length = selectedText.length();
                        while (index < length) {
                            char c = selectedText.charAt(index);
                            if (c != '\n' && c != '\r') break;
                            ++start;
                            ++index;
                        }
                        ProgressPage.this.logText.setSelection(start, start);
                        int lineFeedCount = 0;
                        int carriageReturnCount = 0;
                        while (index < length) {
                            char c = selectedText.charAt(index);
                            if (c == '\n') {
                                ++lineFeedCount;
                            } else if (c == '\r') {
                                ++carriageReturnCount;
                            }
                            ++index;
                        }
                        int visibleLineCount = ((ProgressPage)ProgressPage.this).logText.getClientArea().height / ProgressPage.this.logText.getLineHeight();
                        if (lineFeedCount > visibleLineCount || carriageReturnCount > visibleLineCount) {
                            ProgressPage.this.logText.setSelection(end, start);
                        } else {
                            ProgressPage.this.logText.setSelection(start, end);
                        }
                    }
                    eObject = eObject.eContainer();
                }
            }
        }
    };
    private StyledText logText;
    private ProgressMonitorPart progressMonitorPart;
    private final Document logDocument = new Document();
    private final ProgressLogFilter logFilter = new ProgressLogFilter();
    private SetupTask currentTask;
    private ProgressPageLog progressPageLog;
    private boolean scrollLock;
    private boolean dismissAutomatically;
    private boolean launchAutomatically;
    private Button scrollLockButton;
    private Button dismissButton;
    private Button launchButton;
    private boolean hasLaunched;
    public static final Confirmer LICENSE_CONFIRMER = new AbstractDialogConfirmer(){

        protected AbstractConfirmDialog createDialog(boolean defaultConfirmed, Object info) {
            Map licensesToIUs = (Map)info;
            return new LicenseDialog(licensesToIUs);
        }
    };

    public ProgressPage() {
        super(PAGE_NAME);
        this.setTitle("Progress");
        this.setDescription("Wait for the setup to complete, or cancel the progress indicator and press Back to make changes.");
    }

    protected Control createUI(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)UIUtil.createGridLayout((int)1));
        SashForm sashForm = new SashForm(mainComposite, 66048);
        sashForm.setLayoutData((Object)new GridData(1808));
        AccessUtil.setKey((Widget)sashForm, (Object)"sash");
        this.treeViewer = new TreeViewer((Composite)sashForm, 2048);
        Tree tree = this.treeViewer.getTree();
        this.addHelpCallout((Control)tree, 1);
        ColumnViewerInformationControlToolTipSupport toolTipSupport = new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.treeViewer, new LocationListener(){

            public void changing(LocationEvent event) {
            }

            public void changed(LocationEvent event) {
            }
        });
        ILabelProvider labelProvider = this.createLabelProvider(toolTipSupport);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        OomphAdapterFactoryContentProvider contentProvider = new OomphAdapterFactoryContentProvider((AdapterFactory)this.getAdapterFactory());
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.addSelectionChangedListener(this.treeViewerSelectionChangedListener);
        tree.setLayoutData((Object)new GridData(1808));
        tree.setBackground(this.getShell().getDisplay().getSystemColor(1));
        TextViewer logTextViewer = new TextViewer((Composite)sashForm, 2818);
        logTextViewer.setDocument((IDocument)this.logDocument);
        this.logText = logTextViewer.getTextWidget();
        this.logText.setBackground(parent.getDisplay().getSystemColor(25));
        this.logText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.logText.setEditable(false);
        this.logText.setLayoutData((Object)new GridData(1808));
        this.logText.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 1 && !ProgressPage.this.scrollLock) {
                    ProgressPage.this.scrollLockButton.setSelection(true);
                    ProgressPage.this.scrollLock = true;
                }
            }
        });
        this.addHelpCallout((Control)this.logText, 2);
        AccessUtil.setKey((Widget)this.logText, (Object)"log");
        return mainComposite;
    }

    protected void createCheckButtons(ButtonBar buttonBar) {
        this.scrollLockButton = buttonBar.addCheckButton("Scroll lock", "Keep the log from scrolling to the end when new messages are added", false, null);
        this.scrollLock = this.scrollLockButton.getSelection();
        this.scrollLockButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressPage.this.scrollLock = ProgressPage.this.scrollLockButton.getSelection();
            }
        });
        AccessUtil.setKey((Widget)this.scrollLockButton, (Object)"lock");
        this.dismissButton = buttonBar.addCheckButton("Dismiss automatically", "Dismiss this wizard when all setup tasks have performed successfully", false, "dismissAutomatically");
        this.dismissAutomatically = this.dismissButton.getSelection();
        this.dismissButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressPage.this.dismissAutomatically = ProgressPage.this.dismissButton.getSelection();
            }
        });
        AccessUtil.setKey((Widget)this.dismissButton, (Object)"dismiss");
        if (this.getWizard().getOS().isCurrentOS()) {
            Boolean launchAutomaticallyPropertyValue = PropertiesUtil.getBoolean((String)"oomph.setup.launch.automatically");
            if (launchAutomaticallyPropertyValue == null) {
                this.launchButton = this.getTrigger() == Trigger.BOOTSTRAP ? buttonBar.addCheckButton("Launch automatically", "Launch the installed product when all setup tasks have performed successfully", true, "launchAutomatically") : buttonBar.addCheckButton("Restart automatically if needed", "Restart the current product if the installation has been changed by setup tasks", false, "restartIfNeeded");
                this.launchAutomatically = this.launchButton.getSelection();
                this.launchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ProgressPage.this.launchAutomatically = ProgressPage.this.launchButton.getSelection();
                    }
                });
                AccessUtil.setKey((Widget)this.launchButton, (Object)"launch");
            } else {
                this.launchAutomatically = launchAutomaticallyPropertyValue;
            }
        }
    }

    protected void createFooter(Composite parent) {
        this.progressMonitorPart = new BackgroundProgressPart(parent, null, true){

            protected void initialize(Layout layout, int progressIndicatorHeight) {
                super.initialize(layout, progressIndicatorHeight);
                this.fLabel.dispose();
                if (PlatformUI.isWorkbenchRunning()) {
                    Control[] controlArray = this.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control child = controlArray[n2];
                        if (child instanceof ToolBar) {
                            ToolBar toolBar = (ToolBar)child;
                            ToolItem minimizeButton = new ToolItem(toolBar, 8);
                            minimizeButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("hide"));
                            minimizeButton.setToolTipText("Minimize to the status area");
                            minimizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent event) {
                                    ProgressPage.this.getWizard().getShell().setVisible(false);
                                }
                            });
                            break;
                        }
                        ++n2;
                    }
                }
            }

            protected void updateLabel() {
            }

            public void done() {
                UIUtil.syncExec((Runnable)new Runnable(){

                    public void run() {
                        fProgressIndicator.sendRemainingWork();
                        fProgressIndicator.done();
                        this.removeFromCancelComponent(null);
                        ProgressPage.this.progressMonitorPart.setLayoutData((Object)new GridData(0, 0));
                        ProgressPage.this.progressMonitorPart.getParent().layout();
                    }
                });
            }
        };
        this.progressMonitorPart.setLayoutData((Object)new GridData(768));
        AccessUtil.setKey((Widget)this.progressMonitorPart, (Object)"progress");
    }

    public void enterPage(boolean forward) {
        if (forward) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
            this.setMessage(null);
            this.hasLaunched = false;
            this.progressPageLog = new ProgressPageLog(this.progressMonitorPart);
            this.logDocument.set("");
            ProgressPageLog progressLog = this.progressPageLog;
            if (this.progressLogWrapper != null) {
                try {
                    progressLog = this.progressLogWrapper.newInstance(progressLog);
                }
                catch (Throwable throwable) {}
            }
            final SetupTaskPerformer performer = this.getPerformer();
            User performerUser = performer.getUser();
            performer.setProgress((ProgressLog)progressLog);
            if (performer.get(ILicense.class) == null) {
                performer.put(ILicense.class, (Object)LICENSE_CONFIRMER);
            }
            if (performer.get(Certificate.class) == null) {
                performer.put(Certificate.class, (Object)UnsignedContentDialog.createUnsignedContentConfirmer(performerUser, false));
            }
            if (performer.get(CertificateConfirmer.class) == null) {
                performer.put(CertificateConfirmer.class, (Object)SetupCoreUtil.createCertificateConfirmer((User)performerUser, (boolean)false));
            }
            File renamed = null;
            if (this.getTrigger() == Trigger.BOOTSTRAP) {
                EList<LicenseInfo> licenses;
                File configurationLocation = performer.getProductConfigurationLocation();
                if (configurationLocation.exists()) {
                    try {
                        renamed = FileUtil.rename((File)configurationLocation);
                    }
                    catch (RuntimeException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        this.progressPageLog.log(ex);
                        this.setErrorMessage("Could not rename '" + configurationLocation + "'.  Press Back twice to choose a different installation location.");
                        this.progressPageLog.done();
                        throw new IORuntimeException((Throwable)ex);
                    }
                }
                if (UIUtil.isBrowserAvailable() && (licenses = LicensePrePrompter.execute(this.getShell(), performerUser)) != null) {
                    ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
                    User user = SetupContext.createUserOnly((ResourceSet)resourceSet).getUser();
                    user.getAcceptedLicenses().addAll(licenses);
                    BaseUtil.saveEObject((EObject)user);
                    performerUser.getAcceptedLicenses().addAll(licenses);
                }
            }
            this.treeViewer.setInput((Object)new ItemProvider((Collection)performer.getNeededTasks()));
            String jobName = "Executing " + this.getTriggerName().toLowerCase() + " tasks";
            performer.log(jobName, false, ProgressLog.Severity.INFO);
            if (renamed != null) {
                performer.log("Renamed existing configuration folder to " + renamed);
            }
            this.run(jobName, new ProgressLogRunnable(){

                public Set<String> run(ProgressLog log) throws Exception {
                    final ProgressManager oldProgressProvider = ProgressManager.getInstance();
                    ProgressLogProvider newProgressLogProvider = new ProgressLogProvider((ProgressLog)ProgressPage.this.progressPageLog, (ProgressProvider)oldProgressProvider);
                    JobChangeAdapter jobChangeListener = PlatformUI.isWorkbenchRunning() ? null : new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            Job job = event.getJob();
                            JobInfo[] jobInfoArray = oldProgressProvider.getJobInfos(true);
                            int n = jobInfoArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                JobInfo jobInfo = jobInfoArray[n2];
                                if (jobInfo.getJob() == job) {
                                    oldProgressProvider.removeJobInfo(jobInfo);
                                    break;
                                }
                                ++n2;
                            }
                        }
                    };
                    IJobManager jobManager = Job.getJobManager();
                    jobManager.setProgressProvider((ProgressProvider)newProgressLogProvider);
                    if (jobChangeListener != null) {
                        jobManager.addJobChangeListener((IJobChangeListener)jobChangeListener);
                    }
                    try {
                        performer.perform((IProgressMonitor)ProgressPage.this.progressPageLog);
                        Set set = performer.getRestartReasons();
                        return set;
                    }
                    finally {
                        jobManager.setProgressProvider((ProgressProvider)oldProgressProvider);
                        if (jobChangeListener != null) {
                            jobManager.removeJobChangeListener((IJobChangeListener)jobChangeListener);
                        }
                    }
                }
            });
        }
    }

    public void leavePage(boolean forward) {
        if (forward) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(false);
            this.hasLaunched = false;
            this.setButtonState(1, true);
        }
    }

    public boolean performCancel() {
        boolean isPerforming;
        boolean bl = isPerforming = this.getWizard().getCurrentPage() instanceof ProgressPage && !this.progressPageLog.isCanceled() && !this.progressPageLog.isDone();
        if (isPerforming && PlatformUI.isWorkbenchRunning()) {
            this.getWizard().getShell().setVisible(false);
            return false;
        }
        return !isPerforming;
    }

    protected void setButtonState(int buttonID, boolean enabled) {
        super.setButtonState(buttonID, enabled);
        if (buttonID == 1 && this.getPerformer().hasSuccessfullyPerformed()) {
            this.scrollLockButton.setEnabled(enabled);
            this.dismissButton.setEnabled(enabled);
            if (this.launchButton != null) {
                this.launchButton.setEnabled(!this.hasLaunched);
            }
        }
    }

    private ILabelProvider createLabelProvider(ColumnViewerInformationControlToolTipSupport toolTipSupport) {
        return new ToolTipLabelProvider(this.getAdapterFactory(), toolTipSupport){

            public Font getFont(Object element) {
                if (element == ProgressPage.this.currentTask) {
                    return ExtendedFontRegistry.INSTANCE.getFont(ProgressPage.this.treeViewer.getControl().getFont(), (Object)IItemFontProvider.BOLD_FONT);
                }
                return super.getFont(element);
            }
        };
    }

    private void run(final String jobName, final ProgressLogRunnable runnable) {
        try {
            final ProgressPageLog progressLog = this.progressPageLog;
            Runnable jobRunnable = new Runnable(){

                public void run() {
                    final SetupWizard wizard = ProgressPage.this.getWizard();
                    final Shell shell = wizard.getShell();
                    ProgressPage.this.setButtonState(1, false);
                    ProgressPage.this.setButtonState(14, false);
                    Job job = new Job(jobName){

                        /*
                         * Exception decompiling
                         */
                        protected IStatus run(IProgressMonitor monitor) {
                            /*
                             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                             * 
                             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                             *     at org.benf.cfr.reader.Main.main(Main.java:54)
                             */
                            throw new IllegalStateException("Decompilation failed");
                        }

                        public boolean belongsTo(Object family) {
                            return family == PROGRESS_FAMILY;
                        }
                    };
                    job.schedule();
                }
            };
            UIUtil.asyncExec((Runnable)jobRunnable);
        }
        catch (Throwable ex) {
            SetupUIPlugin.INSTANCE.log(ex);
            ErrorDialog.open((Throwable)ex);
        }
    }

    private void saveLocalFiles(SetupTaskPerformer performer) {
        CertificatePolicy performerUserCertificatePolicy;
        UnsignedPolicy performerUserUnsignedPolicy;
        User performerUser = performer.getUser();
        ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
        User user = SetupContext.createUserOnly((ResourceSet)resourceSet).getUser();
        boolean shouldSave = user.getAcceptedLicenses().addAll((Collection)performerUser.getAcceptedLicenses());
        UnsignedPolicy userUnsignedPolicy = user.getUnsignedPolicy();
        if (userUnsignedPolicy != (performerUserUnsignedPolicy = performerUser.getUnsignedPolicy())) {
            user.setUnsignedPolicy(performerUserUnsignedPolicy);
            shouldSave = true;
        }
        shouldSave = user.getAcceptedCertificates().addAll((Collection)performerUser.getAcceptedCertificates()) || shouldSave;
        CertificatePolicy userCertificatePolicy = user.getCertificatePolicy();
        if (userCertificatePolicy != (performerUserCertificatePolicy = performerUser.getCertificatePolicy())) {
            user.setCertificatePolicy(performerUserCertificatePolicy);
            shouldSave = true;
        }
        if (shouldSave) {
            BaseUtil.saveEObject((EObject)user);
        }
        SetupContext setupContext = this.getWizard().getSetupContext();
        Installation installation = setupContext.getInstallation();
        BaseUtil.saveEObject((EObject)installation);
        Workspace workspace = setupContext.getWorkspace();
        if (workspace != null) {
            BaseUtil.saveEObject((EObject)workspace);
        }
        SetupContext.associate((Installation)installation, (Workspace)workspace);
    }

    public static boolean launchProduct(SetupTaskPerformer performer) throws Exception {
        OS os = performer.getOS();
        if (os.isCurrentOS()) {
            performer.log("Launching the installed product...");
            SetupTaskPerformer.ExecutableInfo info = performer.getExecutableInfo();
            ArrayList<String> command = new ArrayList<String>();
            File executable = info.getExecutable();
            command.add(executable.toString());
            File ws = performer.getWorkspaceLocation();
            if (ws != null) {
                SetupUIPlugin.initialStart(ws, performer.isOffline(), performer.isMirrors());
                command.add("-data");
                command.add(ws.toString());
            }
            command.add("-vmargs");
            command.add("-Duser.dir=" + info.getEclipseLocation());
            if (ws != null) {
                command.add("-Doomph.setup.show.initial.progress=true");
            }
            try {
                os.execute(command, info.needsConsole());
            }
            catch (Exception ex) {
                performer.log("Launching the installed product failed.");
                performer.log((Throwable)ex);
                return false;
            }
            return true;
        }
        performer.log("Launching the installed product is not possible for cross-platform installs. Skipping.");
        return false;
    }

    static /* synthetic */ boolean access$18(ProgressPage progressPage) {
        return progressPage.dismissAutomatically;
    }

    static /* synthetic */ boolean access$20(ProgressPage progressPage) {
        return progressPage.hasLaunched;
    }

    static /* synthetic */ void access$22(ProgressPage progressPage, SetupTaskPerformer setupTaskPerformer) {
        progressPage.saveLocalFiles(setupTaskPerformer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProgressPageLog
    implements ProgressLog,
    IProgressMonitor {
        private List<Object> queue;
        private final ProgressMonitorPart progressMonitorPart;
        private IProgressMonitor progressMonitor;
        private boolean canceled;
        private boolean terminating;
        private boolean done;

        public ProgressPageLog(ProgressMonitorPart progressMonitorPart) {
            this.progressMonitorPart = progressMonitorPart;
            progressMonitorPart.attachToCancelComponent(null);
            progressMonitorPart.setCanceled(false);
            progressMonitorPart.setLayoutData((Object)new GridData(768));
            progressMonitorPart.getParent().layout();
        }

        public void setProgressMonitor(IProgressMonitor progressMonitor) {
            this.progressMonitor = progressMonitor;
        }

        public void setTerminating() {
            this.terminating = true;
        }

        public void setTerminated() {
            this.terminating = false;
            this.done = true;
        }

        public boolean isCanceled() {
            if (!this.canceled && (this.progressMonitorPart.isCanceled() || this.progressMonitor != null && this.progressMonitor.isCanceled())) {
                this.canceled = true;
            }
            return this.canceled;
        }

        public boolean isDone() {
            return this.done;
        }

        public void done() {
            this.done = true;
            this.progressMonitorPart.done();
            if (this.progressMonitor != null) {
                this.progressMonitor.done();
            }
        }

        public void beginTask(String name, int totalWork) {
            this.progressMonitorPart.beginTask(name, totalWork);
            this.logTaskName(name);
            if (this.progressMonitor != null) {
                this.progressMonitor.beginTask(name, totalWork);
            }
        }

        public void internalWorked(double work) {
            this.progressMonitorPart.internalWorked(work);
            if (this.progressMonitor != null) {
                this.progressMonitor.internalWorked(work);
            }
        }

        public void setCanceled(boolean canceled) {
            this.canceled = canceled;
            if (this.progressMonitor != null) {
                this.progressMonitor.setCanceled(canceled);
            }
        }

        public void setTaskName(String name) {
            this.logTaskName(name);
            if (this.progressMonitor != null) {
                this.progressMonitor.setTaskName(name);
            }
        }

        public void subTask(String name) {
            this.logTaskName(name);
            if (this.progressMonitor != null) {
                this.progressMonitor.subTask(name);
            }
        }

        public void worked(int work) {
            this.progressMonitorPart.worked(work);
            if (this.progressMonitor != null) {
                this.progressMonitor.internalWorked((double)work);
            }
        }

        public void task(final SetupTask setupTask) {
            UIUtil.syncExec((Runnable)new Runnable(){

                public void run() {
                    SetupTask previousCurrentTask = ProgressPage.this.currentTask;
                    ProgressPage.this.currentTask = setupTask;
                    int offset = 0;
                    if (previousCurrentTask != null) {
                        Point previousTextSelection = (Point)ProgressPage.this.setupTaskSelections.get(previousCurrentTask);
                        offset = ProgressPage.this.logText.getCharCount() - 1;
                        int start = previousTextSelection.x;
                        ProgressPage.this.setupTaskSelections.put(previousCurrentTask, new Point(start, offset));
                        ProgressPage.this.treeViewer.refresh((Object)previousCurrentTask, true);
                    }
                    if (setupTask != null) {
                        ProgressPage.this.setupTaskSelections.put(setupTask, new Point(offset, -1));
                        ProgressPage.this.treeViewer.refresh((Object)setupTask, true);
                        ProgressPage.this.treeViewer.removeSelectionChangedListener(ProgressPage.this.treeViewerSelectionChangedListener);
                        ProgressPage.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)setupTask), true);
                        ProgressPage.this.treeViewer.addSelectionChangedListener(ProgressPage.this.treeViewerSelectionChangedListener);
                    }
                }
            });
        }

        public void log(String line) {
            this.log(line, true);
        }

        public void log(IStatus status) {
            String string = SetupUIPlugin.toString((IStatus)status);
            this.log(string, false, ProgressLog.Severity.fromStatus((IStatus)status));
        }

        public void log(Throwable t) {
            String string = SetupUIPlugin.toString((Throwable)t);
            this.log(string, false, ProgressLog.Severity.ERROR);
        }

        public void log(String line, ProgressLog.Severity severity) {
            this.log(line, true, severity);
        }

        public void log(String line, boolean filter) {
            this.log(line, filter, ProgressLog.Severity.OK);
        }

        public void log(String line, boolean filter, ProgressLog.Severity severity) {
            if (this.done && !this.terminating) {
                return;
            }
            this.message(line, filter, severity);
        }

        public void message(String line) {
            this.message(line, true, ProgressLog.Severity.OK);
        }

        public void message(String line, ProgressLog.Severity severity) {
            this.message(line, true, severity);
        }

        private void message(String line, boolean filter, ProgressLog.Severity severity) {
            if (!this.terminating && this.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (filter) {
                line = ProgressPage.this.logFilter.filter(line);
            }
            if (line == null) {
                return;
            }
            boolean wasEmpty = this.enqueue(line, severity);
            if (wasEmpty) {
                UIUtil.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        List lines = ProgressPageLog.this.dequeue();
                        ProgressPageLog.this.appendText(lines);
                    }
                });
            }
        }

        private synchronized boolean enqueue(String line, ProgressLog.Severity severity) {
            boolean wasEmpty;
            boolean bl = wasEmpty = this.queue == null;
            if (wasEmpty) {
                this.queue = new ArrayList<Object>();
            }
            if (severity == ProgressLog.Severity.OK) {
                this.queue.add(line);
            } else {
                this.queue.add(Pair.create((Object)line, (Object)severity));
            }
            return wasEmpty;
        }

        private synchronized List<Object> dequeue() {
            List<Object> result = this.queue;
            this.queue = null;
            return result;
        }

        private void appendText(List<Object> lines) {
            if (ProgressPage.this.logText.isDisposed()) {
                return;
            }
            for (Object value : lines) {
                ProgressLog.Severity severity;
                String line;
                if (value instanceof String) {
                    line = (String)value;
                    severity = ProgressLog.Severity.OK;
                } else {
                    Pair pair = (Pair)value;
                    line = (String)pair.getElement1();
                    severity = (ProgressLog.Severity)pair.getElement2();
                }
                line = String.valueOf(line) + "\n";
                try {
                    int colorID;
                    int length = ProgressPage.this.logDocument.getLength();
                    ProgressPage.this.logDocument.replace(length, 0, line);
                    switch (severity) {
                        case INFO: {
                            colorID = 9;
                            break;
                        }
                        case WARNING: {
                            colorID = 8;
                            break;
                        }
                        case ERROR: {
                            colorID = 3;
                            break;
                        }
                        default: {
                            colorID = 2;
                        }
                    }
                    if (colorID != 2) {
                        Color color = ProgressPage.this.logText.getDisplay().getSystemColor(colorID);
                        StyleRange styleRange = new StyleRange(length, line.length(), color, null);
                        if (severity == ProgressLog.Severity.INFO) {
                            styleRange.fontStyle = 1;
                        }
                        ProgressPage.this.logText.setStyleRange(styleRange);
                    }
                    if (ProgressPage.this.scrollLock) continue;
                    int lineCount = ProgressPage.this.logText.getLineCount();
                    ProgressPage.this.logText.setTopIndex(lineCount - 1);
                }
                catch (Exception ex) {
                    SetupUIPlugin.INSTANCE.log(ex);
                }
            }
        }

        private void logTaskName(String name) {
            SetupTaskPerformer performer = ProgressPage.this.getPerformer();
            if (performer != null) {
                performer.log(name);
            }
        }

        static /* synthetic */ void access$3(ProgressPageLog progressPageLog, String string, boolean bl, ProgressLog.Severity severity) {
            progressPageLog.message(string, bl, severity);
        }
    }
}

