/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.IfExp;
import org.eclipse.ocl.ecore.IterateExp;
import org.eclipse.ocl.ecore.LetExp;
import org.eclipse.ocl.ecore.LoopExp;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.TupleType;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.impactanalyzer.configuration.OptimizationActivation;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackStepCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequest;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestFactory;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestSet;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.HighlightingToStringVisitor;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.OclHelper;
import org.eclipse.ocl.examples.impactanalyzer.util.OperationCallExpKeyedSet;
import org.eclipse.ocl.examples.impactanalyzer.util.Tuple;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTracebackStep<E extends OCLExpression>
implements TracebackStep {
    protected EClass requiredType;
    private final E expression;
    private final Set<UnusedEvaluationRequest> unusedEvaluationRequests;
    private Tuple.Pair<AnnotatedEObject, UnusedEvaluationRequestSet> currentlyEvaluatingTracebackFor;
    private Collection<Tuple.Pair<AnnotatedEObject, UnusedEvaluationRequestSet>> listOfKeysCurrentlyEvaluatingTracebackFor;
    private final OppositeEndFinder oppositeEndFinder;
    private final String annotation;
    protected final OCLFactory oclFactory;
    public static int tracebackExecutions = 0;
    public static int provenUnused = 0;

    protected AbstractTracebackStep(E sourceExpression, Stack<String> tupleLiteralNamesToLookFor, OppositeEndFinder oppositeEndFinder, OperationBodyToCallMapper operationBodyToCallMapper, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory, OCLFactory oclFactory) {
        this.expression = sourceExpression;
        this.oppositeEndFinder = oppositeEndFinder;
        this.oclFactory = oclFactory;
        EClassifier type = (EClassifier)sourceExpression.getType();
        this.requiredType = this.getInnermostTypeConsideringTupleLiteralsLookedFor(tupleLiteralNamesToLookFor, type);
        this.unusedEvaluationRequests = OptimizationActivation.getOption().isUnusedDetectionActive() ? this.determineUnusedEvaluationRequests((OCLExpression)this.getExpression(), operationBodyToCallMapper, unusedEvaluationRequestFactory) : null;
        this.annotation = this.getVerboseDebugInfo(operationBodyToCallMapper);
    }

    private Set<UnusedEvaluationRequest> determineUnusedEvaluationRequests(OCLExpression e, OperationBodyToCallMapper operationBodyToCallMapper, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory) {
        HashSet<UnusedEvaluationRequest> result = new HashSet<UnusedEvaluationRequest>();
        OCLExpression root = OclHelper.getRootExpression((EObject)e);
        Set<Variable> variablesInScope = AbstractTracebackStep.getAllVariablesInScope(e, operationBodyToCallMapper);
        return this.determineUnusedEvaluationRequests(e, root, variablesInScope, operationBodyToCallMapper, result, unusedEvaluationRequestFactory);
    }

    private Set<UnusedEvaluationRequest> determineUnusedEvaluationRequests(OCLExpression e, OCLExpression upTo, Set<Variable> variablesInScope, OperationBodyToCallMapper operationBodyToCallMapper, Set<UnusedEvaluationRequest> result, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory) {
        UnusedEvaluationRequest thenClauseRequest = this.getThenClauseUnusedCheckRequest(e, variablesInScope, operationBodyToCallMapper, unusedEvaluationRequestFactory);
        if (thenClauseRequest != null) {
            result.add(thenClauseRequest);
        } else {
            UnusedEvaluationRequest elseClauseRequest = this.getElseClauseUnusedCheckRequest(e, variablesInScope, operationBodyToCallMapper, unusedEvaluationRequestFactory);
            if (elseClauseRequest != null) {
                result.add(elseClauseRequest);
            } else {
                UnusedEvaluationRequest loopBodyRequest = this.getLoopBodyUnusedCheckRequest(e, variablesInScope, operationBodyToCallMapper, unusedEvaluationRequestFactory);
                if (loopBodyRequest != null) {
                    result.add(loopBodyRequest);
                } else {
                    Set<UnusedEvaluationRequest> letVariableInitRequests = this.getLetVariableInitUnusedCheckRequests(e, variablesInScope, operationBodyToCallMapper, this.oppositeEndFinder, unusedEvaluationRequestFactory);
                    if (letVariableInitRequests != null) {
                        result.addAll(letVariableInitRequests);
                    } else {
                        Set<UnusedEvaluationRequest> operationArgumentRequests = this.getOperationArgumentUnusedCheckRequests(e, variablesInScope, operationBodyToCallMapper);
                        if (operationArgumentRequests != null) {
                            result.addAll(operationArgumentRequests);
                        } else {
                            UnusedEvaluationRequest collectionLiteralWithAtRequest = this.getCollectionLiteralWithAtUnusedCheckRequest(e, variablesInScope, operationBodyToCallMapper);
                            if (collectionLiteralWithAtRequest != null) {
                                result.add(collectionLiteralWithAtRequest);
                            }
                        }
                    }
                }
            }
        }
        Set<UnusedEvaluationRequest> compositeParentRequests = this.getCompositeParentUnusedCheckRequests(e, upTo, variablesInScope, new HashSet<UnusedEvaluationRequest>(), operationBodyToCallMapper, unusedEvaluationRequestFactory);
        result.addAll(compositeParentRequests);
        if (result.size() > 0) {
            return result;
        }
        return null;
    }

    private Set<UnusedEvaluationRequest> getCompositeParentUnusedCheckRequests(OCLExpression e, OCLExpression upTo, Set<Variable> variablesInScope, Set<UnusedEvaluationRequest> result, OperationBodyToCallMapper operationBodyToCallMapper, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory) {
        EObject container = e.eContainer();
        while (container != null && !(container instanceof OCLExpression)) {
            container = container.eContainer();
        }
        if (container != null && container instanceof OCLExpression) {
            Set<Variable> variablesLeavingScope = AbstractTracebackStep.getVariablesScopedByExpression(e, operationBodyToCallMapper);
            HashSet<Variable> remainingVariablesInScope = new HashSet<Variable>(variablesInScope);
            remainingVariablesInScope.removeAll(variablesLeavingScope);
            this.determineUnusedEvaluationRequests((OCLExpression)container, upTo, remainingVariablesInScope, operationBodyToCallMapper, result, unusedEvaluationRequestFactory);
        }
        return result;
    }

    private UnusedEvaluationRequest getCollectionLiteralWithAtUnusedCheckRequest(OCLExpression e, Set<Variable> variablesInScope, OperationBodyToCallMapper operationBodyToCallMapper) {
        return null;
    }

    private Set<UnusedEvaluationRequest> getOperationArgumentUnusedCheckRequests(OCLExpression e, Set<Variable> variablesInScope, OperationBodyToCallMapper operationBodyToCallMapper) {
        return null;
    }

    private Set<UnusedEvaluationRequest> getLetVariableInitUnusedCheckRequests(OCLExpression e, Set<Variable> variablesInScope, OperationBodyToCallMapper operationBodyToCallMapper, OppositeEndFinder oppositeEndFinder, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory) {
        EObject letCandidate;
        HashSet<UnusedEvaluationRequest> result = new HashSet<UnusedEvaluationRequest>();
        EObject container = e.eContainer();
        if (container != null && container instanceof Variable && ((Variable)container).getInitExpression() == e && (letCandidate = container.eContainer()) instanceof LetExp && ((LetExp)letCandidate).getIn() == e) {
            Collection variableExps = oppositeEndFinder.navigateOppositePropertyWithBackwardScope((EReference)EcorePackage.eINSTANCE.getVariableExp().getEStructuralFeature(12), container);
            for (EObject ve : variableExps) {
                VariableExp variableExp = (VariableExp)ve;
                Set<Variable> variableScopeChange = this.getVariablesChangingScope(e, (OCLExpression)variableExp, operationBodyToCallMapper);
                HashSet<Variable> newScope = new HashSet<Variable>(variablesInScope);
                newScope.removeAll(variableScopeChange);
                this.determineUnusedEvaluationRequests((OCLExpression)variableExp, (OCLExpression)((LetExp)letCandidate).getIn(), newScope, operationBodyToCallMapper, result, unusedEvaluationRequestFactory);
            }
        }
        return result;
    }

    private UnusedEvaluationRequest getLoopBodyUnusedCheckRequest(OCLExpression e, Set<Variable> variablesInScope, OperationBodyToCallMapper operationBodyToCallMapper, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory) {
        UnusedEvaluationRequest result = null;
        EObject container = e.eContainer();
        if (container instanceof LoopExp && ((LoopExp)container).getBody() == e) {
            Variable resultVariable;
            HashSet<Variable> variablesInScopeReducedByIteratorsAndResult = new HashSet<Variable>(variablesInScope);
            variablesInScopeReducedByIteratorsAndResult.removeAll((Collection<?>)((LoopExp)container).getIterator());
            if (container instanceof IterateExp && (resultVariable = (Variable)((IterateExp)container).getResult()) != null) {
                variablesInScopeReducedByIteratorsAndResult.remove(resultVariable);
            }
            result = unusedEvaluationRequestFactory.getUnusedEvaluationRequest((OCLExpression)((LoopExp)container).getSource(), null, null, variablesInScopeReducedByIteratorsAndResult);
        }
        return result;
    }

    private UnusedEvaluationRequest getElseClauseUnusedCheckRequest(OCLExpression e, Set<Variable> variablesInScope, OperationBodyToCallMapper operationBodyToCallMapper, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory) {
        UnusedEvaluationRequest result = null;
        EObject container = e.eContainer();
        if (container instanceof IfExp && ((IfExp)container).getElseExpression() == e) {
            result = unusedEvaluationRequestFactory.getUnusedEvaluationRequest((OCLExpression)((IfExp)container).getCondition(), true, null, variablesInScope);
        }
        return result;
    }

    private UnusedEvaluationRequest getThenClauseUnusedCheckRequest(OCLExpression e, Set<Variable> variablesInScope, OperationBodyToCallMapper operationBodyToCallMapper, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory) {
        UnusedEvaluationRequest result = null;
        EObject container = e.eContainer();
        if (container instanceof IfExp && ((IfExp)container).getThenExpression() == e) {
            result = unusedEvaluationRequestFactory.getUnusedEvaluationRequest((OCLExpression)((IfExp)container).getCondition(), false, null, variablesInScope);
        }
        return result;
    }

    public E getExpression() {
        return this.expression;
    }

    protected EClass getInnermostTypeConsideringTupleLiteralsLookedFor(Stack<String> tupleLiteralNamesToLookFor, EClassifier type) {
        EClass result;
        if (tupleLiteralNamesToLookFor == null || tupleLiteralNamesToLookFor.isEmpty()) {
            result = this.getInnermostClass(type);
        } else {
            EClassifier currentType = this.getInnermostElementType(type);
            int i = tupleLiteralNamesToLookFor.size() - 1;
            while (i >= 0) {
                TupleType tt = (TupleType)currentType;
                EStructuralFeature part = tt.getEStructuralFeature((String)tupleLiteralNamesToLookFor.get(i));
                currentType = this.getInnermostClass(part.getEType());
                --i;
            }
            result = (EClass)currentType;
        }
        return result;
    }

    @Override
    public OperationCallExpKeyedSet traceback(AnnotatedEObject source, UnusedEvaluationRequestSet pendingUnusedEvalRequests, TracebackCache tracebackCache, Notification changeEvent) {
        OperationCallExpKeyedSet result;
        ++tracebackExecutions;
        Tuple.Pair<AnnotatedEObject, UnusedEvaluationRequestSet> key = new Tuple.Pair<AnnotatedEObject, UnusedEvaluationRequestSet>(source, pendingUnusedEvalRequests);
        if (this.isCurrentlyEvaluatingFor(key)) {
            result = tracebackCache.getOperationCallExpKeyedSetFactory().emptySet();
        } else {
            try {
                this.startEvaluationFor(key);
                result = tracebackCache.get(this, source, pendingUnusedEvalRequests);
                if (result == null) {
                    if (this.requiredType != null && !this.requiredType.isInstance((Object)source.getAnnotatedObject())) {
                        result = tracebackCache.getOperationCallExpKeyedSetFactory().emptySet();
                    } else if (tracebackCache.getConfiguration().isUnusedDetectionActive()) {
                        UnusedEvaluationRequestSet.UnusedEvaluationResult unusedEvaluationResult = UnusedEvaluationRequestSet.evaluate(this.unusedEvaluationRequests, this.oppositeEndFinder, tracebackCache, this.oclFactory);
                        if (unusedEvaluationResult.hasProvenUnused()) {
                            ++provenUnused;
                            result = tracebackCache.getOperationCallExpKeyedSetFactory().emptySet();
                        } else {
                            result = this.performSubsequentTraceback(source, unusedEvaluationResult.getNewRequestSet() == null ? null : unusedEvaluationResult.getNewRequestSet().merge(pendingUnusedEvalRequests), tracebackCache, changeEvent);
                        }
                    } else {
                        result = this.performSubsequentTraceback(source, null, tracebackCache, changeEvent);
                    }
                    tracebackCache.put(this, source, pendingUnusedEvalRequests, result);
                }
            }
            finally {
                this.finishedEvaluationFor(key);
            }
        }
        return result;
    }

    private boolean isCurrentlyEvaluatingFor(Tuple.Pair<AnnotatedEObject, UnusedEvaluationRequestSet> key) {
        return this.listOfKeysCurrentlyEvaluatingTracebackFor != null ? this.listOfKeysCurrentlyEvaluatingTracebackFor.contains(key) : key.equals(this.currentlyEvaluatingTracebackFor);
    }

    private void finishedEvaluationFor(Tuple.Pair<AnnotatedEObject, UnusedEvaluationRequestSet> key) {
        if (this.listOfKeysCurrentlyEvaluatingTracebackFor != null) {
            if (this.listOfKeysCurrentlyEvaluatingTracebackFor.size() == 1) {
                this.listOfKeysCurrentlyEvaluatingTracebackFor = null;
            } else {
                this.listOfKeysCurrentlyEvaluatingTracebackFor.remove(key);
            }
        } else {
            this.currentlyEvaluatingTracebackFor = null;
        }
    }

    private void startEvaluationFor(Tuple.Pair<AnnotatedEObject, UnusedEvaluationRequestSet> key) {
        if (this.listOfKeysCurrentlyEvaluatingTracebackFor != null) {
            this.listOfKeysCurrentlyEvaluatingTracebackFor.add(key);
        } else if (this.currentlyEvaluatingTracebackFor == null) {
            this.currentlyEvaluatingTracebackFor = key;
        } else {
            this.listOfKeysCurrentlyEvaluatingTracebackFor = new ArrayList<Tuple.Pair<AnnotatedEObject, UnusedEvaluationRequestSet>>();
            this.listOfKeysCurrentlyEvaluatingTracebackFor.add(this.currentlyEvaluatingTracebackFor);
            this.currentlyEvaluatingTracebackFor = null;
            this.listOfKeysCurrentlyEvaluatingTracebackFor.add(key);
        }
    }

    protected abstract OperationCallExpKeyedSet performSubsequentTraceback(AnnotatedEObject var1, UnusedEvaluationRequestSet var2, TracebackCache var3, Notification var4);

    private Set<Variable> getVariablesChangingScope(OCLExpression sourceExpression, OCLExpression targetExpression, OperationBodyToCallMapper operationBodyToCallMapper) {
        Set<Object> result;
        OCLExpression commonCompositionParent = AbstractTracebackStep.commonCompositionParent(sourceExpression, targetExpression);
        if (commonCompositionParent == null) {
            result = new HashSet<Variable>();
            result.addAll(AbstractTracebackStep.getAllVariablesInScope(sourceExpression, operationBodyToCallMapper));
            result.addAll(AbstractTracebackStep.getAllVariablesInScope(targetExpression, operationBodyToCallMapper));
        } else {
            result = this.variablesIntroducedBetween(sourceExpression, commonCompositionParent, operationBodyToCallMapper);
            result.addAll(this.variablesIntroducedBetween(targetExpression, commonCompositionParent, operationBodyToCallMapper));
        }
        return result;
    }

    private Set<Variable> variablesIntroducedBetween(OCLExpression origin, OCLExpression parent, OperationBodyToCallMapper operationBodyToCallMapper) {
        OCLExpression e = origin;
        HashSet<Variable> result = new HashSet<Variable>();
        while (e != null && e != parent) {
            if (e instanceof OCLExpression) {
                result.addAll(AbstractTracebackStep.getVariablesScopedByExpression(e, operationBodyToCallMapper));
            }
            e = e.eContainer();
        }
        return result;
    }

    protected static Set<Variable> getVariablesScopedByExpression(OCLExpression e, OperationBodyToCallMapper operationBodyToCallMapper) {
        EObject container = e.eContainer();
        Set<Object> result = null;
        if (container instanceof LoopExp && ((LoopExp)container).getBody() == e) {
            Variable resultVariable;
            result = new HashSet<Variable>();
            for (org.eclipse.ocl.expressions.Variable v : ((LoopExp)container).getIterator()) {
                result.add((Variable)v);
            }
            if (container instanceof IterateExp && (resultVariable = (Variable)((IterateExp)container).getResult()) != null) {
                result.add(resultVariable);
            }
        } else if (container instanceof LetExp && ((LetExp)container).getIn() == e) {
            if (result == null) {
                result = new HashSet();
            }
            result.add((Variable)((LetExp)container).getVariable());
        } else {
            Set<OperationCallExp> calls = operationBodyToCallMapper.getCallsOf(e);
            if (!calls.isEmpty()) {
                result = AbstractTracebackStep.addAll(result, operationBodyToCallMapper.getSelfVariablesUsedInBody(e));
                result = AbstractTracebackStep.addAll(result, operationBodyToCallMapper.getParameterVariablesUsedInBody(e));
            } else if (e == OclHelper.getRootExpression((EObject)e)) {
                result = AbstractTracebackStep.addAll(result, operationBodyToCallMapper.getSelfVariablesUsedInBody(e));
            }
        }
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    private static <T> Set<T> addAll(Set<T> to, Collection<T> what) {
        if (to == null) {
            to = new HashSet<T>();
        }
        to.addAll(what);
        return to;
    }

    protected static Set<Variable> getAllVariablesInScope(OCLExpression e, OperationBodyToCallMapper operationBodyToCallMapper) {
        HashSet<Variable> result = new HashSet<Variable>();
        OCLExpression cursor = e;
        while (cursor != null) {
            if (cursor instanceof OCLExpression) {
                result.addAll(AbstractTracebackStep.getVariablesScopedByExpression(cursor, operationBodyToCallMapper));
            }
            cursor = cursor.eContainer();
        }
        return result;
    }

    private static OCLExpression commonCompositionParent(OCLExpression first, OCLExpression second) {
        HashSet<OCLExpression> firstsContainersIncludingFirst = new HashSet<OCLExpression>();
        OCLExpression firstsContainer = first;
        while (firstsContainer != null && firstsContainer instanceof OCLExpression) {
            firstsContainersIncludingFirst.add(firstsContainer);
            firstsContainer = firstsContainer.eContainer();
        }
        OCLExpression secondsContainer = second;
        OCLExpression result = null;
        while (result == null && secondsContainer != null && secondsContainer instanceof OCLExpression) {
            if (firstsContainersIncludingFirst.contains(secondsContainer)) {
                result = secondsContainer;
                continue;
            }
            secondsContainer = secondsContainer.eContainer();
        }
        return result;
    }

    protected TracebackStepAndScopeChange createTracebackStepAndScopeChange(OCLExpression sourceExpression, OCLExpression targetExpression, EClass context, OperationBodyToCallMapper operationBodyToCallMapper, Stack<String> tupleLiteralNamesToLookFor, TracebackStepCache tracebackStepCache) {
        return new TracebackStepAndScopeChange((TracebackStep)tracebackStepCache.getOrCreateNavigationPath(targetExpression, context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, this.oclFactory), this.getVariablesChangingScope(sourceExpression, targetExpression, operationBodyToCallMapper));
    }

    protected TracebackStepAndScopeChangeWithOperationCallExp createTracebackStepAndScopeChange(OCLExpression sourceExpression, OCLExpression targetExpression, OperationCallExp call, EClass context, OperationBodyToCallMapper operationBodyToCallMapper, Stack<String> tupleLiteralNamesToLookFor, TracebackStepCache tracebackStepCache) {
        return new TracebackStepAndScopeChangeWithOperationCallExp((TracebackStep)tracebackStepCache.getOrCreateNavigationPath(targetExpression, context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, this.oclFactory), this.getVariablesChangingScope(sourceExpression, targetExpression, operationBodyToCallMapper), call);
    }

    protected EClass getInnermostClass(EClassifier type) {
        EClass result = null;
        while (!(type instanceof EClass) && type instanceof CollectionType) {
            type = (EClassifier)((CollectionType)type).getElementType();
        }
        if (type instanceof EClass) {
            result = (EClass)type;
        }
        return result;
    }

    protected EClassifier getInnermostElementType(EClassifier type) {
        while (!(type instanceof EClass) && type instanceof CollectionType) {
            type = (EClassifier)((CollectionType)type).getElementType();
        }
        return type;
    }

    protected Stack<String> cloneWithTypeCheck(Stack<String> tupleLiteralNamesToLookFor) {
        if (tupleLiteralNamesToLookFor == null) {
            return null;
        }
        Object clone = tupleLiteralNamesToLookFor.clone();
        if (clone instanceof Stack) {
            Stack newTupleStack = (Stack)clone;
            return newTupleStack;
        }
        throw new ClassCastException("Cloning an instance of Stack<String> didn't return an instance of the same type.");
    }

    private String getAnnotation() {
        return this.annotation;
    }

    private String getVerboseDebugInfo(OperationBodyToCallMapper operationBodyToCallMapper) {
        try {
            if (AnnotatedEObject.IS_IN_DEBUG_MODE) {
                Set<OperationCallExp> calls;
                StringBuilder result = new StringBuilder();
                result.append(" ==== ");
                result.append(this.getClass().getSimpleName());
                result.append(" for expression ====\n ");
                result.append(this.getExpression());
                OCLExpression root = OclHelper.getRootExpression(this.getExpression());
                if (root != this.getExpression()) {
                    result.append("\n ==== in expression =====\n");
                    result.append((String)root.accept((Visitor)HighlightingToStringVisitor.getInstance((EObject)root, this.getExpression())));
                }
                result.append(!(calls = operationBodyToCallMapper.getCallsOf(root)).isEmpty() ? "\n ===== which is the body of operation " + this.formatOperation((EOperation)calls.iterator().next().getReferredOperation()) + " =====" : "");
                return result.toString();
            }
            return "To enable annotations, set the system property org.eclipse.ocl.examples.impactanalyzer.debug to true, e.g., by using the VM argument -Dorg.eclipse.ocl.examples.impactanalyzer.debug=true";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String formatOperation(EOperation operation) {
        StringBuilder result = new StringBuilder(((ENamedElement)operation.eContainer()).getName());
        result.append('.');
        result.append(operation.getName());
        result.append('(');
        boolean first = true;
        for (EParameter param : operation.getEParameters()) {
            if (!first) {
                result.append(", ");
            } else {
                first = false;
            }
            result.append(param.getName());
            result.append(':');
            result.append(param.getEType().getName());
        }
        result.append(')');
        return result.toString();
    }

    protected AnnotatedEObject annotateEObject(AnnotatedEObject fromObject, EObject next) {
        if (AnnotatedEObject.IS_IN_DEBUG_MODE) {
            return new AnnotatedEObject(next, fromObject, this.getAnnotation());
        }
        return new AnnotatedEObject(next, "To enable annotations, set the system property org.eclipse.ocl.examples.impactanalyzer.debug to true, e.g., by using the VM argument -Dorg.eclipse.ocl.examples.impactanalyzer.debug=true");
    }

    protected AnnotatedEObject annotateEObject(AnnotatedEObject object) {
        if (AnnotatedEObject.IS_IN_DEBUG_MODE) {
            return new AnnotatedEObject(object.getAnnotatedObject(), object, this.getAnnotation());
        }
        return object;
    }

    protected Set<AnnotatedEObject> annotate(AnnotatedEObject fromObject, Set<AnnotatedEObject> newResults) {
        if (AnnotatedEObject.IS_IN_DEBUG_MODE) {
            HashSet<AnnotatedEObject> result = new HashSet<AnnotatedEObject>();
            for (AnnotatedEObject newResult : newResults) {
                result.add(new AnnotatedEObject(newResult.getAnnotatedObject(), fromObject, this.getAnnotation()));
            }
            return result;
        }
        return newResults;
    }

    protected OppositeEndFinder getOppositeEndFinder() {
        return this.oppositeEndFinder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TracebackStepAndScopeChange
    implements TracebackStep {
        private final TracebackStep step;
        private final Set<Variable> variablesThatLeaveOrEnterScopeWhenCallingStep;

        public TracebackStepAndScopeChange(TracebackStep step, Set<Variable> variablesThatLeaveOrEnterScopeWhenCallingStep) {
            this.step = step;
            this.variablesThatLeaveOrEnterScopeWhenCallingStep = variablesThatLeaveOrEnterScopeWhenCallingStep;
        }

        @Override
        public OperationCallExpKeyedSet traceback(AnnotatedEObject source, UnusedEvaluationRequestSet pendingUnusedEvalRequests, TracebackCache tracebackCache, Notification changeEvent) {
            UnusedEvaluationRequestSet reducedUnusedEvaluationRequestSet = tracebackCache.getConfiguration().isUnusedDetectionActive() ? (pendingUnusedEvalRequests == null ? null : pendingUnusedEvalRequests.createReducedSet(this.variablesThatLeaveOrEnterScopeWhenCallingStep, tracebackCache.getUnusedEvaluationRequestFactory())) : null;
            return this.step.traceback(source, reducedUnusedEvaluationRequestSet, tracebackCache, changeEvent);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("Unscope ");
            for (Variable v : this.variablesThatLeaveOrEnterScopeWhenCallingStep) {
                result.append(v.getName());
                result.append(", ");
            }
            result.append("then perform ");
            result.append(this.step);
            return result.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TracebackStepAndScopeChangeWithOperationCallExp
    extends TracebackStepAndScopeChange {
        private final OperationCallExp callToWhichResultsAreSpecific;

        public TracebackStepAndScopeChangeWithOperationCallExp(TracebackStep step, Set<Variable> variablesChangingScope, OperationCallExp callToWhichResultsAreSpecific) {
            super(step, variablesChangingScope);
            this.callToWhichResultsAreSpecific = callToWhichResultsAreSpecific;
        }

        @Override
        public OperationCallExpKeyedSet traceback(AnnotatedEObject source, UnusedEvaluationRequestSet pendingUnusedEvalRequests, TracebackCache tracebackCache, Notification changeEvent) {
            OperationCallExpKeyedSet resultsForSourceOrArgument = super.traceback(source, pendingUnusedEvalRequests, tracebackCache, changeEvent);
            OperationCallExpKeyedSet result = tracebackCache.getOperationCallExpKeyedSetFactory().createOperationCallExpKeyedSet(this.callToWhichResultsAreSpecific, resultsForSourceOrArgument);
            return result;
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder(super.toString());
            result.append(", then filter for results specific to OperationCallExp ");
            result.append(this.callToWhichResultsAreSpecific);
            return result.toString();
        }
    }
}

