/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.objectteams.otdt.internal.ui.OTDTUIMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.internal.ui.StorageTypedElement;
import org.eclipse.ui.IEditorInput;

public class BaseMethodCompareElement
extends StorageTypedElement {
    IMethod method = null;

    public BaseMethodCompareElement(IMethod method, String localEncoding) {
        super(localEncoding);
        this.method = method;
    }

    public Image getImage() {
        return null;
    }

    public String getName() {
        return this.method.getElementName();
    }

    public Object getTypeName() {
        return this.method.getDeclaringType().getElementName();
    }

    public String getType() {
        return "java2";
    }

    public IResource getResource() {
        return this.method.getResource();
    }

    protected IStorage fetchContents(IProgressMonitor monitor) throws CoreException {
        return new IStorage(){

            public InputStream getContents() throws CoreException {
                byte[] bytes;
                String contents = BaseMethodCompareElement.this.getExtendedSource(BaseMethodCompareElement.this.method);
                if (contents == null) {
                    contents = OTDTUIMessages.BaseMethodCompareElement_sourceNotFound_text;
                }
                try {
                    bytes = contents.getBytes(BaseMethodCompareElement.this.getCharset());
                }
                catch (UnsupportedEncodingException e) {
                    bytes = contents.getBytes();
                }
                return new ByteArrayInputStream(bytes);
            }

            public IPath getFullPath() {
                return null;
            }

            public String getName() {
                return BaseMethodCompareElement.this.method.getElementName();
            }

            public boolean isReadOnly() {
                return true;
            }

            public <T> T getAdapter(Class<T> adapter) {
                return null;
            }
        };
    }

    private String getExtendedSource(IMethod method) throws JavaModelException {
        ISourceReference sr;
        String parentContent;
        IJavaElement parent = method.getParent();
        if (parent instanceof ISourceReference && (parentContent = (sr = (ISourceReference)parent).getSource()) != null) {
            ISourceRange parentRange = sr.getSourceRange();
            ISourceRange childRange = method.getSourceRange();
            int start = childRange.getOffset() - parentRange.getOffset();
            int end = start + childRange.getLength();
            while (start > 0) {
                char c = parentContent.charAt(start - 1);
                if (c == '\n' || c == '\r') break;
                --start;
            }
            return parentContent.substring(start, end);
        }
        return method.getSource();
    }

    protected IEditorInput getDocumentKey(Object element) {
        return null;
    }
}

