/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.spi.editor;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorSection;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.spi.remote.review.IReviewRemoteFactoryProvider;
import org.eclipse.mylyn.reviews.ui.spi.editor.AbstractReviewTaskEditorPage;
import org.eclipse.mylyn.reviews.ui.spi.factories.IUiContext;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractReviewSection
extends AbstractTaskEditorSection
implements IUiContext {
    protected Composite composite;
    protected FormToolkit toolkit;
    protected boolean modelContentsCurrent;

    protected Control createContent(FormToolkit toolkit, Composite parent) {
        this.toolkit = toolkit;
        this.composite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).applyTo(this.composite);
        return this.composite;
    }

    public Label addTextClient(FormToolkit toolkit, Section section, String text) {
        return this.addTextClient(toolkit, section, text, true);
    }

    public Label addTextClient(FormToolkit toolkit, final Section section, String text, boolean hideOnExpand) {
        final Label label = new Label((Composite)section, 0);
        label.setText("  " + text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        section.setTextClient((Control)label);
        if (hideOnExpand) {
            label.setVisible(!section.isExpanded());
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    label.setVisible(!section.isExpanded());
                }
            });
        }
        return label;
    }

    public static void appendMessage(Section section, String message) {
        Control textClient = section.getTextClient();
        if (textClient instanceof Label && !textClient.isDisposed()) {
            Label textClientLabel = (Label)textClient;
            textClientLabel.setText("  " + message);
            textClientLabel.getParent().layout(true, true);
        }
    }

    public Composite getComposite() {
        return this.composite;
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    @Override
    public TaskEditor getEditor() {
        return this.getTaskEditorPage().getEditor();
    }

    @Override
    public Shell getShell() {
        return this.getTaskEditorPage().getSite().getShell();
    }

    @Override
    public ITask getTask() {
        return this.getTaskEditorPage().getTask();
    }

    public IReview getReview() {
        return this.getReviewEditorPage().getReview();
    }

    @Override
    public TaskRepository getTaskRepository() {
        return this.getReviewEditorPage().getTaskRepository();
    }

    public IRepository getModelRepository() {
        return this.getReview().getRepository();
    }

    @Override
    public IReviewRemoteFactoryProvider getFactoryProvider() {
        return this.getReviewEditorPage().getFactoryProvider();
    }

    public AbstractReviewTaskEditorPage getReviewEditorPage() {
        return (AbstractReviewTaskEditorPage)this.getTaskEditorPage();
    }
}

