/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.internal;

import java.util.Map;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ComponentClass;

public abstract class AbstractToolkitInfo
implements ToolkitInfo {
    public abstract Map<ComponentClass, String> getTypeMapping();

    @Override
    public String registerTesterClass(String componentClassName, String testerClassName) {
        Validate.notNull((Object)componentClassName);
        Validate.notNull((Object)testerClassName);
        Map<ComponentClass, String> typeMapping = this.getTypeMapping();
        for (ComponentClass cc : typeMapping.keySet()) {
            if (!cc.getName().equalsIgnoreCase(componentClassName)) continue;
            return typeMapping.put(cc, testerClassName);
        }
        typeMapping.put(new ComponentClass(componentClassName), testerClassName);
        return null;
    }

    @Override
    public String deregisterTesterClass(String componentClassName) {
        Validate.notNull((Object)componentClassName);
        Map<ComponentClass, String> typeMapping = this.getTypeMapping();
        for (ComponentClass cc : typeMapping.keySet()) {
            if (!cc.getName().equalsIgnoreCase(componentClassName)) continue;
            return typeMapping.remove(cc);
        }
        return null;
    }

    @Override
    public void merge(ToolkitInfo otherToolkit) {
        Validate.notNull((Object)otherToolkit);
        Map<ComponentClass, String> otherTypeMapping = ((AbstractToolkitInfo)otherToolkit).getTypeMapping();
        for (ComponentClass cc : otherTypeMapping.keySet()) {
            this.registerTesterClass(cc.getName(), otherTypeMapping.get(cc));
        }
    }
}

