/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.preferences.database;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.preferences.database.AbstractHostBasedConnectionInfo;

public class OracleConnectionInfo
extends AbstractHostBasedConnectionInfo {
    public static final String DRIVER_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";
    public static final String JDBC_PRE = "jdbc:oracle:thin:@";
    public static final String PROP_NAME_SERVICE = "service";
    private static final String ORACLE_BATCH_WRITING_SIZE = "1000";
    private boolean m_isService = false;

    public OracleConnectionInfo() {
        super(1521);
    }

    @Override
    public String getConnectionUrl() {
        StringBuilder sb = new StringBuilder(JDBC_PRE);
        if (this.m_isService) {
            sb.append("/").append("/");
        }
        sb.append(StringUtils.defaultString((String)this.getHostname())).append(":").append(this.getPort()).append(this.m_isService ? "/" : ":").append(StringUtils.defaultString((String)this.getDatabaseName()));
        return sb.toString();
    }

    @Override
    public String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    public String getBatchWriting() {
        return "Oracle-JDBC";
    }

    @Override
    public String getBatchWritingSize() {
        return ORACLE_BATCH_WRITING_SIZE;
    }

    @Override
    public String getStatisticsCommand() {
        return "begin\nfor tab in (\nselect * from USER_TABLES tab order by TAB.TABLE_NAME\n) loop\nexecute immediate 'analyze table ' || TAB.TABLE_NAME || ' compute statistics';\nend loop;\nend;\n";
    }

    public boolean isService() {
        return this.m_isService;
    }

    public void setService(boolean isService) {
        this.m_isService = isService;
        this.fireConnectionUrlChanged();
    }
}

