/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.core.manipulation.TypeNameMatchCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitCompletion;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.IJavaContext;
import org.eclipse.jdt.internal.corext.template.java.JavaTemplateMessages;
import org.eclipse.jdt.internal.corext.template.java.JavaVariable;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableType;

public class JavaContextCore
extends CompilationUnitContext
implements IJavaContext {
    private CompilationUnitCompletion fCompletion;
    private Set<String> fUsedNames = new HashSet<String>();
    private Map<String, MultiVariable> fVariables = new HashMap<String, MultiVariable>();
    private ImportRewrite fImportRewrite;
    private Set<String> fCompatibleContextTypeIds;

    public JavaContextCore(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ICompilationUnit compilationUnit) {
        super(type, document, completionOffset, completionLength, compilationUnit);
    }

    public JavaContextCore(TemplateContextType type, IDocument document, Position completionPosition, ICompilationUnit compilationUnit) {
        super(type, document, completionPosition, compilationUnit);
    }

    @Override
    public void addCompatibleContextType(String contextTypeId) {
        if (this.fCompatibleContextTypeIds == null) {
            this.fCompatibleContextTypeIds = new HashSet<String>();
        }
        this.fCompatibleContextTypeIds.add(contextTypeId);
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        this.clear();
        if (!this.canEvaluate(template)) {
            throw new TemplateException(JavaTemplateMessages.Context_error_cannot_evaluate);
        }
        TemplateTranslator translator = new TemplateTranslator(){

            protected TemplateVariable createVariable(TemplateVariableType type, String name, int[] offsets) {
                JavaVariable variable = new JavaVariable(type, name, offsets);
                JavaContextCore.this.fVariables.put(name, variable);
                return variable;
            }
        };
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        this.rewriteImports();
        this.clear();
        return buffer;
    }

    private void clear() {
        this.fUsedNames.clear();
        this.fImportRewrite = null;
    }

    public boolean canEvaluate(Template template) {
        if (!this.hasCompatibleContextType(template)) {
            return false;
        }
        if (this.isForceEvaluation()) {
            return true;
        }
        String key = this.getKey().toLowerCase();
        if (key.length() > 0 || !this.isAfterDot()) {
            String templateName = template.getName().toLowerCase();
            return JavaManipulationPlugin.CODEASSIST_SUBSTRING_MATCH_ENABLED ? templateName.contains(key) : templateName.startsWith(key);
        }
        return false;
    }

    private boolean isAfterDot() {
        try {
            IDocument document = this.getDocument();
            int offset = this.getCompletionOffset();
            return document.get(offset - 1, 1).charAt(0) == '.';
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean hasCompatibleContextType(Template template) {
        String key = this.getKey();
        if (template.matches(key, this.getContextType().getId())) {
            return true;
        }
        if (this.fCompatibleContextTypeIds == null) {
            return false;
        }
        Iterator<String> iter = this.fCompatibleContextTypeIds.iterator();
        while (iter.hasNext()) {
            if (!template.matches(key, iter.next())) continue;
            return true;
        }
        return false;
    }

    public int getStart() {
        if (this.isManaged() && this.getCompletionLength() > 0) {
            return super.getStart();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                --start;
            }
            while (start != end && Character.isWhitespace(document.getChar(start))) {
                ++start;
            }
            if (start == end) {
                start = this.getCompletionOffset();
            }
            return start;
        }
        catch (BadLocationException badLocationException) {
            return super.getStart();
        }
    }

    public int getEnd() {
        if (this.isManaged() || this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != end && Character.isWhitespace(document.getChar(end - 1))) {
                --end;
            }
            return end;
        }
        catch (BadLocationException badLocationException) {
            return super.getEnd();
        }
    }

    public String getKey() {
        if (this.getCompletionLength() == 0) {
            return super.getKey();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getStart();
            int end = this.getCompletionOffset();
            return start <= end ? document.get(start, end - start) : "";
        }
        catch (BadLocationException badLocationException) {
            return super.getKey();
        }
    }

    public char getCharacterBeforeStart() {
        int start = this.getStart();
        try {
            return start == 0 ? (char)' ' : this.getDocument().getChar(start - 1);
        }
        catch (BadLocationException badLocationException) {
            return ' ';
        }
    }

    @Override
    public void handleException(Exception e) {
        JavaManipulationPlugin.log(e);
    }

    private CompilationUnitCompletion getCompletion() {
        ICompilationUnit compilationUnit = this.getCompilationUnit();
        if (this.fCompletion == null) {
            this.fCompletion = new CompilationUnitCompletion(compilationUnit);
            if (compilationUnit != null) {
                try {
                    compilationUnit.codeComplete(this.getStart(), (CompletionRequestor)this.fCompletion);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        return this.fCompletion;
    }

    @Override
    public CompilationUnitCompletion.Variable[] getArrays() {
        CompilationUnitCompletion.Variable[] arrays = this.getCompletion().findArraysInCurrentScope();
        this.arrange(arrays);
        return arrays;
    }

    private void arrange(CompilationUnitCompletion.Variable[] variables) {
        Arrays.sort(variables, new Comparator<CompilationUnitCompletion.Variable>(){

            @Override
            public int compare(CompilationUnitCompletion.Variable o1, CompilationUnitCompletion.Variable o2) {
                return this.rank(o1) - this.rank(o2);
            }

            private int rank(CompilationUnitCompletion.Variable l) {
                return JavaContextCore.this.fUsedNames.contains(l.getName()) ? 1 : 0;
            }
        });
    }

    @Override
    public CompilationUnitCompletion.Variable[] getLocalVariables(String type) {
        CompilationUnitCompletion.Variable[] localVariables = this.getCompletion().findLocalVariables(type);
        this.arrange(localVariables);
        return localVariables;
    }

    @Override
    public CompilationUnitCompletion.Variable[] getFields(String type) {
        CompilationUnitCompletion.Variable[] fields = this.getCompletion().findFieldVariables(type);
        this.arrange(fields);
        return fields;
    }

    @Override
    public CompilationUnitCompletion.Variable[] getIterables() {
        CompilationUnitCompletion.Variable[] iterables = this.getCompletion().findIterablesInCurrentScope();
        this.arrange(iterables);
        return iterables;
    }

    @Override
    public void markAsUsed(String name) {
        this.fUsedNames.add(name);
    }

    @Override
    public String[] suggestVariableNames(String type) throws IllegalArgumentException {
        String[] excludes = this.computeExcludes();
        String[] result = this.suggestVariableName(type, excludes);
        return result;
    }

    public String[] computeExcludes() {
        String[] excludes = this.getCompletion().getLocalVariableNames();
        if (!this.fUsedNames.isEmpty()) {
            String[] allExcludes = new String[this.fUsedNames.size() + excludes.length];
            System.arraycopy(excludes, 0, allExcludes, 0, excludes.length);
            System.arraycopy(this.fUsedNames.toArray(), 0, allExcludes, 0, this.fUsedNames.size());
            excludes = allExcludes;
        }
        return excludes;
    }

    private String[] suggestVariableName(String type, String[] excludes) throws IllegalArgumentException {
        int dim = 0;
        while (type.endsWith("[]")) {
            ++dim;
            type = type.substring(0, type.length() - 2);
        }
        IJavaProject project = this.getJavaProject();
        if (project != null) {
            return StubUtility.getVariableNameSuggestions(5, project, type, dim, Arrays.asList(excludes), true);
        }
        return new String[]{Signature.getSimpleName((String)type).toLowerCase()};
    }

    @Override
    public String addImport(String type) {
        if (this.isReadOnly()) {
            return type;
        }
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu == null) {
            return type;
        }
        try {
            boolean qualified;
            boolean bl = qualified = type.indexOf(46) != -1;
            if (!qualified) {
                SimpleName nameNode;
                IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{cu.getJavaProject()});
                TypeNameMatch[] matches = this.findAllTypes(type, searchScope, nameNode = null, null, cu);
                if (matches.length != 1) {
                    return type;
                }
                type = matches[0].getFullyQualifiedName();
            }
            CompilationUnit root = this.getASTRoot(cu);
            if (this.fImportRewrite == null) {
                this.fImportRewrite = root == null ? StubUtility.createImportRewrite(cu, true) : StubUtility.createImportRewrite(root, true);
            }
            ContextSensitiveImportRewriteContext context = root == null ? null : new ContextSensitiveImportRewriteContext(root, this.getCompletionOffset(), this.fImportRewrite);
            return this.fImportRewrite.addImport(type, context);
        }
        catch (JavaModelException e) {
            this.handleException((Exception)((Object)e));
            return type;
        }
    }

    public String addStaticImport(String qualifiedMemberName) {
        if (this.isReadOnly()) {
            return qualifiedMemberName;
        }
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu == null) {
            return qualifiedMemberName;
        }
        int memberOffset = qualifiedMemberName.lastIndexOf(46);
        if (memberOffset == -1) {
            return qualifiedMemberName;
        }
        String typeName = qualifiedMemberName.substring(0, memberOffset);
        String memberName = qualifiedMemberName.substring(memberOffset + 1, qualifiedMemberName.length());
        try {
            boolean isField;
            if ("*".equals(memberName)) {
                isField = true;
            } else {
                IJavaProject javaProject = cu.getJavaProject();
                IType type = javaProject.findType(typeName);
                if (type == null) {
                    return qualifiedMemberName;
                }
                IField field = type.getField(memberName);
                if (field.exists()) {
                    isField = true;
                } else if (this.hasMethod(type, memberName)) {
                    isField = false;
                } else {
                    return qualifiedMemberName;
                }
            }
            CompilationUnit root = this.getASTRoot(cu);
            if (this.fImportRewrite == null) {
                this.fImportRewrite = root == null ? StubUtility.createImportRewrite(cu, true) : StubUtility.createImportRewrite(root, true);
            }
            ContextSensitiveImportRewriteContext context = root == null ? null : new ContextSensitiveImportRewriteContext(root, this.getCompletionOffset(), this.fImportRewrite);
            return this.fImportRewrite.addStaticImport(typeName, memberName, isField, (ImportRewrite.ImportRewriteContext)context);
        }
        catch (JavaModelException e) {
            this.handleException((Exception)((Object)e));
            return typeName;
        }
    }

    private boolean hasMethod(IType type, String name) throws JavaModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (name.equals(method.getElementName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void rewriteImports() {
        if (this.fImportRewrite == null) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu == null) {
            return;
        }
        try {
            Position position = new Position(this.getCompletionOffset(), 0);
            IDocument document = this.getDocument();
            String category = "__template_position_importer" + System.currentTimeMillis();
            DefaultPositionUpdater updater = new DefaultPositionUpdater(category);
            document.addPositionCategory(category);
            document.addPositionUpdater((IPositionUpdater)updater);
            document.addPosition(position);
            try {
                try {
                    JavaModelUtil.applyEdit(cu, this.fImportRewrite.rewriteImports(null), false, null);
                    this.setCompletionOffset(position.getOffset());
                }
                catch (CoreException e) {
                    this.handleException((Exception)((Object)e));
                    document.removePosition(position);
                    document.removePositionUpdater((IPositionUpdater)updater);
                    document.removePositionCategory(category);
                }
            }
            finally {
                document.removePosition(position);
                document.removePositionUpdater((IPositionUpdater)updater);
                document.removePositionCategory(category);
            }
        }
        catch (BadLocationException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BadPositionCategoryException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private CompilationUnit getASTRoot(ICompilationUnit compilationUnit) {
        return SharedASTProviderCore.getAST((ITypeRoot)compilationUnit, SharedASTProviderCore.WAIT_NO, (IProgressMonitor)new NullProgressMonitor());
    }

    private TypeNameMatch[] findAllTypes(String simpleTypeName, IJavaSearchScope searchScope, SimpleName nameNode, IProgressMonitor monitor, ICompilationUnit cu) throws JavaModelException {
        boolean is50OrHigher = JavaModelUtil.is50OrHigher(cu.getJavaProject());
        int typeKinds = 126;
        if (nameNode != null) {
            typeKinds = ASTResolving.getPossibleTypeKinds((ASTNode)nameNode, is50OrHigher);
        }
        ArrayList<TypeNameMatch> typeInfos = new ArrayList<TypeNameMatch>();
        TypeNameMatchCollector requestor = new TypeNameMatchCollector(typeInfos);
        new SearchEngine().searchAllTypeNames(null, 0, simpleTypeName.toCharArray(), 8, this.getSearchForConstant(typeKinds), searchScope, (TypeNameMatchRequestor)requestor, 1, monitor);
        ArrayList<TypeNameMatch> typeRefsFound = new ArrayList<TypeNameMatch>(typeInfos.size());
        for (TypeNameMatch curr : typeInfos) {
            if (curr.getPackageName().length() <= 0 || !this.isOfKind(curr, typeKinds, is50OrHigher) || !this.isVisible(curr, cu)) continue;
            typeRefsFound.add(curr);
        }
        return typeRefsFound.toArray(new TypeNameMatch[typeRefsFound.size()]);
    }

    private int getSearchForConstant(int typeKinds) {
        switch (typeKinds & 0x1E) {
            case 2: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 16: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 6: {
                return 10;
            }
            case 18: {
                return 9;
            }
        }
        return 0;
    }

    private boolean isOfKind(TypeNameMatch curr, int typeKinds, boolean is50OrHigher) {
        int flags = curr.getModifiers();
        if (Flags.isAnnotation((int)flags)) {
            return is50OrHigher && (typeKinds & 8) != 0;
        }
        if (Flags.isEnum((int)flags)) {
            return is50OrHigher && (typeKinds & 0x10) != 0;
        }
        if (Flags.isInterface((int)flags)) {
            return (typeKinds & 4) != 0;
        }
        return (typeKinds & 2) != 0;
    }

    private boolean isVisible(TypeNameMatch curr, ICompilationUnit cu) {
        int flags = curr.getModifiers();
        if (Flags.isPrivate((int)flags)) {
            return false;
        }
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags)) {
            return true;
        }
        return curr.getPackageName().equals(cu.getParent().getElementName());
    }

    @Override
    public TemplateVariable getTemplateVariable(String name) {
        TemplateVariable variable = this.fVariables.get(name);
        if (variable != null && !variable.isResolved()) {
            this.getContextType().resolve(variable, (TemplateContext)this);
        }
        return variable;
    }

    @Override
    public void addDependency(MultiVariable master, MultiVariable slave) {
    }
}

