/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOFeatureType;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.DBAnnotation;
import org.eclipse.emf.cdo.server.internal.db.ObjectIDIterator;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBSchemaTransaction;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.spi.db.DBAdapter;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public abstract class AbstractMappingStrategy
extends Lifecycle
implements IMappingStrategy {
    protected static final String NAME_SEPARATOR = "_";
    protected static final String TYPE_PREFIX_FEATURE = "F";
    protected static final String TYPE_PREFIX_CLASS = "C";
    protected static final String TYPE_PREFIX_PACKAGE = "P";
    protected static final String GENERAL_PREFIX = "X";
    protected static final String GENERAL_SUFFIX = "0";
    protected static final String CDO_SET_PREFIX = "cdo_set_";
    protected static final String FEATURE_TABLE_SUFFIX = "_list";
    private IDBStore store;
    private Map<String, String> properties;
    private ConcurrentMap<EClass, IClassMapping> classMappings = new ConcurrentHashMap<EClass, IClassMapping>();
    private boolean allClassMappingsCreated;
    private Set<CDOFeatureType> forceIndexes;

    @Override
    public synchronized Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    @Override
    public synchronized void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public int getMaxTableNameLength() {
        String value = this.getProperties().get("maxTableNameLength");
        return value == null ? this.store.getDBAdapter().getMaxTableNameLength() : Integer.valueOf(value).intValue();
    }

    public int getMaxFieldNameLength() {
        String value = this.getProperties().get("maxFieldNameLength");
        return value == null ? this.store.getDBAdapter().getMaxFieldNameLength() : Integer.valueOf(value).intValue();
    }

    public boolean isQualifiedNames() {
        String value = this.getProperties().get("qualifiedNames");
        return value == null ? false : Boolean.valueOf(value);
    }

    public boolean isForceNamesWithID() {
        String value = this.getProperties().get("forceNamesWithID");
        return value == null ? false : Boolean.valueOf(value);
    }

    public String getTableNamePrefix() {
        String value = this.getProperties().get("tableNamePrefix");
        return StringUtil.safe((String)value);
    }

    public Set<CDOFeatureType> getForceIndexes() {
        if (this.forceIndexes == null) {
            this.forceIndexes = AbstractMappingStrategy.doGetForceIndexes(this);
        }
        return this.forceIndexes;
    }

    @Override
    public final IDBStore getStore() {
        return this.store;
    }

    @Override
    public final void setStore(IDBStore dbStore) {
        this.checkInactive();
        this.store = dbStore;
    }

    protected final IMetaDataManager getMetaDataManager() {
        return this.getStore().getMetaDataManager();
    }

    @Override
    public void handleRevisions(IDBStoreAccessor accessor, EClass eClass, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        if (eClass == null) {
            Collection<IClassMapping> values = this.getClassMappings().values();
            for (IClassMapping mapping : values) {
                mapping.handleRevisions(accessor, branch, timeStamp, exactTime, handler);
            }
        } else {
            IClassMapping classMapping = this.getClassMapping(eClass);
            classMapping.handleRevisions(accessor, branch, timeStamp, exactTime, handler);
        }
    }

    @Override
    public Set<CDOID> readChangeSet(IDBStoreAccessor accessor, OMMonitor monitor, CDOChangeSetSegment[] segments) {
        HashSet<CDOID> result = new HashSet<CDOID>();
        Collection<IClassMapping> classMappings = this.getClassMappings().values();
        monitor.begin((double)classMappings.size());
        try {
            for (IClassMapping mapping : classMappings) {
                OMMonitor.Async async = monitor.forkAsync();
                try {
                    Set<CDOID> ids = mapping.readChangeSet(accessor, segments);
                    result.addAll(ids);
                }
                finally {
                    async.stop();
                }
            }
            HashSet<CDOID> hashSet = result;
            return hashSet;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public CloseableIterator<CDOID> readObjectIDs(IDBStoreAccessor accessor) {
        Collection<EClass> classes = this.getClassesWithObjectInfo();
        final Iterator<EClass> classIt = classes.iterator();
        return new ObjectIDIterator(this, accessor){
            private PreparedStatement currentStatement;

            @Override
            protected ResultSet getNextResultSet() {
                if (classIt.hasNext()) {
                    EClass eClass = (EClass)classIt.next();
                    IClassMapping mapping = AbstractMappingStrategy.this.getClassMapping(eClass);
                    this.currentStatement = mapping.createObjectIDStatement(this.getAccessor());
                    ResultSet resultSet = null;
                    try {
                        resultSet = this.currentStatement.executeQuery();
                        return resultSet;
                    }
                    catch (Exception ex) {
                        DBUtil.close((ResultSet)resultSet);
                        this.releaseCurrentStatement();
                        throw new DBException((Throwable)ex);
                    }
                }
                return null;
            }

            @Override
            protected void closeCurrentResultSet() {
                super.closeCurrentResultSet();
                this.releaseCurrentStatement();
            }

            private void releaseCurrentStatement() {
                DBUtil.close((Statement)this.currentStatement);
                this.currentStatement = null;
            }
        };
    }

    protected abstract Collection<EClass> getClassesWithObjectInfo();

    private String getTableNamePrefix(EModelElement element) {
        EObject eContainer;
        String prefix = StringUtil.safe((String)DBAnnotation.TABLE_NAME_PREFIX.getValue(element));
        if (prefix.length() != 0 && !prefix.endsWith(NAME_SEPARATOR)) {
            prefix = String.valueOf(prefix) + NAME_SEPARATOR;
        }
        if ((eContainer = element.eContainer()) instanceof EModelElement) {
            EModelElement parent = (EModelElement)eContainer;
            prefix = String.valueOf(this.getTableNamePrefix(parent)) + prefix;
        }
        return prefix;
    }

    @Override
    public String getTableName(ENamedElement element) {
        String prefix;
        String name = null;
        String typePrefix = null;
        if (element instanceof EClass) {
            typePrefix = TYPE_PREFIX_CLASS;
            name = DBAnnotation.TABLE_NAME.getValue((EModelElement)element);
            if (name == null) {
                name = this.isQualifiedNames() ? EMFUtil.getQualifiedName((EClassifier)((EClass)element), (String)NAME_SEPARATOR) : element.getName();
            }
        } else if (element instanceof EPackage) {
            typePrefix = TYPE_PREFIX_PACKAGE;
            name = DBAnnotation.TABLE_NAME.getValue((EModelElement)element);
            if (name == null) {
                name = this.isQualifiedNames() ? EMFUtil.getQualifiedName((EPackage)((EPackage)element), (String)NAME_SEPARATOR) : element.getName();
            }
        } else {
            throw new ImplementationError("Unknown element: " + element);
        }
        if ((prefix = this.getTableNamePrefix()).length() != 0 && !prefix.endsWith(NAME_SEPARATOR)) {
            prefix = String.valueOf(prefix) + NAME_SEPARATOR;
        }
        prefix = String.valueOf(prefix) + this.getTableNamePrefix((EModelElement)element);
        String suffix = String.valueOf(typePrefix) + this.getUniqueID(element);
        int maxTableNameLength = this.getMaxTableNameLength();
        return this.getName(String.valueOf(prefix) + name, suffix, maxTableNameLength);
    }

    @Override
    public String getTableName(EClass eClass, EStructuralFeature feature) {
        String name = DBAnnotation.TABLE_NAME.getValue((EModelElement)eClass);
        if (name == null) {
            name = this.isQualifiedNames() ? EMFUtil.getQualifiedName((EClassifier)eClass, (String)NAME_SEPARATOR) : eClass.getName();
        }
        name = String.valueOf(name) + NAME_SEPARATOR;
        name = String.valueOf(name) + feature.getName();
        name = String.valueOf(name) + FEATURE_TABLE_SUFFIX;
        String prefix = this.getTableNamePrefix();
        if (prefix.length() != 0 && !prefix.endsWith(NAME_SEPARATOR)) {
            prefix = String.valueOf(prefix) + NAME_SEPARATOR;
        }
        prefix = String.valueOf(prefix) + this.getTableNamePrefix((EModelElement)feature);
        String suffix = TYPE_PREFIX_FEATURE + this.getUniqueID((ENamedElement)feature);
        int maxTableNameLength = this.getMaxTableNameLength();
        return this.getName(String.valueOf(prefix) + name, suffix, maxTableNameLength);
    }

    @Override
    public String getFieldName(EStructuralFeature feature) {
        String name = DBAnnotation.COLUMN_NAME.getValue((EModelElement)feature);
        if (name == null) {
            name = this.getName(feature.getName(), TYPE_PREFIX_FEATURE + this.getUniqueID((ENamedElement)feature), this.getMaxFieldNameLength());
        }
        return name;
    }

    public String getUnsettableFieldName(EStructuralFeature feature) {
        String name = DBAnnotation.COLUMN_NAME.getValue((EModelElement)feature);
        if (name != null) {
            return CDO_SET_PREFIX + name;
        }
        return this.getName(CDO_SET_PREFIX + feature.getName(), TYPE_PREFIX_FEATURE + this.getUniqueID((ENamedElement)feature), this.getMaxFieldNameLength());
    }

    private String getName(String name, String suffix, int maxLength) {
        boolean forceNamesWithID;
        if (!this.store.getDBAdapter().isValidFirstChar(name.charAt(0))) {
            name = GENERAL_PREFIX + name;
        }
        if (!(forceNamesWithID = this.isForceNamesWithID()) && this.store.getDBAdapter().isReservedWord(name)) {
            name = String.valueOf(name) + GENERAL_SUFFIX;
        }
        if (name.length() > maxLength || forceNamesWithID) {
            suffix = NAME_SEPARATOR + suffix.replace('-', 'S');
            int length = Math.min(name.length(), maxLength - suffix.length());
            if (length < 0) {
                throw new IllegalStateException("Suffix is too long: " + suffix);
            }
            name = String.valueOf(name.substring(0, length)) + suffix;
        }
        return name;
    }

    private String getUniqueID(ENamedElement element) {
        IStoreAccessor.CommitContext commitContext = StoreThreadLocal.getCommitContext();
        long timeStamp = commitContext != null ? commitContext.getBranchPoint().getTimeStamp() : -1L;
        IMetaDataManager metaDataManager = this.getMetaDataManager();
        CDOID result = metaDataManager.getMetaID((EModelElement)element, timeStamp);
        StringBuilder builder = new StringBuilder();
        CDOIDUtil.write((StringBuilder)builder, (CDOID)result);
        return builder.toString();
    }

    @Override
    public void createMapping(Connection connection, InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        monitor.begin();
        OMMonitor.Async async = null;
        try {
            if (packageUnits != null && packageUnits.length != 0) {
                async = monitor.forkAsync();
                this.mapPackageUnits(packageUnits, connection, false);
            }
        }
        finally {
            if (async != null) {
                async.stop();
            }
            monitor.done();
        }
    }

    @Override
    public void removeMapping(Connection connection, InternalCDOPackageUnit[] packageUnits) {
        this.mapPackageUnits(packageUnits, connection, true);
    }

    protected Set<IClassMapping> mapPackageUnits(InternalCDOPackageUnit[] packageUnits, Connection connection, boolean unmap) {
        HashSet<IClassMapping> classMappings = new HashSet<IClassMapping>();
        if (packageUnits != null && packageUnits.length != 0) {
            InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits;
            int n = packageUnits.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                InternalCDOPackageInfo[] packageInfos = packageUnit.getPackageInfos();
                this.mapPackageInfos(packageInfos, connection, unmap, classMappings);
                ++n2;
            }
        }
        return classMappings;
    }

    private void mapPackageInfos(InternalCDOPackageInfo[] packageInfos, Connection connection, boolean unmap, Set<IClassMapping> classMappings) {
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageInfos;
        int n = packageInfos.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            EPackage ePackage = packageInfo.getEPackage();
            EClass[] persistentClasses = EMFUtil.getPersistentClasses((EPackage)ePackage);
            this.mapClasses(persistentClasses, connection, unmap, classMappings);
            ++n2;
        }
    }

    private void mapClasses(EClass[] eClasses, Connection connection, boolean unmap, Set<IClassMapping> classMappings) {
        EClass[] eClassArray = eClasses;
        int n = eClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String mappingAnnotation;
            EClass eClass = eClassArray[n2];
            if (!(eClass.isInterface() || eClass.isAbstract() || (mappingAnnotation = DBAnnotation.TABLE_MAPPING.getValue((EModelElement)eClass)) != null && mappingAnnotation.equalsIgnoreCase("NONE"))) {
                IClassMapping classMapping;
                IClassMapping iClassMapping = classMapping = unmap ? this.removeClassMapping(eClass, connection) : this.createClassMapping(eClass);
                if (classMapping != null) {
                    classMappings.add(classMapping);
                }
            }
            ++n2;
        }
    }

    private IClassMapping createClassMapping(EClass eClass) {
        IClassMapping classMapping = this.doCreateClassMapping(eClass);
        if (classMapping != null) {
            this.classMappings.put(eClass, classMapping);
        }
        return classMapping;
    }

    private IClassMapping removeClassMapping(EClass eClass, Connection connection) {
        IClassMapping classMapping = (IClassMapping)this.classMappings.get(eClass);
        if (classMapping != null) {
            IDBSchema workingCopy = null;
            try (IDBSchemaTransaction schemaTransaction = null;){
                for (IDBTable table : classMapping.getDBTables()) {
                    String name;
                    if (table == null || (name = table.getName()) == null) continue;
                    if (workingCopy == null) {
                        DBAdapter dbAdapter = (DBAdapter)this.store.getDBAdapter();
                        IDBDatabase database = this.store.getDatabase();
                        schemaTransaction = dbAdapter.openSchemaTransaction(database, (IDBConnection)connection);
                        workingCopy = schemaTransaction.getWorkingCopy();
                    }
                    workingCopy.removeTable(name);
                }
                if (schemaTransaction != null) {
                    schemaTransaction.commit();
                }
            }
            this.classMappings.remove(eClass);
        }
        return classMapping;
    }

    protected abstract IClassMapping doCreateClassMapping(EClass var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IClassMapping getClassMapping(EClass eClass) {
        if (!this.isMapped(eClass)) {
            throw new IllegalArgumentException("Class is not mapped: " + eClass);
        }
        IClassMapping result = (IClassMapping)this.classMappings.get(eClass);
        if (result == null) {
            ConcurrentMap<EClass, IClassMapping> concurrentMap = this.classMappings;
            synchronized (concurrentMap) {
                result = (IClassMapping)this.classMappings.get(eClass);
                if (result == null) {
                    result = this.createClassMapping(eClass);
                }
            }
        }
        return result;
    }

    @Override
    public final Map<EClass, IClassMapping> getClassMappings() {
        return this.getClassMappings(true);
    }

    @Override
    public final Map<EClass, IClassMapping> getClassMappings(boolean createOnDemand) {
        return this.doGetClassMappings(createOnDemand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<EClass, IClassMapping> doGetClassMappings(boolean createOnDemand) {
        if (createOnDemand) {
            ConcurrentMap<EClass, IClassMapping> concurrentMap = this.classMappings;
            synchronized (concurrentMap) {
                if (!this.allClassMappingsCreated) {
                    this.createAllClassMappings();
                    this.allClassMappingsCreated = true;
                }
            }
        }
        return this.classMappings;
    }

    private void createAllClassMappings() {
        InternalRepository repository = (InternalRepository)this.getStore().getRepository();
        InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry(false);
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageRegistry.getPackageInfos();
        int n = internalCDOPackageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            for (EClassifier eClassifier : packageInfo.getEPackage().getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || !this.isMapped(eClass = (EClass)eClassifier)) continue;
                this.getClassMapping(eClass);
            }
            ++n2;
        }
    }

    protected abstract boolean isMapped(EClass var1);

    @Override
    public ITypeMapping createValueMapping(EStructuralFeature feature) {
        ITypeMapping.Provider provider = this.getTypeMappingProvider();
        return provider.createTypeMapping(this, feature);
    }

    protected ITypeMapping.Provider getTypeMappingProvider() {
        return ITypeMapping.Provider.INSTANCE;
    }

    @Override
    public final IListMapping createListMapping(EClass containingClass, EStructuralFeature feature) {
        this.checkArg(feature.isMany(), "Only many-valued features allowed");
        return this.doCreateListMapping(containingClass, feature);
    }

    public abstract IListMapping doCreateListMapping(EClass var1, EStructuralFeature var2);

    protected void doDeactivate() throws Exception {
        this.deactivateClassMappings();
        super.doDeactivate();
    }

    protected void deactivateClassMappings() {
        for (IClassMapping classMapping : this.classMappings.values()) {
            Exception exception = LifecycleUtil.deactivate((Object)classMapping);
            if (exception == null) continue;
            OM.LOG.warn((Throwable)exception);
        }
    }

    private static Set<CDOFeatureType> doGetForceIndexes(IMappingStrategy mappingStrategy) {
        return CDOFeatureType.readCombination((String)mappingStrategy.getProperties().get("forceIndexes"));
    }

    public static Set<CDOFeatureType> getForceIndexes(IMappingStrategy mappingStrategy) {
        if (mappingStrategy instanceof AbstractMappingStrategy) {
            return ((AbstractMappingStrategy)mappingStrategy).getForceIndexes();
        }
        return AbstractMappingStrategy.doGetForceIndexes(mappingStrategy);
    }

    public static boolean isEagerTableCreation(IMappingStrategy mappingStrategy) {
        String value = mappingStrategy.getProperties().get("eagerTableCreation");
        return value == null ? false : Boolean.valueOf(value);
    }
}

