/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.lock;

import java.util.Map;
import java.util.Random;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockAreaImpl;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockChangeInfoImpl;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockOwnerImpl;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockStateImpl;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.RWOLockManager;

public final class CDOLockUtil {
    private static final int DURABLE_SESSION_ID = 0;
    private static final int DURABLE_VIEW_ID = 0;

    private CDOLockUtil() {
    }

    public static CDOLockState copyLockState(CDOLockState lockState) {
        CheckUtil.checkArg((boolean)(lockState instanceof CDOLockStateImpl), (String)"lockState instanceof CDOLockStateImpl");
        return ((CDOLockStateImpl)lockState).copy();
    }

    public static CDOLockState createLockState(Object target) {
        return new CDOLockStateImpl(target);
    }

    public static CDOLockState createLockState(RWOLockManager.LockState<Object, ? extends CDOCommonView> lockState) {
        CDOCommonView writeOptionOwner;
        CheckUtil.checkArg(lockState, (String)"lockState");
        CDOLockStateImpl cdoLockState = new CDOLockStateImpl(lockState.getLockedObject());
        for (CDOCommonView view : lockState.getReadLockOwners()) {
            int viewID;
            int sessionID;
            boolean isDurableView;
            String durableLockingID = view.getDurableLockingID();
            CDOCommonSession session = view.getSession();
            boolean bl = isDurableView = session == null;
            if (isDurableView) {
                sessionID = 0;
                viewID = 0;
            } else {
                sessionID = session.getSessionID();
                viewID = view.getViewID();
            }
            CDOLockOwnerImpl owner = new CDOLockOwnerImpl(sessionID, viewID, durableLockingID, isDurableView);
            cdoLockState.addReadLockOwner(owner);
        }
        CDOCommonView writeLockOwner = (CDOCommonView)lockState.getWriteLockOwner();
        if (writeLockOwner != null) {
            CDOLockOwner owner = CDOLockUtil.createLockOwner(writeLockOwner);
            cdoLockState.setWriteLockOwner(owner);
        }
        if ((writeOptionOwner = (CDOCommonView)lockState.getWriteOptionOwner()) != null) {
            CDOLockOwner owner = CDOLockUtil.createLockOwner(writeOptionOwner);
            cdoLockState.setWriteOptionOwner(owner);
        }
        return cdoLockState;
    }

    public static CDOLockOwner createLockOwner(CDOCommonView view) {
        CDOCommonSession session = view.getSession();
        String durableLockingID = view.getDurableLockingID();
        if (session != null) {
            int sessionID = session.getSessionID();
            int viewID = view.getViewID();
            return new CDOLockOwnerImpl(sessionID, viewID, durableLockingID, false);
        }
        CheckUtil.checkNull((Object)durableLockingID, (String)"durableLockingID");
        return new CDOLockOwnerImpl(0, 0, durableLockingID, true);
    }

    public static CDOLockChangeInfo createLockChangeInfo(long timestamp, CDOLockOwner lockOwner, CDOBranch branch, CDOLockChangeInfo.Operation op, IRWLockManager.LockType lockType, CDOLockState[] cdoLockStates) {
        return new CDOLockChangeInfoImpl(branch.getPoint(timestamp), lockOwner, cdoLockStates, op, lockType);
    }

    public static CDOLockChangeInfo createLockChangeInfo() {
        return new CDOLockChangeInfoImpl();
    }

    public static CDOLockChangeInfo createLockChangeInfo(long timestamp, CDOCommonView view, CDOBranch viewedBranch, CDOLockChangeInfo.Operation op, IRWLockManager.LockType lockType, CDOLockState[] cdoLockStates) {
        CDOLockOwner lockOwner = CDOLockUtil.createLockOwner(view);
        return CDOLockUtil.createLockChangeInfo(timestamp, lockOwner, viewedBranch, op, lockType, cdoLockStates);
    }

    public static IDurableLockingManager.LockArea createLockArea(String durableLockingID, String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        return new CDOLockAreaImpl(durableLockingID, userID, branchPoint, readOnly, locks);
    }

    public static IDurableLockingManager.LockArea createLockArea(String durableLockingID) {
        return new CDOLockAreaImpl(durableLockingID);
    }

    public static String createDurableLockingID() {
        return CDOLockUtil.createDurableLockingID(32);
    }

    public static String createDurableLockingID(int bytes) {
        byte[] buffer = new byte[bytes];
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(buffer);
        return HexUtil.bytesToHex((byte[])buffer);
    }
}

