/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.classpath;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.gradle.tooling.model.eclipse.AccessRule;
import org.gradle.tooling.model.eclipse.ClasspathAttribute;
import org.gradle.tooling.model.eclipse.EclipseClasspathEntry;

public final class ClasspathUtils {
    private ClasspathUtils() {
    }

    public static IAccessRule[] createAccessRules(EclipseClasspathEntry entry) {
        ArrayList rules = Lists.newArrayList((Iterable)entry.getAccessRules());
        IAccessRule[] accessRules = new IAccessRule[rules.size()];
        for (int i = 0; i < rules.size(); ++i) {
            AccessRule rule = (AccessRule)rules.get(i);
            accessRules[i] = JavaCore.newAccessRule((IPath)new Path(rule.getPattern()), (int)rule.getKind());
        }
        return accessRules;
    }

    public static IClasspathAttribute[] createClasspathAttributes(EclipseClasspathEntry entry) {
        ArrayList attributes = Lists.newArrayList((Iterable)entry.getClasspathAttributes());
        IClasspathAttribute[] classpathAttributes = new IClasspathAttribute[attributes.size()];
        for (int i = 0; i < attributes.size(); ++i) {
            ClasspathAttribute attribute = (ClasspathAttribute)attributes.get(i);
            classpathAttributes[i] = JavaCore.newClasspathAttribute((String)attribute.getName(), (String)attribute.getValue());
        }
        return classpathAttributes;
    }

    public static Optional<Set<String>> scopesFor(IClasspathEntry entry) {
        for (IClasspathAttribute attribute : entry.getExtraAttributes()) {
            if (!attribute.getName().equals("gradle_scope")) continue;
            return Optional.of(Sets.newHashSet((Object[])attribute.getValue().split(",")));
        }
        return Optional.empty();
    }

    public static Optional<Set<String>> usedByScopesFor(IClasspathEntry entry) {
        for (IClasspathAttribute attribute : entry.getExtraAttributes()) {
            if (!attribute.getName().equals("gradle_used_by_scope")) continue;
            return Optional.of(Sets.newHashSet((Object[])attribute.getValue().split(",")));
        }
        return Optional.empty();
    }
}

