/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.parser;

import java.util.List;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipTextProvider;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.DescriptionPropertiesHelper;
import org.eclipse.wb.internal.core.xml.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.xml.model.description.IDescriptionProcessor;
import org.eclipse.wb.internal.core.xml.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.xwt.model.property.editor.ObjectPropertyEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XwtDescriptionProcessor
implements IDescriptionProcessor {
    public static final IDescriptionProcessor INSTANCE = new XwtDescriptionProcessor();

    private XwtDescriptionProcessor() {
    }

    public void process(EditorContext context, ComponentDescription componentDescription) throws Exception {
        if (XwtDescriptionProcessor.isXWT(context)) {
            this.useObjectPropertyEditor(componentDescription);
            this.addProperties_TableViewerColumn(componentDescription);
        }
    }

    public static boolean isXWT(XmlObjectInfo object) {
        EditorContext context = object.getContext();
        return XwtDescriptionProcessor.isXWT(context);
    }

    public static boolean isXWT(EditorContext context) {
        return context.getToolkit().getId().equals("org.eclipse.wb.rcp");
    }

    private void useObjectPropertyEditor(ComponentDescription componentDescription) {
        List properties = componentDescription.getProperties();
        for (GenericPropertyDescription property : properties) {
            if (property.getEditor() != null || !ReflectionUtils.isSuccessorOf((Class)property.getType(), (String)"org.eclipse.swt.widgets.Widget")) continue;
            property.setEditor(ObjectPropertyEditor.INSTANCE);
            property.setCategory(PropertyCategory.ADVANCED);
        }
    }

    private void addProperties_TableViewerColumn(ComponentDescription componentDescription) throws Exception {
        GenericPropertyDescription property2;
        if (componentDescription.getComponentClass() != TableViewerColumn.class) {
            return;
        }
        for (GenericPropertyDescription property2 : componentDescription.getProperties()) {
            if (!property2.getCategory().isPreferred()) continue;
            property2.setCategory(PropertyCategory.NORMAL);
        }
        property2 = this.createPropertyDescription("text", "Sets the column text.", String.class, "object.column.text");
        property2.putTag("isText", "true");
        property2.setCategory(PropertyCategory.PREFERRED);
        componentDescription.addProperty(property2);
        property2 = this.createPropertyDescription("width", "Sets the column width in pixels.", Integer.TYPE, "object.column.width");
        property2.setCategory(PropertyCategory.PREFERRED);
        componentDescription.addProperty(property2);
    }

    private GenericPropertyDescription createPropertyDescription(String attribute, final String tooltip, Class<?> type, final String script) throws Exception {
        ExpressionAccessor accessor = new ExpressionAccessor(attribute){

            public Object getDefaultValue(XmlObjectInfo object) throws Exception {
                return ScriptUtils.evaluate((String)script, (Object)object);
            }

            public <T> T getAdapter(Class<T> adapter) {
                if (adapter == PropertyTooltipProvider.class) {
                    return adapter.cast(new PropertyTooltipTextProvider(){

                        protected String getText(Property property) throws Exception {
                            return tooltip;
                        }
                    });
                }
                return (T)super.getAdapter(adapter);
            }
        };
        GenericPropertyDescription property = new GenericPropertyDescription(attribute, attribute, type, accessor);
        property.setConverter(DescriptionPropertiesHelper.getConverterForType(type));
        property.setEditor(DescriptionPropertiesHelper.getEditorForType(type));
        return property;
    }
}

