/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.ui.internal;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tips.core.TipImage;
import org.eclipse.tips.core.TipProvider;
import org.eclipse.tips.core.internal.LogUtil;
import org.eclipse.tips.core.internal.TipManager;
import org.eclipse.tips.ui.internal.Messages;
import org.eclipse.tips.ui.internal.ProviderSelectionListener;
import org.eclipse.tips.ui.internal.util.ImageUtil;
import org.eclipse.tips.ui.internal.util.ResourceManager;
import org.eclipse.tips.ui.internal.util.SWTResourceManager;

public class Slider
extends Composite {
    private static final int RESIZE_RELOAD_DELAY = 100;
    private Composite fScroller;
    private TipProvider fSelectedProvider;
    private int fSpacing = 5;
    private int fSliderIndex = 0;
    private List<ProviderSelectionListener> fListeners = new ArrayList<ProviderSelectionListener>();
    private TipManager fTipManager;
    private Button fLeftButton;
    private Button fRightButton;
    private Composite fSelectedProviderButton;
    private HashMap<String, Image> fProviderImageCache = new HashMap();
    private int fIconSize = 48;
    private PropertyChangeListener fPropertyChangeListener;
    private int fLeftRightButtonWidth;
    private long fLastResizeEventTime;
    private boolean fResizeRequestPending;

    public Slider(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.fLeftButton = new Button((Composite)this, 0x800000);
        this.fLeftRightButtonWidth = this.fIconSize / 2 + 8;
        this.setLeftRightButtonGridData(this.fLeftButton, this.fLeftRightButtonWidth);
        this.fLeftButton.setImage(Slider.getImage("icons/" + this.fIconSize + "/aleft.png"));
        this.fLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Slider.this.scrollLeft();
            }
        });
        this.fScroller = new Composite((Composite)this, 0x20000000);
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        layoutData.heightHint = this.fIconSize + 4;
        this.fScroller.setLayoutData((Object)layoutData);
        this.fRightButton = new Button((Composite)this, 0x800000);
        this.setLeftRightButtonGridData(this.fRightButton, this.fLeftRightButtonWidth);
        this.fRightButton.setImage(Slider.getImage("icons/" + this.fIconSize + "/aright.png"));
        this.fRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Slider.this.scrollRight();
            }
        });
        this.setupDisposeListener();
        this.setupProviderListener();
        this.setupResizeListener();
    }

    private void setupResizeListener() {
        this.addListener(11, event -> {
            this.fLastResizeEventTime = System.currentTimeMillis();
            if (!this.fResizeRequestPending) {
                this.fResizeRequestPending = true;
                this.submitResizeExecution();
            }
        });
    }

    private void submitResizeExecution() {
        this.getDisplay().timerExec(50, () -> {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.fLastResizeEventTime > 100L) {
                this.load();
                this.fResizeRequestPending = false;
            }
            if (this.fResizeRequestPending) {
                this.submitResizeExecution();
            }
        });
    }

    private void setLeftRightButtonGridData(Button pButton, int pWidth) {
        GridData gridData = new GridData(4, 4, false, false, 1, 1);
        gridData.widthHint = pWidth;
        gridData.heightHint = this.fIconSize;
        pButton.setLayoutData((Object)gridData);
    }

    private void setupDisposeListener() {
        this.addListener(12, event -> {
            this.fTipManager.getChangeSupport().removePropertyChangeListener(this.fPropertyChangeListener);
            this.fProviderImageCache.values().forEach(img -> {
                if (!img.isDisposed()) {
                    img.dispose();
                }
            });
        });
    }

    private void setupProviderListener() {
        this.fPropertyChangeListener = provider -> {
            if (!this.isDisposed()) {
                this.getDisplay().asyncExec(() -> this.load());
            }
        };
    }

    private static Image getImage(String icon) {
        return ResourceManager.getPluginImage("org.eclipse.tips.ui", icon);
    }

    public void load() {
        if (this.isDisposed() || this.fScroller.isDisposed() || this.fTipManager == null) {
            return;
        }
        Arrays.stream(this.fScroller.getChildren()).filter(control -> !control.isDisposed()).forEach(Widget::dispose);
        List providers = this.fTipManager.getProviders();
        int spaceCount = Math.floorDiv(this.fScroller.getBounds().width, this.fIconSize + this.fSpacing);
        int providerCount = providers.size();
        if (this.fSliderIndex > 0 && spaceCount >= providerCount) {
            this.fSliderIndex = 0;
        }
        if (spaceCount >= providerCount) {
            if (this.fRightButton.isEnabled()) {
                this.enableLeftRightButtons(false);
            }
        } else if (!this.fRightButton.isEnabled()) {
            this.enableLeftRightButtons(true);
        }
        int emptyPixelsLeft = Math.floorMod(this.fScroller.getBounds().width, this.fIconSize + this.fSpacing);
        int newSpacing = this.fSpacing + emptyPixelsLeft / (spaceCount + 1);
        int i = 0;
        while (i < Math.min(providerCount - this.fSliderIndex, spaceCount)) {
            TipProvider provider = (TipProvider)providers.get(i + this.fSliderIndex);
            if (this.fSelectedProvider == null && !provider.getTips().isEmpty()) {
                this.fSelectedProvider = provider;
                this.notifyListeners(this.fSelectedProvider);
            }
            this.createProviderButton((TipProvider)providers.get(i + this.fSliderIndex), newSpacing, i);
            ++i;
        }
        this.setBackground(this.fScroller.getBackground());
    }

    private void enableLeftRightButtons(boolean enable) {
        this.fRightButton.setEnabled(enable);
        this.fRightButton.setVisible(enable);
        this.setLeftRightButtonGridData(this.fRightButton, enable ? this.fLeftRightButtonWidth : 0);
        this.fLeftButton.setEnabled(enable);
        this.fLeftButton.setVisible(enable);
        this.setLeftRightButtonGridData(this.fLeftButton, enable ? this.fLeftRightButtonWidth : 0);
        this.fRightButton.requestLayout();
        this.fLeftButton.requestLayout();
    }

    private Composite createProviderButton(TipProvider provider, int spacing, int index) {
        Composite button = new Composite(this.fScroller, 0x20000000);
        button.setToolTipText(provider.getDescription());
        button.setBackground(this.fScroller.getBackground());
        button.setSize(this.fIconSize + 4, this.fIconSize + 4);
        button.setLocation(index * (this.fIconSize + spacing) + spacing - this.fSpacing, 2);
        button.addPaintListener(e -> {
            if (this.fSelectedProvider == provider) {
                this.fSelectedProviderButton = button;
            }
            this.paintButton(e.gc, button, provider);
        });
        button.addListener(6, event -> button.redraw());
        button.addListener(7, event -> button.redraw());
        button.addListener(4, event -> {
            if (this.fSelectedProvider == provider) {
                return;
            }
            this.fSelectedProvider = provider;
            if (this.fSelectedProviderButton != null && !this.fSelectedProviderButton.isDisposed()) {
                this.fSelectedProviderButton.redraw();
            }
            this.fSelectedProviderButton = button;
            this.fSelectedProviderButton.redraw();
            this.notifyListeners(provider);
        });
        if (this.fSelectedProvider == provider) {
            this.fSelectedProviderButton = button;
        }
        return button;
    }

    public void updateButton() {
        if (this.fSelectedProviderButton != null && !this.fSelectedProviderButton.isDisposed()) {
            this.getDisplay().asyncExec(() -> this.fSelectedProviderButton.redraw());
        }
    }

    public void updateButtons() {
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(() -> {
                if (!this.fScroller.isDisposed()) {
                    Control[] controlArray = this.fScroller.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (control instanceof Composite && !control.isDisposed()) {
                            control.redraw();
                        }
                        ++n2;
                    }
                }
            });
        }
    }

    public Slider setTipManager(TipManager tipManager) {
        this.fTipManager = tipManager;
        this.fTipManager.getChangeSupport().addPropertyChangeListener("PR", this.fPropertyChangeListener);
        this.fIconSize = 48;
        this.load();
        return this;
    }

    private void notifyListeners(TipProvider provider) {
        this.fListeners.forEach(listener -> {
            try {
                listener.selected(provider);
            }
            catch (Exception e) {
                this.fTipManager.log(LogUtil.error(((Object)((Object)this)).getClass(), (Throwable)e));
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point point = new Point(this.fIconSize * 3, this.fIconSize + this.fSpacing + this.fSpacing);
        return point;
    }

    protected void scrollRight() {
        if (this.fSliderIndex < this.fTipManager.getProviders().size() - 1) {
            ++this.fSliderIndex;
            this.load();
        }
    }

    protected void scrollLeft() {
        if (this.fSliderIndex > 0) {
            --this.fSliderIndex;
            this.load();
        }
    }

    public TipProvider getTipProvider() {
        return this.fSelectedProvider;
    }

    public Slider setTipProvider(TipProvider provider) {
        this.fSelectedProvider = provider;
        this.updateButtons();
        return this;
    }

    public Slider addTipProviderListener(ProviderSelectionListener listener) {
        this.fListeners.add(listener);
        return this;
    }

    public Slider removeTipProviderListener(ProviderSelectionListener listener) {
        this.fListeners.remove(listener);
        return this;
    }

    private void paintButton(GC gc, Composite providerButton, TipProvider provider) {
        gc.setAdvanced(true);
        if (!gc.getAdvanced()) {
            throw new RuntimeException(Messages.Slider_13);
        }
        if (provider.equals(this.fSelectedProvider)) {
            gc.setForeground(this.getDisplay().getSystemColor(27));
            gc.setBackground(this.getDisplay().getSystemColor(26));
            gc.drawRectangle(0, 0, this.fIconSize + 3, this.fIconSize + 3);
        } else {
            boolean mouseIn;
            gc.setForeground(this.fLeftButton.getForeground());
            gc.setBackground(this.fLeftButton.getBackground());
            boolean bl = mouseIn = this.getDisplay().getCursorControl() == providerButton;
            if (mouseIn) {
                gc.drawRectangle(0, 0, this.fIconSize + 3, this.fIconSize + 3);
            } else {
                gc.setBackground(this.fScroller.getBackground());
            }
        }
        gc.fillRectangle(2, 2, this.fIconSize, this.fIconSize);
        Image overlay = this.getUnreadOverlay(providerButton, provider);
        gc.drawImage(overlay, 2, 2);
        if (overlay != this.getProviderImage(provider, this.selectProviderImage(provider))) {
            overlay.dispose();
        }
    }

    private TipImage selectProviderImage(TipProvider provider) {
        return provider.getImage();
    }

    private Image getProviderImage(TipProvider provider, TipImage image) {
        if (!this.fProviderImageCache.containsKey(provider.getID())) {
            try {
                this.fProviderImageCache.put(provider.getID(), new Image((Device)this.getDisplay(), ImageUtil.decodeToImage(image.getBase64Image())));
            }
            catch (Exception e) {
                this.fTipManager.log(LogUtil.error(((Object)((Object)this)).getClass(), (Throwable)e));
                return null;
            }
        }
        return this.fProviderImageCache.get(provider.getID());
    }

    private Image getUnreadOverlay(Composite providerButton, TipProvider provider) {
        if (provider.getTips().isEmpty()) {
            return this.getProviderImage(provider, this.selectProviderImage(provider));
        }
        int tipCount = provider.getTips().size();
        Point textExtent = this.getTipCountTextSize(providerButton, tipCount);
        Image image = null;
        int imageHeight = textExtent.y + 5;
        image = tipCount > 9 ? new Image((Device)this.getDisplay(), textExtent.x + 8, imageHeight) : new Image((Device)this.getDisplay(), imageHeight, imageHeight);
        ImageData data = image.getImageData();
        data.transparentPixel = data.getPixel(0, 0);
        image.dispose();
        image = new Image((Device)this.getDisplay(), data);
        GC gc = new GC((Drawable)image);
        gc.setAdvanced(true);
        if (this.fTipManager.mustServeReadTips()) {
            gc.setBackground(this.getDisplay().getSystemColor(6));
        } else {
            gc.setBackground(this.getDisplay().getSystemColor(3));
        }
        gc.setForeground(this.getDisplay().getSystemColor(1));
        gc.setFont(SWTResourceManager.getBoldFont(gc.getFont()));
        gc.setAlpha(200);
        gc.setTextAntialias(1);
        if (tipCount > 9) {
            gc.fillOval(0, 0, textExtent.x + 8, imageHeight);
            gc.drawText(String.valueOf(tipCount), 4, 2, true);
        } else {
            gc.fillOval(0, 0, imageHeight, imageHeight);
            gc.drawText(String.valueOf(tipCount), (imageHeight - textExtent.x + 1) / 2, 2, true);
        }
        Image result = ResourceManager.decorateImage(this.getProviderImage(provider, this.selectProviderImage(provider)), image, 2);
        image.dispose();
        gc.dispose();
        return result;
    }

    private Point getTipCountTextSize(Composite providerButton, int tipCount) {
        GC gc2 = new GC((Drawable)providerButton);
        gc2.setAdvanced(true);
        gc2.setFont(SWTResourceManager.getBoldFont(gc2.getFont()));
        Point textExtent = gc2.textExtent(String.valueOf(tipCount));
        gc2.dispose();
        return textExtent;
    }
}

