/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class HttpPatternMatchListener
implements IPatternMatchListenerDelegate {
    private TextConsole m_console;

    public void connect(TextConsole console) {
        this.m_console = console;
    }

    public void disconnect() {
        this.m_console = null;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            P_HttpHyperlink link = new P_HttpHyperlink(this.m_console);
            this.m_console.addHyperlink((IHyperlink)link, event.getOffset(), event.getLength());
        }
        catch (BadLocationException e) {
            SdkLog.warning((String)"Cannot create hyperlink.", (Object[])new Object[]{e});
        }
    }

    private static final class P_HttpHyperlink
    implements IHyperlink {
        private final TextConsole m_sourceConsole;

        private P_HttpHyperlink(TextConsole console) {
            this.m_sourceConsole = console;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            IRegion region = this.m_sourceConsole.getRegion((IHyperlink)this);
            if (region == null) {
                return;
            }
            IDocument document = this.m_sourceConsole.getDocument();
            try {
                String link = document.get(region.getOffset(), region.getLength());
                S2eUiUtils.showUrlInBrowser(link);
            }
            catch (BadLocationException e) {
                SdkLog.warning((String)"Cannot create hyperlink.", (Object[])new Object[]{e});
            }
        }
    }
}

