/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.completeocl.validation;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.validation.PivotEObjectValidator;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public class CompleteOCLEObjectValidator
extends PivotEObjectValidator {
    private static final Logger logger = Logger.getLogger(CompleteOCLEObjectValidator.class);
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    protected final @NonNull EPackage ePackage;
    protected final @NonNull URI oclURI;
    private Ecore2AS ecore2as = null;

    @Deprecated
    public CompleteOCLEObjectValidator(@NonNull EPackage ePackage, @NonNull URI oclURI) {
        this(ePackage, oclURI, OCL.newInstance().getEnvironmentFactory());
    }

    public CompleteOCLEObjectValidator(@NonNull EPackage ePackage, @NonNull URI oclURI, @NonNull EnvironmentFactory environmentFactory) {
        super(null);
        this.environmentFactory = (EnvironmentFactoryInternal)environmentFactory;
        this.ePackage = ePackage;
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            URIConverter uriConverter = this.environmentFactory.getResourceSet().getURIConverter();
            this.oclURI = uriConverter.normalize(oclURI);
        } else {
            this.oclURI = oclURI;
        }
        ResourceSet resourceSet = ePackage.eResource().getResourceSet();
        if (resourceSet != null) {
            CompleteOCLEObjectValidator.install((ResourceSet)resourceSet, (EnvironmentFactoryInternal)this.environmentFactory);
        } else {
            this.environmentFactory.loadEPackage(ePackage);
        }
    }

    protected EPackage getEPackage() {
        return this.ePackage;
    }

    public @NonNull PivotMetamodelManager getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    public boolean initialize() {
        Resource ecoreResource = this.ePackage.eResource();
        if (ecoreResource == null) {
            return false;
        }
        this.ecore2as = Ecore2AS.getAdapter((Resource)ecoreResource, (EnvironmentFactoryInternal)this.environmentFactory);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.environmentFactory.adapt((Notifier)resourceSet);
        EList errors = ecoreResource.getErrors();
        assert (errors != null);
        String message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load Ecore '" + ecoreResource.getURI() + message));
            return false;
        }
        Model pivotModel = this.ecore2as.getASModel();
        errors = pivotModel.eResource().getErrors();
        assert (errors != null);
        message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load Pivot from '" + ecoreResource.getURI() + message));
            return false;
        }
        CSResource xtextResource = (CSResource)resourceSet.getResource(this.oclURI, true);
        errors = xtextResource.getErrors();
        assert (errors != null);
        message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load '" + this.oclURI + message));
            return false;
        }
        ASResource asResource = xtextResource.getASResource();
        errors = asResource.getErrors();
        assert (errors != null);
        message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load Pivot from '" + this.oclURI + message));
            return false;
        }
        return true;
    }

    protected boolean validatePivot(@NonNull EClassifier eClassifier, @Nullable Object object, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context) {
        ResourceSet resourceSet;
        if (this.ecore2as == null) {
            this.initialize();
        }
        if ((resourceSet = CompleteOCLEObjectValidator.getResourceSet((EClassifier)eClassifier, (Object)object, (DiagnosticChain)diagnostics)) != null) {
            boolean allOk;
            PivotEObjectValidator.ValidationAdapter validationAdapter = PivotEObjectValidator.ValidationAdapter.findAdapter((ResourceSet)resourceSet);
            if (validationAdapter == null) {
                validationAdapter = CompleteOCLEObjectValidator.install((ResourceSet)resourceSet, (EnvironmentFactoryInternal)this.environmentFactory);
            }
            return (allOk = validationAdapter.validate(eClassifier, object, this.complementingModels, diagnostics, context)) || diagnostics != null;
        }
        return true;
    }
}

