/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.security;

import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.internal.ui.messages.Messages;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsUpdate;
import org.eclipse.net4j.util.security.PasswordCredentialsUpdate;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.security.CredentialsDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CredentialsUpdateDialog
extends CredentialsDialog {
    private static final String TITLE = Messages.getString("CredentialsUpdateDialog_0");
    private static final String MESSAGE = Messages.getString("CredentialsUpdateDialog_1");
    private static final int HEIGHT = 275;
    private String userID;
    private Text newPasswordControl;
    private Text repeatNewPasswordControl;

    public CredentialsUpdateDialog(Shell shell) {
        this(shell, null, null);
    }

    public CredentialsUpdateDialog(Shell shell, String realm, String userID) {
        super(shell, realm, TITLE, MESSAGE);
        this.userID = userID;
    }

    @Override
    protected void configureShell(Shell newShell, int width, int height) {
        super.configureShell(newShell, width, 275);
    }

    public IPasswordCredentialsUpdate getCredentials() {
        return (IPasswordCredentialsUpdate)super.getCredentials();
    }

    @Override
    protected IPasswordCredentials createCredentials(String userID, char[] password) {
        String newPassword = this.newPasswordControl.getText();
        return new PasswordCredentialsUpdate(userID, password, newPassword.toCharArray());
    }

    @Override
    protected Composite createCredentialsArea(Composite parent) {
        Composite result = super.createCredentialsArea(parent);
        ModifyListener newPasswordListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CredentialsUpdateDialog.this.validateNewPassword();
            }
        };
        new Label(result, 0).setText(Messages.getString("CredentialsUpdateDialog_2"));
        this.newPasswordControl = new Text(result, 0x400800);
        this.newPasswordControl.setLayoutData((Object)UIUtil.createGridData(true, false));
        this.newPasswordControl.addModifyListener(newPasswordListener);
        new Label(result, 0).setText(Messages.getString("CredentialsUpdateDialog_3"));
        this.repeatNewPasswordControl = new Text(result, 0x400800);
        this.repeatNewPasswordControl.setLayoutData((Object)UIUtil.createGridData(true, false));
        this.repeatNewPasswordControl.addModifyListener(newPasswordListener);
        return result;
    }

    @Override
    protected Control createUserIDControl(Composite composite) {
        Text text = new Text(composite, 2048);
        text.setText(StringUtil.safe((String)this.userID));
        text.setEnabled(false);
        return text;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    void validateNewPassword() {
        String newPassword = this.newPasswordControl.getText().trim();
        if (newPassword.length() == 0) {
            this.error(Messages.getString("CredentialsUpdateDialog_4"));
            return;
        }
        String verify = this.repeatNewPasswordControl.getText().trim();
        if (verify.length() == 0) {
            this.error(null);
            this.getButton(0).setEnabled(false);
            return;
        }
        if (!verify.equals(newPassword)) {
            this.error(Messages.getString("CredentialsUpdateDialog_5"));
            return;
        }
        this.error(null);
    }

    void error(String message) {
        this.setErrorMessage(message);
        this.getButton(0).setEnabled(message == null);
    }
}

