/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.hprof.AbstractParser;
import org.eclipse.mat.hprof.BufferingRafPositionInputStream;
import org.eclipse.mat.hprof.IHprofParserHandler;
import org.eclipse.mat.hprof.IPositionInputStream;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.ui.HprofPreferences;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleMonitor;

public class Pass2Parser
extends AbstractParser {
    private IHprofParserHandler handler;
    private SimpleMonitor.Listener monitor;
    private IPositionInputStream in;
    private boolean parallel;
    private long streamLength;

    public Pass2Parser(IHprofParserHandler handler, SimpleMonitor.Listener monitor, HprofPreferences.HprofStrictness strictnessPreference, long streamLength, boolean parallel) {
        super(strictnessPreference);
        this.handler = handler;
        this.monitor = monitor;
        this.streamLength = streamLength;
        this.parallel = parallel;
    }

    public void read(File file, String dumpNrToRead) throws SnapshotException, IOException {
        this.in = new BufferingRafPositionInputStream(file, 0L, 8192, this.streamLength);
        int currentDumpNr = 0;
        try {
            this.version = Pass2Parser.readVersion(this.in);
            this.idSize = this.in.readInt();
            if (this.idSize != 4 && this.idSize != 8) {
                throw new SnapshotException(Messages.Pass1Parser_Error_SupportedDumps);
            }
            this.in.skipBytes(8);
            long fileSize = this.streamLength;
            long curPos = this.in.position();
            while (curPos < fileSize) {
                if (this.monitor.isProbablyCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                this.monitor.totalWorkDone(curPos / 1000L);
                int r = this.in.read();
                if (r == -1) {
                    break;
                }
                int record = r & 0xFF;
                this.in.skipBytes(4);
                long length = this.in.readUnsignedInt();
                if (length < 0L) {
                    throw new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_Error_IllegalRecordLength, (Object[])new Object[]{length, this.in.position(), record}));
                }
                length = this.updateLengthIfNecessary(fileSize, curPos, record, length, this.monitor);
                switch (record) {
                    case 12: 
                    case 28: {
                        if (this.dumpMatches(currentDumpNr, dumpNrToRead)) {
                            this.readDumpSegments(length);
                        } else {
                            this.in.skipBytes(length);
                        }
                        if (record != 12) break;
                        ++currentDumpNr;
                        break;
                    }
                    case 44: {
                        ++currentDumpNr;
                        this.in.skipBytes(length);
                        break;
                    }
                    default: {
                        this.in.skipBytes(length);
                    }
                }
                curPos = this.in.position();
            }
        }
        finally {
            try {
                this.in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void readDumpSegments(long length) throws SnapshotException, IOException {
        Stream<IHprofParserHandler.HeapObject> heapObjects = StreamSupport.stream(new HeapObjectParser(length), this.parallel);
        try {
            heapObjects.forEach(t -> {
                try {
                    this.handler.addObject((IHprofParserHandler.HeapObject)t);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private void skipClassDump() throws IOException {
        this.in.skipBytes(7 * this.idSize + 8);
        int constantPoolSize = this.in.readUnsignedShort();
        int ii = 0;
        while (ii < constantPoolSize) {
            this.in.skipBytes(2);
            this.skipValue(this.in);
            ++ii;
        }
        int numStaticFields = this.in.readUnsignedShort();
        int i = 0;
        while (i < numStaticFields) {
            this.in.skipBytes(this.idSize);
            this.skipValue(this.in);
            ++i;
        }
        int numInstanceFields = this.in.readUnsignedShort();
        this.in.skipBytes((this.idSize + 1) * numInstanceFields);
    }

    private IHprofParserHandler.HeapObject readInstanceDump(long segmentStartPos) throws IOException {
        long id = this.in.readID(this.idSize);
        this.in.skipBytes(4);
        long classID = this.in.readID(this.idSize);
        int bytesFollowing = this.in.readInt();
        byte[] objectData = new byte[bytesFollowing];
        this.in.readFully(objectData);
        return IHprofParserHandler.HeapObject.forInstance(id, classID, objectData, segmentStartPos, this.idSize);
    }

    private IHprofParserHandler.HeapObject readObjectArrayDump(long segmentStartPos) throws IOException {
        long id = this.in.readID(this.idSize);
        this.in.skipBytes(4);
        int size = this.in.readInt();
        long arrayClassObjectID = this.in.readID(this.idSize);
        long[] ids = new long[size];
        int i = 0;
        while (i < size) {
            ids[i] = this.in.readID(this.idSize);
            ++i;
        }
        return IHprofParserHandler.HeapObject.forObjectArray(id, arrayClassObjectID, size, ids, segmentStartPos);
    }

    private IHprofParserHandler.HeapObject readPrimitiveArrayDump(long segmentStartPos) throws SnapshotException, IOException {
        long id = this.in.readID(this.idSize);
        this.in.skipBytes(4);
        int size = this.in.readInt();
        byte elementType = this.in.readByte();
        if (elementType < 4 || elementType > 11) {
            throw new SnapshotException(Messages.Pass1Parser_Error_IllegalType);
        }
        int elementSize = IPrimitiveArray.ELEMENT_SIZE[elementType];
        this.in.skipBytes((long)elementSize * (long)size);
        return IHprofParserHandler.HeapObject.forPrimitiveArray(id, elementType, size, segmentStartPos);
    }

    private class HeapObjectParser
    implements Spliterator<IHprofParserHandler.HeapObject> {
        static final int BATCH_SIZE = 512;
        static final long MAX_MEM = 1000000L;
        final long end;
        private IHprofParserHandler.HeapObject _nextItemCapture = null;

        public HeapObjectParser(long length) {
            this.end = length + Pass2Parser.this.in.position();
        }

        @Override
        public int characteristics() {
            return 17681;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public Spliterator<IHprofParserHandler.HeapObject> trySplit() {
            Object[] nextBatch = new IHprofParserHandler.HeapObject[512];
            int found = 0;
            long memsize = 0L;
            while (this.tryAdvance((Consumer<? super IHprofParserHandler.HeapObject>)((Consumer<IHprofParserHandler.HeapObject>)t -> {
                IHprofParserHandler.HeapObject heapObject = this._nextItemCapture = t;
            }))) {
                nextBatch[found] = this._nextItemCapture;
                ++found;
                if (this._nextItemCapture.isObjectArray) {
                    memsize += (long)this._nextItemCapture.ids.length;
                }
                if (found >= nextBatch.length || memsize >= 1000000L) break;
            }
            if (found == 0) {
                return null;
            }
            return Spliterators.spliterator(nextBatch, 0, found, this.characteristics());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean tryAdvance(Consumer<? super IHprofParserHandler.HeapObject> action) {
            try {
                IHprofParserHandler.HeapObject heapObject;
                long inputPosition = Pass2Parser.this.in.position();
                do {
                    if (inputPosition >= this.end) {
                        return false;
                    }
                    int segmentType = Pass2Parser.this.in.readUnsignedByte();
                    heapObject = null;
                    switch (segmentType) {
                        case 5: 
                        case 7: 
                        case 255: {
                            Pass2Parser.this.in.skipBytes(Pass2Parser.this.idSize);
                            break;
                        }
                        case 1: {
                            Pass2Parser.this.in.skipBytes(Pass2Parser.this.idSize * 2);
                            break;
                        }
                        case 4: 
                        case 6: {
                            Pass2Parser.this.in.skipBytes(Pass2Parser.this.idSize + 4);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 8: {
                            Pass2Parser.this.in.skipBytes(Pass2Parser.this.idSize + 8);
                            break;
                        }
                        case 32: {
                            Pass2Parser.this.skipClassDump();
                            break;
                        }
                        case 33: {
                            heapObject = Pass2Parser.this.readInstanceDump(inputPosition);
                            break;
                        }
                        case 34: {
                            heapObject = Pass2Parser.this.readObjectArrayDump(inputPosition);
                            break;
                        }
                        case 35: {
                            heapObject = Pass2Parser.this.readPrimitiveArrayDump(inputPosition);
                            break;
                        }
                        default: {
                            throw new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_Error_InvalidHeapDumpFile, (Object[])new Object[]{Integer.toHexString(segmentType), Long.toHexString(inputPosition)}));
                        }
                    }
                    inputPosition = Pass2Parser.this.in.position();
                } while (heapObject == null);
                action.accept(heapObject);
                return true;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

