/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core;

import java.util.Collection;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;

public interface JpaStructureNode
extends JpaContextModel {
    public static final String STRUCTURE_CHILDREN_COLLECTION = "structureChildren";

    public TextRange getFullTextRange();

    public boolean containsOffset(int var1);

    public JpaStructureNode getStructureNode(int var1);

    public TextRange getSelectionTextRange();

    public ContextType getContextType();

    public Class<? extends JpaStructureNode> getStructureType();

    public void addRootStructureNodesTo(JpaFile var1, Collection<JpaStructureNode> var2);

    public Iterable<? extends JpaStructureNode> getStructureChildren();

    public int getStructureChildrenSize();

    public static final class ContextType {
        private final JpaStructureNode node;

        public ContextType(JpaStructureNode node) {
            if (node == null) {
                throw new NullPointerException();
            }
            this.node = node;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ContextType other = (ContextType)obj;
            return this.node.getJpaPlatform().equals(other.node.getJpaPlatform()) && this.node.getResourceType().equals(other.node.getResourceType()) && this.node.getStructureType().equals(other.node.getStructureType());
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.node.getJpaPlatform().hashCode();
            hash = hash * 31 + this.node.getResourceType().hashCode();
            hash = hash * 31 + this.node.getStructureType().hashCode();
            return hash;
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (Object)this.node);
        }
    }
}

