/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.highlighting;

import com.google.inject.Injector;
import java.util.Arrays;
import org.eclipse.gef.dot.internal.ui.language.editor.DotEditorUtils;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;

public class DotSubgrammarHighlighter {
    private String language;

    public DotSubgrammarHighlighter(String language) {
        this.language = language;
    }

    public void provideHightlightingFor(String text, int startOffset, IHighlightedPositionAcceptor hostGrammarAcceptor) {
        this.provideHightlightingFor(text, startOffset, hostGrammarAcceptor, null);
    }

    public void provideHightlightingFor(String text, final int startOffset, final IHighlightedPositionAcceptor hostGrammarAcceptor, final String suffix) {
        Injector injector = DotActivator.getInstance().getInjector(this.language);
        ISemanticHighlightingCalculator subgrammarCalculator = (ISemanticHighlightingCalculator)injector.getInstance(ISemanticHighlightingCalculator.class);
        XtextResource xtextResource = DotEditorUtils.getXtextResource(injector, text);
        subgrammarCalculator.provideHighlightingFor(xtextResource, new IHighlightedPositionAcceptor(){

            public void addPosition(int offset, int length, String ... id) {
                if (suffix != null) {
                    id = (String[])Arrays.stream(id).map(e -> String.valueOf(e) + suffix).toArray(String[]::new);
                }
                hostGrammarAcceptor.addPosition(startOffset + offset, length, id);
            }
        });
    }
}

