/**
 * Copyright (c) 2016 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.processors;

import java.util.List;
import java.util.regex.Pattern;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.logging.aeri.core.IReport;
import org.eclipse.epp.logging.aeri.core.IReportProcessor;
import org.eclipse.epp.logging.aeri.core.util.Reports;

/**
 * The processor requires a {@link List} of accepted {@link Pattern} to anonymize the stack trace. The list has to be passed in the
 * {@link IEclipseContext} by the key '<i>acceptedPackagesPatterns</i>'.
 *
 */
public class AnonymizeStackTracesProcessor implements IReportProcessor {

    public static final String CTX_ACCEPTED_PACKAGES_PATTERNS = "acceptedPackagesPatterns";

    @Override
    public boolean canContribute(IStatus status, IEclipseContext context) {
        return true;
    }

    @Override
    public boolean wantsToContribute(IStatus status, IEclipseContext context) {
        return false;
    }

    @Override
    public void process(IReport report, IStatus status, IEclipseContext context) {
        if (context.containsKey(CTX_ACCEPTED_PACKAGES_PATTERNS)) {
            Reports.anonymizeStackTraces(report, (List<Pattern>) context.get(CTX_ACCEPTED_PACKAGES_PATTERNS));
        }
    }

}
