/*******************************************************************************
 * Copyright (c) 2008-2011 Chair for Applied Software Engineering,
 * Technische Universitaet Muenchen.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * emueller
 ******************************************************************************/
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views.NewRepositoryWizard;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

/**
 * UI controller for editing server properties.
 *
 * @author emueller
 *
 */
public class UIEditServerPropertiesController extends AbstractEMFStoreUIController<Void> {

	private final ESServer server;

	/**
	 * Constructor.
	 *
	 * @param shell
	 *            the parent {@link Shell}
	 * @param server
	 *            the server that should be edited
	 */
	public UIEditServerPropertiesController(Shell shell, ESServer server) {
		super(shell);
		this.server = server;
	}

	/**
	 *
	 * {@inheritDoc}
	 *
	 * @see org.eclipse.emf.emfstore.internal.client.ui.common.MonitoredEMFStoreAction#doRun(org.eclipse.core.runtime.IProgressMonitor)
	 */
	@Override
	public Void doRun(IProgressMonitor monitor) throws ESException {
		final NewRepositoryWizard wizard = new NewRepositoryWizard(server);
		final WizardDialog dialog = new WizardDialog(getShell(), wizard);
		dialog.create();
		dialog.open();
		return null;
	}

}
