/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchChangedEvent;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.protocol.CDOProtocol;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.internal.common.commit.DelegatingCommitInfo;
import org.eclipse.emf.cdo.internal.server.Transaction;
import org.eclipse.emf.cdo.internal.server.View;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IPermissionManager;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.ISessionProtocol;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.collection.IndexedList;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.eclipse.net4j.util.registry.IRegistry;

public class Session
extends Container<IView>
implements InternalSession {
    private InternalSessionManager manager;
    private ISessionProtocol protocol;
    private int sessionID;
    private String userID;
    private boolean passiveUpdateEnabled = true;
    private CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode = CDOCommonSession.Options.PassiveUpdateMode.INVALIDATIONS;
    private CDOCommonSession.Options.LockNotificationMode lockNotificationMode = CDOCommonSession.Options.LockNotificationMode.IF_REQUIRED_BY_VIEWS;
    private boolean openOnClientSide;
    private long firstUpdateTime;
    private long lastUpdateTime;
    @ReflectUtil.ExcludeFromDump
    private Object lastUpdateTimeLock = new Object();
    private Map<Integer, InternalView> views = new HashMap<Integer, InternalView>();
    private AtomicInteger lastTempViewID = new AtomicInteger();
    private final IRegistry<String, Object> properties = new HashMapRegistry<String, Object>(){

        public void setAutoCommit(boolean autoCommit) {
            throw new UnsupportedOperationException();
        }
    };
    @ReflectUtil.ExcludeFromDump
    private IListener protocolListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            Session.this.deactivate();
        }
    };
    private boolean subscribed;

    public Session(InternalSessionManager manager, ISessionProtocol protocol, int sessionID, String userID) {
        this.manager = manager;
        this.protocol = protocol;
        this.sessionID = sessionID;
        this.userID = userID;
        EventUtil.addListener((Object)protocol, (IListener)this.protocolListener);
        this.activate();
    }

    public CDOCommonSession.Options options() {
        return this;
    }

    public final IRegistry<String, Object> properties() {
        return this.properties;
    }

    public CDOCommonSession getContainer() {
        return this;
    }

    @Override
    public InternalSessionManager getManager() {
        return this.manager;
    }

    public CDOBranchManager getBranchManager() {
        return this.manager.getRepository().getBranchManager();
    }

    @Override
    public ISessionProtocol getProtocol() {
        return this.protocol;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public String getUserID() {
        return this.userID;
    }

    @Override
    public void setUserID(String userID) {
        this.userID = userID;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscribed;
    }

    @Override
    public void setSubscribed(boolean subscribed) {
        this.checkActive();
        if (this.subscribed != subscribed) {
            this.subscribed = subscribed;
            byte opcode = subscribed ? (byte)3 : 4;
            this.manager.sendRemoteSessionNotification(this, opcode);
        }
    }

    public boolean isPassiveUpdateEnabled() {
        return this.passiveUpdateEnabled;
    }

    public void setPassiveUpdateEnabled(boolean passiveUpdateEnabled) {
        this.checkActive();
        this.passiveUpdateEnabled = passiveUpdateEnabled;
    }

    public CDOCommonSession.Options.PassiveUpdateMode getPassiveUpdateMode() {
        return this.passiveUpdateMode;
    }

    public void setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode) {
        this.checkActive();
        this.checkArg(passiveUpdateMode, "passiveUpdateMode");
        this.passiveUpdateMode = passiveUpdateMode;
    }

    public CDOCommonSession.Options.LockNotificationMode getLockNotificationMode() {
        return this.lockNotificationMode;
    }

    public void setLockNotificationMode(CDOCommonSession.Options.LockNotificationMode lockNotificationMode) {
        this.checkActive();
        this.checkArg(lockNotificationMode, "lockNotificationMode");
        this.lockNotificationMode = lockNotificationMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public long getLastUpdateTime() {
        Object object = this.lastUpdateTimeLock;
        synchronized (object) {
            return this.lastUpdateTime;
        }
    }

    @Override
    public long getFirstUpdateTime() {
        return this.firstUpdateTime;
    }

    @Override
    public void setFirstUpdateTime(long firstUpdateTime) {
        this.firstUpdateTime = firstUpdateTime;
    }

    @Override
    public boolean isOpenOnClientSide() {
        return this.openOnClientSide;
    }

    @Override
    public void setOpenOnClientSide() {
        this.openOnClientSide = true;
        this.manager.openedOnClientSide(this);
    }

    public InternalView[] getElements() {
        this.checkActive();
        return this.getViews();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.checkActive();
        Map<Integer, InternalView> map = this.views;
        synchronized (map) {
            return this.views.isEmpty();
        }
    }

    @Override
    public InternalView[] getViews() {
        this.checkActive();
        return this.getViewsArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalView[] getViewsArray() {
        Map<Integer, InternalView> map = this.views;
        synchronized (map) {
            return this.views.values().toArray(new InternalView[this.views.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalView getView(int viewID) {
        this.checkActive();
        Map<Integer, InternalView> map = this.views;
        synchronized (map) {
            return this.views.get(viewID);
        }
    }

    @Override
    public InternalView openView(int viewID, CDOBranchPoint branchPoint) {
        this.checkActive();
        if (viewID == 0) {
            viewID = -this.lastTempViewID.incrementAndGet();
        }
        View view = new View(this, viewID, branchPoint);
        view.activate();
        this.addView(view);
        return view;
    }

    @Override
    public InternalTransaction openTransaction(int viewID, CDOBranchPoint branchPoint) {
        this.checkActive();
        if (viewID == 0) {
            viewID = -this.lastTempViewID.incrementAndGet();
        }
        Transaction transaction = new Transaction(this, viewID, branchPoint);
        transaction.activate();
        this.addView(transaction);
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addView(InternalView view) {
        this.checkActive();
        int viewID = view.getViewID();
        Map<Integer, InternalView> map = this.views;
        synchronized (map) {
            this.views.put(viewID, view);
        }
        this.fireElementAddedEvent(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewClosed(InternalView view) {
        InternalView removedView;
        int viewID = view.getViewID();
        Map<Integer, InternalView> map = this.views;
        synchronized (map) {
            removedView = this.views.remove(viewID);
        }
        if (removedView == view) {
            view.doClose();
            this.fireElementRemovedEvent(view);
        }
    }

    @Override
    public void collectContainedRevisions(InternalCDORevision revision, CDOBranchPoint branchPoint, int referenceChunk, Set<CDOID> revisions, List<CDORevision> additionalRevisions) {
        InternalCDORevisionManager revisionManager = this.manager.getRepository().getRevisionManager();
        EStructuralFeature[] eStructuralFeatureArray = revision.getClassInfo().getAllPersistentFeatures();
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOID id;
            Object value;
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature instanceof EReference && !feature.isMany() && ((EReference)feature).isContainment() && (value = revision.getValue(feature)) instanceof CDOID && !CDOIDUtil.isNull((CDOID)(id = (CDOID)value)) && !revisions.contains(id)) {
                InternalCDORevision containedRevision = revisionManager.getRevision(id, branchPoint, referenceChunk, 0, true);
                revisions.add(id);
                additionalRevisions.add((CDORevision)containedRevision);
                this.collectContainedRevisions(containedRevision, branchPoint, referenceChunk, revisions, additionalRevisions);
            }
            ++n2;
        }
    }

    public CDOID provideCDOID(Object idObject) {
        return (CDOID)idObject;
    }

    public CDOPermission getPermission(CDORevision revision, CDOBranchPoint securityContext) {
        IPermissionManager permissionManager = this.manager.getPermissionManager();
        if (permissionManager != null) {
            return permissionManager.getPermission(revision, securityContext, this);
        }
        return CDORevision.PERMISSION_PROVIDER.getPermission(revision, securityContext);
    }

    @Override
    public void sendRepositoryTypeNotification(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) throws Exception {
        if (this.protocol != null) {
            this.protocol.sendRepositoryTypeNotification(oldType, newType);
        }
    }

    @Override
    @Deprecated
    public void sendRepositoryStateNotification(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) throws Exception {
        this.sendRepositoryStateNotification(oldState, newState, null);
    }

    @Override
    public void sendRepositoryStateNotification(CDOCommonRepository.State oldState, CDOCommonRepository.State newState, CDOID rootResourceID) throws Exception {
        if (this.protocol != null) {
            this.protocol.sendRepositoryStateNotification(oldState, newState, rootResourceID);
        }
    }

    @Override
    @Deprecated
    public void sendBranchNotification(InternalCDOBranch branch) throws Exception {
        this.sendBranchNotification(branch, CDOBranchChangedEvent.ChangeKind.CREATED);
    }

    @Override
    public void sendBranchNotification(InternalCDOBranch branch, CDOBranchChangedEvent.ChangeKind changeKind) throws Exception {
        if (this.protocol != null) {
            this.protocol.sendBranchNotification(branch, changeKind);
        }
    }

    @Override
    @Deprecated
    public void sendCommitNotification(CDOCommitInfo commitInfo) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void sendCommitNotification(CDOCommitInfo commitInfo, boolean clearResourcePathCache) throws Exception {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendCommitNotification(CDOProtocol.CommitNotificationInfo notificationInfo) throws Exception {
        Object lockNotificationRequired;
        Set impactedRules;
        IPermissionManager permissionManager;
        if (this.protocol == null) {
            return;
        }
        if (!this.isPassiveUpdateEnabled()) {
            return;
        }
        byte securityImpact = notificationInfo.getSecurityImpact();
        if (securityImpact == 1 && !(permissionManager = this.manager.getPermissionManager()).hasAnyRule(this, impactedRules = notificationInfo.getImpactedRules())) {
            securityImpact = 0;
        }
        CommitInfo sessionCommitInfo = new CommitInfo(notificationInfo);
        CDOProtocol.CommitNotificationInfo sessionNotificationInfo = new CDOProtocol.CommitNotificationInfo();
        sessionNotificationInfo.setSender(notificationInfo.getSender());
        sessionNotificationInfo.setCommitInfo((CDOCommitInfo)sessionCommitInfo);
        sessionNotificationInfo.setRevisionProvider(notificationInfo.getRevisionProvider());
        sessionNotificationInfo.setClearResourcePathCache(notificationInfo.isClearResourcePathCache());
        sessionNotificationInfo.setNewPermissions(sessionCommitInfo.getNewPermissions());
        sessionNotificationInfo.setSecurityImpact(securityImpact);
        CDOLockChangeInfo lockChangeInfo = notificationInfo.getLockChangeInfo();
        if (lockChangeInfo != null && (lockNotificationRequired = this.isLockNotificationRequired(lockChangeInfo)) != null) {
            sessionNotificationInfo.setLockChangeInfo(lockChangeInfo);
        }
        this.protocol.sendCommitNotification(sessionNotificationInfo);
        Object object = this.lastUpdateTimeLock;
        synchronized (object) {
            CDOCommitInfo originalCommitInfo = notificationInfo.getCommitInfo();
            this.lastUpdateTime = originalCommitInfo.getTimeStamp();
        }
    }

    @Override
    public void sendLockNotification(CDOLockChangeInfo lockChangeInfo) throws Exception {
        block5: {
            if (this.protocol != null) {
                Object lockNotificationRequired = this.isLockNotificationRequired(lockChangeInfo);
                if (lockNotificationRequired == Boolean.TRUE) {
                    this.protocol.sendLockNotification(lockChangeInfo);
                    return;
                }
                if (lockNotificationRequired instanceof InternalView) {
                    InternalView view = (InternalView)lockNotificationRequired;
                    try {
                        this.protocol.sendLockNotification(lockChangeInfo);
                    }
                    catch (Exception ex) {
                        if (view.isClosed()) break block5;
                        OM.LOG.warn("A problem occured while notifying view " + view, (Throwable)ex);
                    }
                }
            }
        }
    }

    private Object isLockNotificationRequired(CDOLockChangeInfo lockChangeInfo) {
        CDOCommonSession.Options.LockNotificationMode lockNotificationMode = this.options().getLockNotificationMode();
        if (lockNotificationMode == CDOCommonSession.Options.LockNotificationMode.ALWAYS) {
            return Boolean.TRUE;
        }
        if (lockNotificationMode == CDOCommonSession.Options.LockNotificationMode.IF_REQUIRED_BY_VIEWS) {
            InternalView[] internalViewArray = this.getViews();
            int n = internalViewArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalView view = internalViewArray[n2];
                if (view.options().isLockNotificationEnabled()) {
                    CDOBranch affectedBranch = lockChangeInfo.getBranch();
                    if (view.getBranch() == affectedBranch || affectedBranch == null) {
                        return view;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean isDeltaNeeded(CDOID id, InternalView[] views) {
        boolean supportingUnits = this.manager.getRepository().isSupportingUnits();
        InternalView[] internalViewArray = views;
        int n = views.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                InternalView view;
                block5: {
                    view = internalViewArray[n2];
                    if (!view.hasSubscription(id)) break block5;
                    return true;
                }
                try {
                    if (supportingUnits && view.isInOpenUnit(id)) {
                        return true;
                    }
                }
                catch (Exception ex) {
                    if (view.isClosed()) break block6;
                    OM.LOG.warn("A problem occured while checking subscriptions of view " + view, (Throwable)ex);
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void sendRemoteSessionNotification(InternalSession sender, byte opcode) throws Exception {
        if (this.protocol != null) {
            this.protocol.sendRemoteSessionNotification(sender, opcode);
        }
    }

    @Override
    public void sendRemoteMessageNotification(InternalSession sender, CDORemoteSessionMessage message) throws Exception {
        if (this.protocol != null) {
            this.protocol.sendRemoteMessageNotification(sender, message);
        }
    }

    public Object getAdapter(Class adapter) {
        return AdapterUtil.adapt((Object)this, (Class)adapter, (boolean)false);
    }

    public String toString() {
        InternalRepository repository;
        String name = "unknown";
        if (this.manager != null && (repository = this.manager.getRepository()) != null) {
            name = repository.getName();
        }
        if (this.userID != null && this.userID.length() != 0) {
            name = String.valueOf(this.userID) + "@" + name;
        }
        return MessageFormat.format("Session{0} [{1}]", this.sessionID, name);
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    protected void doDeactivate() throws Exception {
        EventUtil.removeListener((Object)this.protocol, (IListener)this.protocolListener);
        this.protocolListener = null;
        LifecycleUtil.deactivate((Object)this.protocol, (OMLogger.Level)OMLogger.Level.DEBUG);
        this.protocol = null;
        InternalView[] internalViewArray = this.getViewsArray();
        int n = internalViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalView view = internalViewArray[n2];
            view.close();
            ++n2;
        }
        this.views = null;
        this.manager.sessionClosed(this);
        this.manager = null;
        super.doDeactivate();
    }

    private final class CommitInfo
    extends DelegatingCommitInfo {
        private final CDOCommitInfo delegate;
        private final CDORevisionProvider revisionProvider;
        private final InternalView[] views;
        private final IPermissionManager permissionManager;
        private final Map<CDOID, CDOPermission> newPermissions;
        private final boolean additions;
        private final boolean changes;

        public CommitInfo(CDOProtocol.CommitNotificationInfo notificationInfo) {
            this.delegate = notificationInfo.getCommitInfo();
            this.revisionProvider = notificationInfo.getRevisionProvider();
            this.views = Session.this.getViews();
            this.permissionManager = Session.this.manager.getPermissionManager();
            this.newPermissions = this.permissionManager != null ? CDOIDUtil.createMap() : null;
            CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode = Session.this.getPassiveUpdateMode();
            this.additions = passiveUpdateMode == CDOCommonSession.Options.PassiveUpdateMode.ADDITIONS;
            this.changes = this.additions || passiveUpdateMode == CDOCommonSession.Options.PassiveUpdateMode.CHANGES;
        }

        protected CDOCommitInfo getDelegate() {
            return this.delegate;
        }

        protected void addNewPermission(CDOID id, CDOPermission permission) {
            this.newPermissions.put(id, permission);
        }

        public Map<CDOID, CDOPermission> getNewPermissions() {
            return this.newPermissions;
        }

        public List<CDOIDAndVersion> getNewObjects() {
            final List newObjects = super.getNewObjects();
            return new IndexedList<CDOIDAndVersion>(){

                public CDOIDAndVersion get(int index) {
                    CDORevision revision = (CDORevision)newObjects.get(index);
                    if (CommitInfo.this.additions) {
                        if (CommitInfo.this.permissionManager == null) {
                            return revision;
                        }
                        CDOPermission permission = CommitInfo.this.permissionManager.getPermission(revision, (CDOBranchPoint)CommitInfo.this.delegate, Session.this);
                        CDOID id = revision.getID();
                        CommitInfo.this.addNewPermission(id, permission);
                        if (permission != CDOPermission.NONE) {
                            return revision;
                        }
                    }
                    return CDOIDUtil.createIDAndVersion((CDOIDAndVersion)revision);
                }

                public int size() {
                    return newObjects.size();
                }
            };
        }

        public List<CDORevisionKey> getChangedObjects() {
            final List changedObjects = super.getChangedObjects();
            return new IndexedList<CDORevisionKey>(){

                public CDORevisionKey get(int index) {
                    CDORevisionDelta revisionDelta = (CDORevisionDelta)changedObjects.get(index);
                    CDOID id = revisionDelta.getID();
                    if (CommitInfo.this.changes || Session.this.isDeltaNeeded(id, CommitInfo.this.views)) {
                        if (CommitInfo.this.permissionManager == null) {
                            return revisionDelta;
                        }
                        if (CommitInfo.this.revisionProvider == null) {
                            return revisionDelta;
                        }
                        CDORevision newRevision = CommitInfo.this.revisionProvider.getRevision(id);
                        CDOPermission permission = CommitInfo.this.permissionManager.getPermission(newRevision, (CDOBranchPoint)CommitInfo.this.delegate, Session.this);
                        CommitInfo.this.addNewPermission(id, permission);
                        if (permission != CDOPermission.NONE) {
                            return revisionDelta;
                        }
                    }
                    return CDORevisionUtil.copyRevisionKey((CDORevisionKey)revisionDelta);
                }

                public int size() {
                    return changedObjects.size();
                }
            };
        }
    }
}

