/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.egit.ui.internal.groups.RepositoryGroups;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryGroupNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.DeleteRepositoryGroupConfirmDialog;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.preference.IPreferenceStore;

public class DeleteRepositoryGroupCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<RepositoryGroup> groupsToDelete = new ArrayList<RepositoryGroup>();
        ArrayList<RepositoryGroupNode> groupsNodes = new ArrayList<RepositoryGroupNode>();
        List elements = this.getSelectedNodes();
        int numberOfRepos = 0;
        for (Object element : elements) {
            if (!(element instanceof RepositoryGroupNode)) continue;
            RepositoryGroupNode groupNode = (RepositoryGroupNode)element;
            groupsNodes.add(groupNode);
            RepositoryGroup group = (RepositoryGroup)groupNode.getObject();
            groupsToDelete.add(group);
            numberOfRepos += group.getRepositoryDirectories().size();
        }
        if (!groupsToDelete.isEmpty()) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            boolean delete = true;
            if (numberOfRepos > 0 && store.getBoolean("show_delete_repo_group_warning")) {
                DeleteRepositoryGroupConfirmDialog confirmDelete = new DeleteRepositoryGroupConfirmDialog(this.getShell(event), groupsNodes);
                boolean bl = delete = confirmDelete.open() == 0;
                if (delete && !confirmDelete.showAgain()) {
                    store.setValue("show_delete_repo_group_warning", false);
                }
            }
            if (delete) {
                RepositoryGroups.getInstance().delete(groupsToDelete);
                this.getView(event).refresh();
            }
        }
        return null;
    }
}

