/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.rse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IEnvironmentChangedListener;
import org.eclipse.dltk.core.environment.IEnvironmentProvider;
import org.eclipse.dltk.core.internal.rse.RSEEnvironment;
import org.eclipse.dltk.core.internal.rse.RSEEnvironmentProvider;
import org.eclipse.dltk.internal.core.DeltaProcessor;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.search.ProjectIndexerManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class RSEConnectionMonitor {
    private boolean updatingDecorators = false;
    private static RSEConnectionMonitor monitor = new RSEConnectionMonitor();
    private final Set<String> eventListenerAdded = Collections.synchronizedSet(new HashSet());

    private void updateDecorator() {
        Runnable uiTask = new Runnable(){

            @Override
            public void run() {
                if (RSEConnectionMonitor.this.updatingDecorators) {
                    return;
                }
                RSEConnectionMonitor.this.updatingDecorators = true;
                try {
                    PlatformUI.getWorkbench().getDecoratorManager().update("org.eclipse.dltk.rse.decorators.projectdecorator");
                }
                finally {
                    RSEConnectionMonitor.this.updatingDecorators = false;
                }
            }
        };
        if (Display.getCurrent() != null) {
            uiTask.run();
        } else {
            Display current = PlatformUI.getWorkbench().getDisplay();
            if (!current.isDisposed()) {
                current.asyncExec(uiTask);
            }
        }
    }

    public static void start() {
        new Job("Install RSE Connection Minitor"){

            protected IStatus run(IProgressMonitor progressMonitor) {
                EnvironmentManager.waitInitialized();
                monitor.scanEnvironments();
                EnvironmentManager.addEnvironmentChangedListener((IEnvironmentChangedListener)new IEnvironmentChangedListener(){

                    public void environmentsModified() {
                        monitor.scanEnvironments();
                    }

                    public void environmentRemoved(IEnvironment environment) {
                    }

                    public void environmentChanged(IEnvironment environment) {
                    }

                    public void environmentAdded(IEnvironment environment) {
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void scanEnvironments() {
        new Job("Scan environments"){

            protected IStatus run(IProgressMonitor monitor) {
                IEnvironment[] environments;
                if (!Platform.isRunning()) {
                    return Status.CANCEL_STATUS;
                }
                IEnvironment[] iEnvironmentArray = environments = EnvironmentManager.getEnvironments((boolean)false);
                int n = environments.length;
                int n2 = 0;
                while (n2 < n) {
                    IEnvironment env = iEnvironmentArray[n2];
                    if (env instanceof RSEEnvironment) {
                        final RSEEnvironment rseENV = (RSEEnvironment)env;
                        if (RSEConnectionMonitor.this.eventListenerAdded.add(rseENV.getId())) {
                            IConnectorService[] services;
                            IHost host = rseENV.getHost();
                            IConnectorService[] iConnectorServiceArray = services = host.getConnectorServices();
                            int n3 = services.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IConnectorService service = iConnectorServiceArray[n4];
                                service.addCommunicationsListener(new ICommunicationsListener(){

                                    public boolean isPassiveCommunicationsListener() {
                                        return false;
                                    }

                                    public void communicationsStateChange(CommunicationsEvent e) {
                                        if (e.getState() == 2 && rseENV.isConnected()) {
                                            rseENV.setTryToConnect(true);
                                            if (Job.getJobManager().find((Object)new ProjectUpdateFamily(rseENV)).length == 0) {
                                                ProjectUpdateJob job = new ProjectUpdateJob(rseENV);
                                                job.setUser(true);
                                                job.schedule();
                                            }
                                        }
                                        RSEConnectionMonitor.this.updateDecorator();
                                    }
                                });
                                ++n4;
                            }
                        }
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private static final class ProjectUpdateFamily {
        private final RSEEnvironment environment;

        public ProjectUpdateFamily(RSEEnvironment environment) {
            this.environment = environment;
        }
    }

    private static final class ProjectUpdateJob
    extends Job {
        private final RSEEnvironment environment;

        private ProjectUpdateJob(RSEEnvironment environment) {
            super("Environment configuration changed. Updating projects.");
            this.environment = environment;
        }

        protected IStatus run(IProgressMonitor inputMonitor) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)inputMonitor, (String)"Checking projects consistency", (int)100);
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            ArrayList<IScriptProject> projectsToProcess = new ArrayList<IScriptProject>();
            SubMonitor m = monitor.newChild(10);
            m.beginTask("Locate projects for environment", projects.length);
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                String envId;
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && (envId = EnvironmentManager.getEnvironmentId((IProject)project, (boolean)false)) != null && envId.equals(this.environment.getId())) {
                    IScriptProject scriptProject = DLTKCore.create((IProject)project);
                    projectsToProcess.add(scriptProject);
                }
                m.worked(1);
                ++n2;
            }
            IEnvironmentProvider provider = EnvironmentManager.getEnvironmentProvider((String)"org.eclipse.dltk.rse.RSEEnvironmentProvider");
            if (provider != null && provider instanceof RSEEnvironmentProvider) {
                ((RSEEnvironmentProvider)provider).fireAdded((IEnvironment)this.environment);
            }
            SubMonitor mm = monitor.newChild(20);
            mm.beginTask("Indexing projects", projectsToProcess.size() * 3);
            for (IScriptProject project : projectsToProcess) {
                ((ScriptProject)project).updateProjectFragments();
                mm.worked(1);
                try {
                    DeltaProcessor processor = ModelManager.getModelManager().getDeltaProcessor();
                    processor.clearCustomTimestampsFor((IModelElement[])project.getProjectFragments());
                    processor.checkExternalChanges(new IModelElement[]{project}, (IProgressMonitor)mm.newChild(1));
                }
                catch (ModelException e) {
                    DLTKCore.error((Throwable)e);
                }
                ProjectIndexerManager.indexProject((IScriptProject)project);
                mm.worked(1);
            }
            mm.done();
            monitor.done();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family instanceof ProjectUpdateFamily && this.environment.equals((Object)((ProjectUpdateFamily)family).environment);
        }
    }
}

