/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.util.Map;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.util.CloudUtil;
import org.cloudfoundry.client.lib.util.JsonUtil;
import org.eclipse.cft.server.core.internal.client.CloudInfo;
import org.eclipse.cft.server.core.internal.client.RestUtils;
import org.eclipse.cft.server.core.internal.ssh.SshHost;
import org.osgi.framework.Version;
import org.springframework.web.client.RestTemplate;

public class CFInfo
implements CloudInfo {
    protected final RestTemplate restTemplate;
    private String ccUrl;
    private Map<String, Object> infoMap;

    public CFInfo(CloudCredentials creds, String url, HttpProxyConfiguration proxyConf, boolean selfSigned) {
        this.restTemplate = RestUtils.createRestTemplate(proxyConf, selfSigned, false);
        this.ccUrl = url;
    }

    @Override
    public String getAuthorizationUrl() {
        return this.getProp("authorization_endpoint");
    }

    @Override
    public String getTokenUrl() {
        return this.getProp("token_endpoint");
    }

    @Override
    public String getCloudControllerUrl() {
        return this.ccUrl;
    }

    @Override
    public String getDopplerUrl() {
        return this.getProp("doppler_logging_endpoint");
    }

    public String getCloudControllerApiVersion() {
        return this.getProp("api_version");
    }

    @Override
    public Version getCCApiVersion() {
        String version = this.getCloudControllerApiVersion();
        if (version != null) {
            return new Version(version);
        }
        return null;
    }

    public String getProp(String name) {
        Map<String, Object> map = this.getMap();
        if (map != null) {
            return (String)CloudUtil.parse(String.class, (Object)map.get(name));
        }
        return null;
    }

    @Override
    public String getSshClientId() {
        return this.getProp("app_ssh_oauth_client");
    }

    @Override
    public SshHost getSshHost() {
        String fingerPrint = this.getProp("app_ssh_host_key_fingerprint");
        String host = this.getProp("app_ssh_endpoint");
        int port = 22;
        if (host != null && host.contains(":")) {
            String[] pieces = host.split(":");
            host = pieces[0];
            port = Integer.parseInt(pieces[1]);
        }
        if (host != null || fingerPrint != null) {
            return new SshHost(host, port, fingerPrint);
        }
        return null;
    }

    protected Map<String, Object> getMap() {
        if (this.infoMap == null) {
            String infoV2Json = (String)this.restTemplate.getForObject(this.getUrl("/v2/info"), String.class, new Object[0]);
            this.infoMap = JsonUtil.convertJsonToMap((String)infoV2Json);
        }
        return this.infoMap;
    }

    private String getUrl(String path) {
        return String.valueOf(this.ccUrl) + path;
    }
}

