/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.net.URI;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICBuildSetting;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExclusionPatternPathEntry;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSettingContainer;
import org.eclipse.cdt.core.settings.model.ICSettingObject;
import org.eclipse.cdt.core.settings.model.ICTargetPlatformSetting;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.extension.CTargetPlatformData;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class StructureTreeTab
extends AbstractCPropertyTab {
    private static final String BL = "[";
    private static final String BR = "]";
    private static final Image IMG = CDTSharedImages.getImage("icons/obj16/error_obj.gif");
    private static final int NESTING_CFG = 5;
    private static final int NESTING_MAX = 16;
    private static final String NULL = "<NULL>";
    private int currentLevel = 4;
    private Combo combo;
    private Tree tree;
    private ICResourceDescription cfg;

    private boolean check(TreeItem ti, Object obj) {
        if (obj == null || ti == null) {
            return false;
        }
        int cnt = 16;
        TreeItem tiSaved = ti;
        while (--cnt > 0) {
            if ((ti = ti.getParentItem()) != null) continue;
            return true;
        }
        tiSaved.setText(2, Messages.StructureTreeTab_1);
        tiSaved.setImage(IMG);
        return false;
    }

    private TreeItem create(TreeItem ti0, String text, boolean val) {
        TreeItem t = this.create(ti0, text, String.valueOf(val));
        t.setText(2, "");
        return t;
    }

    private TreeItem create(TreeItem ti0, String text, int val) {
        TreeItem t = this.create(ti0, text, String.valueOf(val));
        t.setText(2, "");
        return t;
    }

    private TreeItem create(TreeItem ti0, String text, long val) {
        TreeItem t = this.create(ti0, text, String.valueOf(val));
        t.setText(2, Messages.StructureTreeTab_2);
        return t;
    }

    private TreeItem create(TreeItem ti0, String text, String val) {
        TreeItem ti = ti0 == null ? new TreeItem(this.tree, 0) : new TreeItem(ti0, 0);
        ti.setText(0, text == null ? NULL : text);
        ti.setText(1, val == null ? NULL : val);
        ti.setText(2, Messages.StructureTreeTab_3);
        return ti;
    }

    @Override
    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(5, false));
        Label lb = new Label(this.usercomp, 0);
        lb.setText(Messages.StructureTreeTab_4);
        lb.setLayoutData((Object)new GridData(1));
        this.combo = new Combo(this.usercomp, 2060);
        this.combo.setLayoutData((Object)new GridData(768));
        this.combo.add(Messages.ConfigDescriptionTab_0);
        this.combo.add(Messages.ConfigDescriptionTab_1);
        if (this.page.isForFolder() || this.page.isForFile()) {
            this.combo.add(Messages.ConfigDescriptionTab_2);
            this.combo.select(2);
        } else {
            this.combo.select(1);
        }
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructureTreeTab.this.updateData(StructureTreeTab.this.cfg);
            }
        });
        Button b1 = new Button(this.usercomp, 8);
        GridData gd = new GridData(3);
        gd.minimumWidth = 120;
        b1.setLayoutData((Object)gd);
        b1.setText(Messages.StructureTreeTab_5);
        b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructureTreeTab.this.tree.setRedraw(false);
                StructureTreeTab.this.expandAll(StructureTreeTab.this.tree.getItem(0), true, -1);
                StructureTreeTab.this.tree.setRedraw(true);
            }
        });
        Button b2 = new Button(this.usercomp, 8);
        gd = new GridData(3);
        gd.minimumWidth = 120;
        b2.setLayoutData((Object)gd);
        b2.setText(Messages.StructureTreeTab_6);
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelDialog ld = new LevelDialog();
                if (ld.open() == 0) {
                    StructureTreeTab.this.tree.setRedraw(false);
                    StructureTreeTab.this.expandAll(StructureTreeTab.this.tree.getItem(0), true, 0);
                    StructureTreeTab.this.tree.setRedraw(true);
                }
            }
        });
        Button b3 = new Button(this.usercomp, 8);
        gd = new GridData(3);
        gd.minimumWidth = 120;
        b3.setLayoutData((Object)gd);
        b3.setText(Messages.StructureTreeTab_7);
        b3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructureTreeTab.this.tree.setRedraw(false);
                StructureTreeTab.this.expandAll(StructureTreeTab.this.tree.getItem(0), false, -1);
                StructureTreeTab.this.tree.setRedraw(true);
            }
        });
        this.tree = new Tree(this.usercomp, 2048);
        gd = new GridData(1808);
        gd.horizontalSpan = 5;
        this.tree.setLayoutData((Object)gd);
        TreeColumn tc = new TreeColumn(this.tree, 0);
        tc.setText(Messages.StructureTreeTab_8);
        tc.setWidth(300);
        tc = new TreeColumn(this.tree, 0);
        tc.setText(Messages.StructureTreeTab_9);
        tc.setWidth(100);
        tc = new TreeColumn(this.tree, 0);
        tc.setText(Messages.StructureTreeTab_10);
        tc.setWidth(200);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
    }

    private TreeItem createObj(TreeItem ti0, String text, String name, Object obj) {
        TreeItem t = this.create(ti0, text, BL + name + BR);
        if (obj != null) {
            t.setText(2, obj.getClass().getName());
        }
        return t;
    }

    private void expand(TreeItem ti0, String text, Object[] obs) {
        TreeItem ti = this.create(ti0, text, obs == null ? 0 : obs.length);
        if (obs == null || !this.check(ti, obs)) {
            return;
        }
        int i = 0;
        while (i < obs.length) {
            String s = BL + i + BR;
            if (obs[i] instanceof String) {
                this.create(ti, s, (String)obs[i]);
            } else if (obs[i] instanceof CLanguageData) {
                this.update(ti, s, (CLanguageData)obs[i]);
            } else if (obs[i] instanceof CResourceData) {
                this.update(ti, s, (CResourceData)obs[i]);
            } else if (obs[i] instanceof ICExclusionPatternPathEntry) {
                this.update(ti, s, (ICExclusionPatternPathEntry)obs[i]);
            } else if (obs[i] instanceof ICExternalSetting) {
                this.update(ti, s, (ICExternalSetting)obs[i]);
            } else if (obs[i] instanceof ICLanguageSettingEntry) {
                this.update(ti, s, (ICLanguageSettingEntry)obs[i]);
            } else if (obs[i] instanceof ICResourceDescription) {
                this.update(ti, s, (ICResourceDescription)obs[i]);
            } else if (obs[i] instanceof ICSettingObject) {
                this.update(ti, s, (ICSettingObject)obs[i]);
            } else if (obs[i] instanceof IPath) {
                this.update(ti, s, (IPath)obs[i]);
            } else if (obs[i] instanceof IResource) {
                this.update(ti, s, (IResource)obs[i]);
            } else if (obs[i] instanceof IProjectNatureDescriptor) {
                this.update(ti, s, (IProjectNatureDescriptor)obs[i]);
            } else {
                this.update(ti, s, obs[i]);
            }
            ++i;
        }
    }

    private void expandAll(TreeItem ti, boolean b, int level) {
        if (level == -1) {
            ti.setExpanded(b);
        } else {
            ti.setExpanded(level++ < this.currentLevel);
        }
        TreeItem[] tis = ti.getItems();
        if (tis == null) {
            return;
        }
        TreeItem[] treeItemArray = tis;
        int n = tis.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti2 = treeItemArray[n2];
            this.expandAll(ti2, b, level);
            ++n2;
        }
    }

    private int[] flagsToArray(int flags) {
        int[] arr = new int[32];
        int num = 0;
        int i = 1;
        while (i != 0) {
            if ((flags & i) != 0) {
                arr[num++] = i;
            }
            i <<= 1;
        }
        if (num == arr.length) {
            return arr;
        }
        if (num == 0) {
            return new int[0];
        }
        int[] result = new int[num];
        System.arraycopy(arr, 0, result, 0, num);
        return result;
    }

    private int getDepth(TreeItem ti) {
        int x = 0;
        while (ti != null) {
            ti = ti.getParentItem();
            ++x;
        }
        return x;
    }

    @Override
    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
    }

    @Override
    protected void performDefaults() {
    }

    private void update(ICProjectDescription prj) {
        TreeItem ti = new TreeItem(this.tree, 0);
        if (!this.check(ti, prj)) {
            return;
        }
        ti.setText(0, "ICProjectDescription");
        this.update(ti, "getActiveConfiguration()", prj.getActiveConfiguration());
        this.expand(ti, "getConfigurations()", prj.getConfigurations());
        this.create(ti, "getId()", prj.getId());
        this.create(ti, "getName()", prj.getName());
        this.update(ti, "getParent()", prj.getParent());
        this.update(ti, "getProject()", prj.getProject());
        this.create(ti, "getType()", prj.getType());
        this.create(ti, "isModified()", prj.isModified());
        this.create(ti, "isReadOnly()", prj.isReadOnly());
        this.create(ti, "isValid()", prj.isValid());
    }

    private TreeItem update(TreeItem ti0, String text, CBuildData bd) {
        TreeItem ti = this.createObj(ti0, text, bd == null ? NULL : bd.getName(), bd);
        if (bd == null || !this.check(ti, bd)) {
            return ti;
        }
        this.update(ti, "getBuilderCWD()", bd.getBuilderCWD());
        this.createObj(ti, "getBuildEnvironmentContributor()", "", bd.getBuildEnvironmentContributor());
        this.expand(ti, "getErrorParserIDs()", bd.getErrorParserIDs());
        this.create(ti, "getId()", bd.getId());
        this.create(ti, "getName()", bd.getName());
        this.expand(ti, "getOutputDirectories()", bd.getOutputDirectories());
        this.create(ti, "getType()", bd.getType());
        this.create(ti, "isValid()", bd.isValid());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, CConfigurationData cd) {
        TreeItem ti = this.createObj(ti0, text, cd == null ? NULL : cd.getName(), cd);
        if (cd == null || !this.check(ti, cd)) {
            return ti;
        }
        this.update(ti, "getBuildData()", cd.getBuildData());
        this.createObj(ti, "getBuildVariablesContributor()", "", cd.getBuildVariablesContributor());
        this.create(ti, "getDescription()", cd.getDescription());
        this.create(ti, "getId()", cd.getId());
        this.create(ti, "getName()", cd.getName());
        this.expand(ti, "getResourceDatas()", cd.getResourceDatas());
        this.update(ti, "getRootFolderData()", (CResourceData)cd.getRootFolderData());
        this.update(ti, "getTargetPlatformData()", cd.getTargetPlatformData());
        this.create(ti, "getType()", cd.getType());
        this.create(ti, "isValid()", cd.isValid());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, CLanguageData ls) {
        int[] kind;
        TreeItem ti = this.createObj(ti0, text, ls == null ? NULL : ls.getName(), ls);
        if (ls == null || !this.check(ti, ls)) {
            return ti;
        }
        this.create(ti, "getId()", ls.getId());
        this.create(ti, "getLanguageId()", ls.getLanguageId());
        this.create(ti, "getName()", ls.getName());
        this.expand(ti, "getSourceContentTypeIds()", ls.getSourceContentTypeIds());
        this.expand(ti, "getSourceExtensions()", ls.getSourceExtensions());
        this.create(ti, "getType()", ls.getType());
        int k = ls.getSupportedEntryKinds();
        TreeItem ti1 = this.create(ti, "getSupportedEntryKinds()", k);
        int[] nArray = kind = this.flagsToArray(k);
        int n = kind.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            TreeItem ti2 = this.create(ti1, "Kind", element);
            this.expand(ti2, "getEntries", ls.getEntries(element));
            ++n2;
        }
        this.create(ti, "isValid()", ls.isValid());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, CResourceData bd) {
        TreeItem ti = this.createObj(ti0, text, bd == null ? NULL : bd.getName(), bd);
        if (bd == null || !this.check(ti, bd)) {
            return ti;
        }
        this.create(ti, "getId()", bd.getId());
        if (bd instanceof CFolderData) {
            this.expand(ti, "getLanguageDatas()", ((CFolderData)bd).getLanguageDatas());
        }
        this.create(ti, "getName()", bd.getName());
        this.update(ti, "getPath()", bd.getPath());
        this.create(ti, "getType()", bd.getType());
        this.create(ti, "isValid()", bd.isValid());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, CTargetPlatformData bd) {
        TreeItem ti = this.createObj(ti0, text, bd == null ? NULL : bd.getName(), bd);
        if (bd == null || !this.check(ti, bd)) {
            return ti;
        }
        this.expand(ti, "getBinaryParserIds()", bd.getBinaryParserIds());
        this.create(ti, "getId()", bd.getId());
        this.create(ti, "getName()", bd.getName());
        this.create(ti, "getType()", bd.getType());
        this.create(ti, "isValid()", bd.isValid());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, ICBuildSetting obj) {
        TreeItem ti = this.createObj(ti0, text, obj == null ? NULL : obj.getName(), obj);
        if (obj == null || !this.check(ti, obj)) {
            return ti;
        }
        this.update(ti, "getBuilderCWD()", obj.getBuilderCWD());
        this.createObj(ti, "getBuildEnvironmentContributor()", "", obj.getBuildEnvironmentContributor());
        ICConfigurationDescription cd = obj.getConfiguration();
        this.createObj(ti, "getConfiguration()", cd == null ? NULL : cd.getName(), cd);
        this.expand(ti, "getErrorParserIDs()", obj.getErrorParserIDs());
        this.create(ti, "getId()", obj.getId());
        this.create(ti, "getName()", obj.getName());
        this.expand(ti, "getOutputDirectories()", obj.getOutputDirectories());
        this.update(ti, "getParent()", obj.getParent());
        this.create(ti, "getType()", obj.getType());
        this.create(ti, "isReadOnly()", obj.isReadOnly());
        this.create(ti, "isValid()", obj.isValid());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, ICConfigurationDescription cfg) {
        TreeItem ti = this.createObj(ti0, text, cfg == null ? NULL : cfg.getName(), cfg);
        if (cfg == null || !this.check(ti, cfg)) {
            return ti;
        }
        if (this.getDepth(ti) > 5) {
            return ti;
        }
        this.update(ti, "getBuildSetting()", cfg.getBuildSetting());
        this.create(ti, "getBuildSystemId()", cfg.getBuildSystemId());
        this.createObj(ti, "getBuildVariablesContributor()", "", cfg.getBuildVariablesContributor());
        this.update(ti, "getConfigurationData()", cfg.getConfigurationData());
        this.create(ti, "getDescription()", cfg.getDescription());
        this.expand(ti, "getExternalSettings()", cfg.getExternalSettings());
        this.expand(ti, "getFileDescriptions()", cfg.getFileDescriptions());
        this.expand(ti, "getFolderDescriptions()", cfg.getFolderDescriptions());
        this.create(ti, "getId()", cfg.getId());
        this.create(ti, "getName()", cfg.getName());
        this.update(ti, "getParent()", cfg.getParent());
        this.update(ti, "getReferenceInfo()", cfg.getReferenceInfo());
        this.expand(ti, "getResourceDescriptions()", cfg.getResourceDescriptions());
        this.update(ti, "getRootFolderDescription()", (ICResourceDescription)cfg.getRootFolderDescription());
        this.expand(ti, "getSourceEntries()", cfg.getSourceEntries());
        this.update(ti, "getTargetPlatformSetting()", cfg.getTargetPlatformSetting());
        this.create(ti, "getType()", cfg.getType());
        this.create(ti, "isActive()", cfg.isActive());
        this.create(ti, "isModified()", cfg.isModified());
        this.create(ti, "isPreferenceConfiguration()", cfg.isPreferenceConfiguration());
        this.create(ti, "isReadOnly()", cfg.isReadOnly());
        this.create(ti, "isValid()", cfg.isValid());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, ICExclusionPatternPathEntry s) {
        TreeItem ti = this.createObj(ti0, text, s.getName(), s);
        if (!this.check(ti, s)) {
            return ti;
        }
        char[][] chrs = s.fullExclusionPatternChars();
        TreeItem ti1 = this.create(ti, "fullExclusionPatternChars()", chrs.length);
        int j = 0;
        while (j < chrs.length) {
            this.create(ti1, BL + j + BR, new String(chrs[j]));
            ++j;
        }
        this.expand(ti, "getExclusionPatterns()", s.getExclusionPatterns());
        this.create(ti, "getFlags()", s.getFlags());
        this.update(ti, "getFullPath()", s.getFullPath());
        this.create(ti, "getKind()", s.getKind());
        this.update(ti, "getLocation()", s.getLocation());
        this.create(ti, "getName()", s.getName());
        this.create(ti, "getValue()", s.getValue());
        this.create(ti, "isBuiltIn()", s.isBuiltIn());
        this.create(ti, "isReadOnly()", s.isReadOnly());
        this.create(ti, "isResolved()", s.isResolved());
        this.create(ti, "isValueWorkspacePath()", s.isValueWorkspacePath());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, ICExternalSetting es) {
        TreeItem ti = this.createObj(ti0, text, "", es);
        if (!this.check(ti, es)) {
            return ti;
        }
        this.expand(ti, "getCompatibleContentTypeIds()", es.getCompatibleContentTypeIds());
        this.expand(ti, "getCompatibleExtensions()", es.getCompatibleExtensions());
        this.expand(ti, "getCompatibleLanguageIds()", es.getCompatibleLanguageIds());
        this.expand(ti, "getEntries()", es.getEntries());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, ICResourceDescription rcfg) {
        TreeItem ti = this.createObj(ti0, text, rcfg == null ? NULL : rcfg.getName(), rcfg);
        if (rcfg == null || !this.check(ti, rcfg)) {
            return ti;
        }
        this.update(ti, "getConfiguration()", rcfg.getConfiguration());
        this.create(ti, "getId()", rcfg.getId());
        this.create(ti, "getName()", rcfg.getName());
        if (rcfg instanceof ICFileDescription) {
            this.update(ti, "getLanguageSettings()", ((ICFileDescription)rcfg).getLanguageSetting());
        } else if (rcfg instanceof ICFolderDescription) {
            this.expand(ti, "getLanguageSettings()", ((ICFolderDescription)rcfg).getLanguageSettings());
            Object[] rds = ((ICFolderDescription)rcfg).getNestedResourceDescriptions();
            if (this.getDepth(ti) > 5) {
                this.create(ti, "getNestedResourceDescriptions()", rds.length);
            } else {
                this.expand(ti, "getNestedResourceDescriptions()", rds);
            }
        }
        this.update(ti, "getParent()", rcfg.getParent());
        this.update(ti, "getParentFolderDescription()", (ICResourceDescription)rcfg.getParentFolderDescription());
        this.update(ti, "getPath()", rcfg.getPath());
        this.create(ti, "getType()", rcfg.getType());
        this.create(ti, "isExcluded()", rcfg.isExcluded());
        this.create(ti, "isReadOnly()", rcfg.isReadOnly());
        if (rcfg instanceof ICFolderDescription) {
            this.create(ti, "isRoot()", ((ICFolderDescription)rcfg).isRoot());
        }
        this.create(ti, "isValid()", rcfg.isValid());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, ICLanguageSetting ls) {
        int[] kind;
        TreeItem ti = this.createObj(ti0, text, ls == null ? NULL : ls.getName(), ls);
        if (ls == null || !this.check(ti, ls)) {
            return ti;
        }
        this.update(ti, "getConfiguration()", ls.getConfiguration());
        this.create(ti, "getId()", ls.getId());
        this.create(ti, "getLanguageId()", ls.getLanguageId());
        this.create(ti, "getName()", ls.getName());
        this.update(ti, "getParent()", ls.getParent());
        this.expand(ti, "getSourceContentTypeIds()", ls.getSourceContentTypeIds());
        this.expand(ti, "getSourceExtensions()", ls.getSourceExtensions());
        this.create(ti, "getType()", ls.getType());
        int k = ls.getSupportedEntryKinds();
        TreeItem ti1 = this.create(ti, "getSupportedEntryKinds()", k);
        int[] nArray = kind = this.flagsToArray(k);
        int n = kind.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            TreeItem ti2 = this.create(ti1, "Kind", element);
            this.expand(ti2, "getResolvedSettingEntries", ls.getResolvedSettingEntries(element));
            this.expand(ti2, "getSettingEntries", ls.getSettingEntries(element));
            ++n2;
        }
        this.create(ti, "isReadOnly()", ls.isReadOnly());
        this.create(ti, "isValid()", ls.isValid());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, ICLanguageSettingEntry ent) {
        TreeItem ti = this.createObj(ti0, text, ent == null ? NULL : ent.getName(), ent);
        if (ent == null || !this.check(ti, ent)) {
            return ti;
        }
        this.create(ti, "getFlags()", ent.getFlags());
        this.create(ti, "getKind()", ent.getKind());
        this.create(ti, "getName()", ent.getName());
        this.create(ti, "getValue()", ent.getValue());
        this.create(ti, "isBuiltIn()", ent.isBuiltIn());
        this.create(ti, "isReadOnly()", ent.isReadOnly());
        this.create(ti, "isResolved()", ent.isResolved());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, ICSettingContainer c) {
        TreeItem ti = this.createObj(ti0, text, "", c);
        if (!this.check(ti, c)) {
            return ti;
        }
        if (this.getDepth(ti) > 5) {
            return ti;
        }
        this.expand(ti, "getChildSettings()", c.getChildSettings());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, ICSettingObject obj) {
        TreeItem ti = this.createObj(ti0, text, obj == null ? NULL : obj.getName(), obj);
        if (obj == null || !this.check(ti, obj)) {
            return ti;
        }
        if (obj instanceof ICTargetPlatformSetting) {
            this.expand(ti, "getBinaryParserIds()", ((ICTargetPlatformSetting)obj).getBinaryParserIds());
        }
        this.update(ti, "getConfiguration()", obj.getConfiguration());
        this.create(ti, "getId()", obj.getId());
        this.create(ti, "getName()", obj.getName());
        this.createObj(ti, "getParent()", "", obj.getParent());
        this.create(ti, "getType()", obj.getType());
        this.create(ti, "isReadOnly()", obj.isReadOnly());
        this.create(ti, "isValid()", obj.isValid());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, ICTargetPlatformSetting obj) {
        TreeItem ti = this.createObj(ti0, text, obj == null ? NULL : obj.getName(), obj);
        if (obj == null || !this.check(ti, obj)) {
            return ti;
        }
        this.update(ti, "getConfiguration()", obj.getConfiguration());
        this.create(ti, "getId()", obj.getId());
        this.create(ti, "getName()", obj.getName());
        this.update(ti, "getParent()", obj.getParent());
        this.create(ti, "getType()", obj.getType());
        this.create(ti, "isReadOnly()", obj.isReadOnly());
        this.create(ti, "isValid()", obj.isValid());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, IPath p) {
        TreeItem ti = this.createObj(ti0, text, p == null ? NULL : p.toString(), p);
        if (p == null || !this.check(ti, p)) {
            return ti;
        }
        this.create(ti, "getDevice()", p.getDevice());
        this.create(ti, "getFileExtension()", p.getFileExtension());
        this.create(ti, "hasTrailingSeparator()", p.hasTrailingSeparator());
        this.create(ti, "isAbsolute()", p.isAbsolute());
        this.create(ti, "isEmpty()", p.isEmpty());
        this.create(ti, "isRoot()", p.isRoot());
        this.create(ti, "isUNC()", p.isUNC());
        TreeItem ti1 = this.create(ti, "segmentCount()", p.segmentCount());
        int i = 0;
        while (i < p.segmentCount()) {
            this.create(ti1, "segment(" + i + ")", p.segment(i));
            ++i;
        }
        this.create(ti, "toOSString()", p.toOSString());
        this.create(ti, "toPortableString()", p.toPortableString());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, IProject prj) {
        TreeItem ti = this.createObj(ti0, text, prj == null ? NULL : prj.getName(), prj);
        if (prj == null || !this.check(ti, prj)) {
            return ti;
        }
        this.create(ti, "exists()", prj.exists());
        try {
            this.create(ti, "getDefaultCharset()", prj.getDefaultCharset());
            prj.getDescription();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.update(ti, "getFullPath()", prj.getFullPath());
        this.create(ti, "getName()", prj.getName());
        this.update(ti, "getParent()", (IResource)prj.getParent());
        try {
            IProject[] ps = prj.getReferencedProjects();
            TreeItem ti1 = this.create(ti, "getReferencedProjects()", ps == null ? 0 : ps.length);
            if (ps != null) {
                int i = 0;
                while (i < ps.length) {
                    this.update(ti1, BL + i + BR, ps[i]);
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        prj.getResourceAttributes();
        this.create(ti, "getType()", prj.getType());
        this.update(ti, "getWorkspace()", prj.getWorkspace());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, IProjectNatureDescriptor nd) {
        TreeItem ti = this.createObj(ti0, text, nd == null ? NULL : nd.getLabel(), nd);
        if (nd == null || !this.check(ti, nd)) {
            return ti;
        }
        this.create(ti, "getLabel()", nd.getLabel());
        this.create(ti, "getNatureId()", nd.getNatureId());
        this.expand(ti, "getNatureSetIds()", nd.getNatureSetIds());
        this.expand(ti, "getRequiredNatureIds()", nd.getRequiredNatureIds());
        this.create(ti, "isLinkingAllowed()", nd.isLinkingAllowed());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, IResource c) {
        TreeItem ti = this.createObj(ti0, text, c == null ? NULL : c.getName(), c);
        if (c == null || !this.check(ti, c)) {
            return ti;
        }
        if (this.getDepth(ti) > 5) {
            return ti;
        }
        if (c instanceof IContainer) {
            try {
                this.create(ti, "getDefaultCharset()", ((IContainer)c).getDefaultCharset());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        this.create(ti, "getFileExtension()", c.getFileExtension());
        this.update(ti, "getFullPath()", c.getFullPath());
        this.update(ti, "getLocation()", c.getLocation());
        this.update(ti, "getLocationURI()", c.getLocationURI());
        this.create(ti, "getName()", c.getName());
        this.update(ti, "getParent()", (IResource)c.getParent());
        this.update(ti, "getProject()", c.getProject());
        if (c instanceof IWorkspaceRoot) {
            this.expand(ti, "getProjects()", ((IWorkspaceRoot)c).getProjects());
        }
        this.update(ti, "getProjectRelativePath()", c.getProjectRelativePath());
        this.update(ti, "getRawLocation()", c.getRawLocation());
        this.update(ti, "getRawLocationURI()", c.getRawLocationURI());
        this.update(ti, "getResourceAttributes()", c.getResourceAttributes());
        this.create(ti, "getType()", c.getType());
        this.createObj(ti, "getWorkspace()", "", c.getWorkspace());
        this.create(ti, "isAccessible()", c.isAccessible());
        this.create(ti, "isDerived()", c.isDerived());
        this.create(ti, "isLinked()", c.isLinked());
        this.create(ti, "isPhantom()", c.isPhantom());
        this.create(ti, "isSynchronized(ZERO)", c.isSynchronized(0));
        this.create(ti, "isSynchronized(INFINITE)", c.isSynchronized(2));
        this.create(ti, "isTeamPrivateMember()", c.isTeamPrivateMember());
        if (c instanceof IContainer) {
            try {
                this.expand(ti, "members()", ((IContainer)c).members());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, IWorkspace w) {
        TreeItem ti = this.createObj(ti0, text, "", w);
        if (!this.check(ti, w)) {
            return ti;
        }
        this.update(ti, "getDescription()", w.getDescription());
        this.expand(ti, "getNatureDescriptors()", w.getNatureDescriptors());
        this.createObj(ti, "getPathVariableManager()", "", w.getPathVariableManager());
        this.update(ti, "getRoot()", (IResource)w.getRoot());
        this.createObj(ti, "getSynchronizer()", "", w.getSynchronizer());
        this.create(ti, "isAutoBuilding()", w.isAutoBuilding());
        this.create(ti, "isTreeLocked()", w.isTreeLocked());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, IWorkspaceDescription w) {
        TreeItem ti = this.createObj(ti0, text, "", w);
        if (!this.check(ti, w)) {
            return ti;
        }
        this.expand(ti, "getBuildOrder()", w.getBuildOrder());
        this.create(ti, "getFileStateLongevity()", w.getFileStateLongevity());
        this.create(ti, "getMaxBuildIterations()", w.getMaxBuildIterations());
        this.create(ti, "getMaxFileStates()", w.getMaxFileStates());
        this.create(ti, "getMaxFileStateSize()", w.getMaxFileStateSize());
        this.create(ti, "getSnapshotInterval()", w.getSnapshotInterval());
        this.create(ti, "isAutoBuilding()", w.isAutoBuilding());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, Object ob) {
        TreeItem ti = this.createObj(ti0, BL + text + BR, "???", ob);
        this.check(ti, ob);
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, Map<String, String> m) {
        String s2 = m == null ? NULL : String.valueOf(m.size());
        TreeItem ti = this.createObj(ti0, text, s2, m);
        if (m == null || !this.check(ti, m)) {
            return ti;
        }
        for (String s2 : m.keySet()) {
            this.create(ti, String.valueOf(s2) + " =", m.get(s2));
        }
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, ResourceAttributes ra) {
        TreeItem ti = this.createObj(ti0, text, "", ra);
        if (!this.check(ti, ra)) {
            return ti;
        }
        this.create(ti, "isArchive()", ra.isArchive());
        this.create(ti, "isExecutable()", ra.isExecutable());
        this.create(ti, "isHidden()", ra.isHidden());
        this.create(ti, "isReadOnly()", ra.isReadOnly());
        return ti;
    }

    private TreeItem update(TreeItem ti0, String text, URI uri) {
        TreeItem ti = this.createObj(ti0, text, uri == null ? NULL : uri.toString(), uri);
        if (uri == null || !this.check(ti, uri)) {
            return ti;
        }
        this.create(ti, "getAuthority()", uri.getAuthority());
        this.create(ti, "getFragment()", uri.getFragment());
        this.create(ti, "getHost()", uri.getHost());
        this.create(ti, "getPath()", uri.getPath());
        this.create(ti, "getPort()", uri.getPort());
        this.create(ti, "getQuery()", uri.getQuery());
        this.create(ti, "isAbsolute()", uri.isAbsolute());
        this.create(ti, "isOpaque()", uri.isOpaque());
        this.create(ti, "toASCIIString()", uri.toASCIIString());
        return ti;
    }

    @Override
    public void updateData(ICResourceDescription rcfg) {
        this.cfg = rcfg;
        this.tree.getDisplay().asyncExec(() -> {
            try {
                this.tree.removeAll();
                TreeItem ti = new TreeItem(this.tree, 0);
                ti.setText(0, Messages.StructureTreeTab_11);
                this.tree.update();
                this.tree.setRedraw(false);
                this.tree.removeAll();
                switch (this.combo.getSelectionIndex()) {
                    case 0: {
                        this.update(this.cfg.getConfiguration().getProjectDescription());
                        break;
                    }
                    case 1: {
                        this.update((TreeItem)null, "ICConfigurationDescription", this.cfg.getConfiguration());
                        break;
                    }
                    case 2: {
                        this.update((TreeItem)null, "ICResourceDescription", this.cfg);
                    }
                }
            }
            finally {
                this.tree.setRedraw(true);
            }
        });
    }

    @Override
    public boolean canBeVisible() {
        return CDTPrefUtil.getBool("properties.data.hierarchy.enable");
    }

    @Override
    protected void updateButtons() {
    }

    protected class LevelDialog
    extends Dialog {
        protected LevelDialog() {
            super(CUIPlugin.getActiveWorkbenchShell());
        }

        protected Control createDialogArea(Composite parent) {
            Composite c = new Composite(parent, 0);
            c.setLayoutData((Object)new GridData(1808));
            c.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(c, 0);
            l.setText(Messages.StructureTreeTab_0);
            c.setLayoutData((Object)new GridData(1));
            Spinner sp = new Spinner(c, 2048);
            sp.setMaximum(16);
            sp.setMinimum(0);
            sp.setSelection(StructureTreeTab.this.currentLevel);
            sp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StructureTreeTab.this.currentLevel = ((Spinner)e.widget).getSelection();
                }
            });
            return c;
        }
    }
}

