/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

@Deprecated
public class MultiLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String DEFAULT_MODE = "default";
    private static final String NAME_PROP = "name";
    private static final String ENABLED_PROP = "enabled";
    private static final String MODE_PROP = "mode";
    private static final String ACTION_PROP = "action";
    private static final String ACTION_PARAM_PROP = "actionParam";
    public static String MULTI_LAUNCH_CONSTANTS_PREFIX = "org.eclipse.cdt.launch.launchGroup";

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new MultiLaunch(configuration, mode);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IPreferenceStore prefStore = DebugUIPlugin.getDefault().getPreferenceStore();
        boolean dstore = prefStore.getBoolean("org.eclipse.debug.ui.auto_remove_old_launches");
        try {
            monitor.beginTask(String.valueOf(LaunchMessages.MultiLaunchConfigurationDelegate_0) + configuration.getName(), 1000);
            prefStore.setValue("org.eclipse.debug.ui.auto_remove_old_launches", false);
            List<LaunchElement> launches = MultiLaunchConfigurationDelegate.createLaunchElements(configuration, new ArrayList<LaunchElement>());
            for (LaunchElement le : launches) {
                ILaunchConfiguration conf;
                if (!le.enabled || (conf = MultiLaunchConfigurationDelegate.findLaunch(le.name)) == null) continue;
                String localMode = le.mode != null && !le.mode.equals(DEFAULT_MODE) ? le.mode : mode;
                if (!conf.supportsMode(localMode)) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)LaunchMessages.LaunchUIPlugin_Error, (String)NLS.bind((String)LaunchMessages.MultiLaunchConfigurationDelegate_Cannot, (Object)conf.toString(), (Object)localMode)));
                    continue;
                }
                try {
                    if (configuration.getName().equals(conf.getName())) {
                        throw new StackOverflowError();
                    }
                    ILaunch subLaunch = DebugUIPlugin.buildAndLaunch((ILaunchConfiguration)conf, (String)localMode, (IProgressMonitor)new SubProgressMonitor(monitor, 1000 / launches.size()));
                    ((MultiLaunch)launch).addSubLaunch(subLaunch);
                    ((MultiLaunch)launch).launchChanged(subLaunch);
                    DebugUIPlugin.getDefault().getLaunchConfigurationManager().setRecentLaunch(launch);
                    this.postLaunchAction(subLaunch, le.action, le.actionParam, monitor);
                }
                catch (StackOverflowError e) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)LaunchMessages.LaunchUIPlugin_Error, (String)NLS.bind((String)LaunchMessages.MultiLaunchConfigurationDelegate_Loop, (Object)conf.toString())));
                }
            }
            if (!launch.hasChildren()) {
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            }
        }
        finally {
            prefStore.setValue("org.eclipse.debug.ui.auto_remove_old_launches", dstore);
            monitor.done();
        }
    }

    private void postLaunchAction(ILaunch subLaunch, LaunchElement.EPostLaunchAction action, Object actionParam, IProgressMonitor monitor) {
        switch (action) {
            case NONE: {
                return;
            }
            case WAIT_FOR_TERMINATION: {
                monitor.subTask(String.valueOf(LaunchMessages.MultiLaunchConfigurationDelegate_Action_WaitingForTermination) + " " + subLaunch.getLaunchConfiguration().getName());
                while (!subLaunch.isTerminated() && !monitor.isCanceled()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                monitor.subTask("");
                break;
            }
            case DELAY: {
                Integer waitSecs = (Integer)actionParam;
                if (waitSecs == null) break;
                monitor.subTask(NLS.bind((String)LaunchMessages.MultiLaunchConfigurationDelegate_Action_Delaying, (Object)waitSecs.toString()));
                try {
                    Thread.sleep(waitSecs * 1000);
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
            default: {
                assert (false) : "new post launch action type is missing logic";
                break;
            }
        }
    }

    protected void buildProjects(IProject[] projects, IProgressMonitor monitor) throws CoreException {
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    protected static ILaunchConfiguration findLaunch(String name) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations();
        int i = 0;
        while (i < launchConfigurations.length) {
            ILaunchConfiguration lConf = launchConfigurations[i];
            if (lConf.getName().equals(name)) {
                return lConf;
            }
            ++i;
        }
        return null;
    }

    public static List<LaunchElement> createLaunchElements(ILaunchConfiguration configuration, List<LaunchElement> input) {
        try {
            Map attrs = configuration.getAttributes();
            for (String attr : attrs.keySet()) {
                try {
                    LaunchElement.EPostLaunchAction action;
                    if (!attr.startsWith(MULTI_LAUNCH_CONSTANTS_PREFIX)) continue;
                    String prop = attr.substring(MULTI_LAUNCH_CONSTANTS_PREFIX.length() + 1);
                    int k = prop.indexOf(46);
                    String num = prop.substring(0, k);
                    int index = Integer.parseInt(num);
                    String name = prop.substring(k + 1);
                    if (!name.equals(NAME_PROP)) continue;
                    LaunchElement el = new LaunchElement();
                    el.index = index;
                    el.name = (String)attrs.get(attr);
                    Integer actionParam = null;
                    String actionStr = (String)attrs.get(MultiLaunchConfigurationDelegate.getProp(index, ACTION_PROP));
                    try {
                        action = LaunchElement.EPostLaunchAction.valueOf(actionStr);
                    }
                    catch (Exception e) {
                        action = LaunchElement.EPostLaunchAction.NONE;
                    }
                    if (action == LaunchElement.EPostLaunchAction.DELAY) {
                        try {
                            actionParam = Integer.parseInt((String)attrs.get(MultiLaunchConfigurationDelegate.getProp(index, ACTION_PARAM_PROP)));
                        }
                        catch (NumberFormatException exc) {
                            LaunchUIPlugin.log(exc);
                        }
                    }
                    el.action = action;
                    el.actionParam = actionParam;
                    el.mode = (String)attrs.get(MultiLaunchConfigurationDelegate.getProp(index, MODE_PROP));
                    el.enabled = Boolean.parseBoolean((String)attrs.get(MultiLaunchConfigurationDelegate.getProp(index, ENABLED_PROP)));
                    try {
                        el.data = MultiLaunchConfigurationDelegate.findLaunch(el.name);
                    }
                    catch (Exception e) {
                        el.data = null;
                    }
                    while (index >= input.size()) {
                        input.add(null);
                    }
                    input.set(index, el);
                }
                catch (Exception e) {
                    LaunchUIPlugin.log(e);
                }
            }
        }
        catch (CoreException e) {
            LaunchUIPlugin.log(e);
        }
        return input;
    }

    public static void storeLaunchElements(ILaunchConfigurationWorkingCopy configuration, List<LaunchElement> input) {
        int i = 0;
        MultiLaunchConfigurationDelegate.removeLaunchElements(configuration);
        for (LaunchElement el : input) {
            if (el == null) continue;
            configuration.setAttribute(MultiLaunchConfigurationDelegate.getProp(i, NAME_PROP), el.name);
            configuration.setAttribute(MultiLaunchConfigurationDelegate.getProp(i, ACTION_PROP), el.action.toString());
            configuration.setAttribute(MultiLaunchConfigurationDelegate.getProp(i, ACTION_PARAM_PROP), el.actionParam != null ? el.actionParam.toString() : null);
            configuration.setAttribute(MultiLaunchConfigurationDelegate.getProp(i, MODE_PROP), el.mode);
            configuration.setAttribute(MultiLaunchConfigurationDelegate.getProp(i, ENABLED_PROP), String.valueOf(el.enabled));
            ++i;
        }
    }

    public static void removeLaunchElements(ILaunchConfigurationWorkingCopy configuration) {
        try {
            Map attrs = configuration.getAttributes();
            for (String attr : attrs.keySet()) {
                try {
                    if (!attr.startsWith(MULTI_LAUNCH_CONSTANTS_PREFIX)) continue;
                    configuration.removeAttribute(attr);
                }
                catch (Exception e) {
                    LaunchUIPlugin.log(e);
                }
            }
        }
        catch (CoreException e) {
            LaunchUIPlugin.log(e);
        }
    }

    public static String getProp(int index, String string) {
        return String.valueOf(MULTI_LAUNCH_CONSTANTS_PREFIX) + "." + index + "." + string;
    }

    public static boolean isValidLaunchReference(ILaunchConfiguration config) {
        return DebugUIPlugin.doLaunchConfigurationFiltering((ILaunchConfiguration)config) && !WorkbenchActivityHelper.filterItem((Object)config);
    }

    public static class LaunchElement {
        public int index;
        public boolean enabled;
        public String mode;
        public EPostLaunchAction action;
        public Object actionParam;
        public String name;
        public ILaunchConfiguration data;

        public static String actionEnumToStr(EPostLaunchAction action) {
            switch (action) {
                case NONE: {
                    return LaunchMessages.MultiLaunchConfigurationDelegate_Action_None;
                }
                case WAIT_FOR_TERMINATION: {
                    return LaunchMessages.MultiLaunchConfigurationDelegate_Action_WaitUntilTerminated;
                }
                case DELAY: {
                    return LaunchMessages.MultiLaunchConfigurationDelegate_Action_Delay;
                }
            }
            assert (false) : "new post launch action type is missing logic";
            return LaunchMessages.MultiLaunchConfigurationDelegate_Action_None;
        }

        public static EPostLaunchAction strToActionEnum(String str) {
            if (str.equals(LaunchMessages.MultiLaunchConfigurationDelegate_Action_None)) {
                return EPostLaunchAction.NONE;
            }
            if (str.equals(LaunchMessages.MultiLaunchConfigurationDelegate_Action_WaitUntilTerminated)) {
                return EPostLaunchAction.WAIT_FOR_TERMINATION;
            }
            if (str.equals(LaunchMessages.MultiLaunchConfigurationDelegate_Action_Delay)) {
                return EPostLaunchAction.DELAY;
            }
            assert (false) : "new post launch action type is missing logic";
            return EPostLaunchAction.NONE;
        }

        public static enum EPostLaunchAction {
            NONE,
            WAIT_FOR_TERMINATION,
            DELAY;

        }
    }

    private class MultiLaunch
    extends Launch
    implements ILaunchesListener2 {
        private boolean fTerminated;
        private Map<ILaunch, IProcess[]> subLaunches;

        public MultiLaunch(ILaunchConfiguration launchConfiguration, String mode) {
            super(launchConfiguration, mode, null);
            this.subLaunches = new HashMap<ILaunch, IProcess[]>();
            this.getLaunchManager().addLaunchListener((ILaunchesListener)this);
        }

        public void addSubLaunch(ILaunch subLaunch) {
            this.subLaunches.put(subLaunch, new IProcess[0]);
        }

        private ILaunch[] getSubLaunches() {
            return this.subLaunches.keySet().toArray(new ILaunch[this.subLaunches.keySet().size()]);
        }

        private boolean isChild(ILaunch launch) {
            ILaunch[] iLaunchArray = this.getSubLaunches();
            int n = iLaunchArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch subLaunch = iLaunchArray[n2];
                if (subLaunch == launch) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean isTerminated() {
            if (this.fTerminated) {
                return true;
            }
            if (this.subLaunches.size() == 0) {
                return false;
            }
            ILaunch[] iLaunchArray = this.getSubLaunches();
            int n = iLaunchArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (!launch.isTerminated()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public boolean canTerminate() {
            if (this.subLaunches.size() == 0) {
                return false;
            }
            ILaunch[] iLaunchArray = this.getSubLaunches();
            int n = iLaunchArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (launch.canTerminate()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void terminate() throws DebugException {
            MultiStatus status = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.Launch_terminate_failed, null);
            ILaunch[] iLaunchArray = this.getSubLaunches();
            int n = iLaunchArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (launch.canTerminate()) {
                    try {
                        launch.terminate();
                    }
                    catch (DebugException e) {
                        status.merge(e.getStatus());
                    }
                }
                ++n2;
            }
            if (status.isOK()) {
                return;
            }
            IStatus[] children = status.getChildren();
            if (children.length == 1) {
                throw new DebugException(children[0]);
            }
            throw new DebugException((IStatus)status);
        }

        private void launchTerminated(ILaunch launch) {
            if (this == launch) {
                return;
            }
            if (this.subLaunches.remove(launch) != null && this.subLaunches.size() == 0) {
                this.fTerminated = true;
                this.fireTerminate();
            }
        }

        public void launchChanged(ILaunch launch) {
            Object[] newProcesses;
            Object[] oldProcesses;
            if (this == launch) {
                return;
            }
            if (this.isChild(launch) && !Arrays.equals(oldProcesses = this.subLaunches.get(launch), newProcesses = launch.getProcesses())) {
                Object[] objectArray = oldProcesses;
                int n = oldProcesses.length;
                int n2 = 0;
                while (n2 < n) {
                    Object oldProcess = objectArray[n2];
                    this.removeProcess((IProcess)oldProcess);
                    ++n2;
                }
                objectArray = newProcesses;
                n = newProcesses.length;
                n2 = 0;
                while (n2 < n) {
                    Object newProcess = objectArray[n2];
                    this.addProcess((IProcess)newProcess);
                    ++n2;
                }
                this.subLaunches.put(launch, (IProcess[])newProcesses);
            }
        }

        public void launchRemoved(ILaunch launch) {
            if (this == launch) {
                IProcess[] processes;
                super.launchRemoved(launch);
                IProcess[] iProcessArray = processes = this.getProcesses();
                int n = processes.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcess process = iProcessArray[n2];
                    this.removeProcess(process);
                    ++n2;
                }
                this.getLaunchManager().removeLaunchListener((ILaunchesListener)this);
            }
        }

        public void launchesTerminated(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                this.launchTerminated(launch);
                ++n2;
            }
        }

        public void launchesAdded(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                this.launchAdded(launch);
                ++n2;
            }
        }

        public void launchesChanged(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                this.launchChanged(launch);
                ++n2;
            }
        }

        public void launchesRemoved(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                this.launchRemoved(launch);
                ++n2;
            }
        }
    }
}

