/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.resource;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class BPELResourceSetImpl
extends ResourceSetImpl
implements IResourceChangeListener {
    public static final String BPEL_CONTENT_TYPE = "org.eclipse.bpel.contenttype";
    public static final String SLIGHTLY_HACKED_KEY = "slightly.hacked.resource.set";

    public Resource getResource(URI uri, boolean loadOnDemand, String kind) {
        Resource resource;
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        Map map = this.getURIResourceMap();
        if (map != null && (resource = (Resource)map.get(uri)) != null) {
            if (loadOnDemand && !resource.isLoaded()) {
                try {
                    this.demandLoadHelper(resource);
                }
                catch (Exception ex) {
                    resource.unload();
                }
            }
            return resource;
        }
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        for (Resource resource2 : this.getResources()) {
            if (!theURIConverter.normalize(resource2.getURI()).equals(normalizedURI)) continue;
            if (loadOnDemand && !resource2.isLoaded()) {
                try {
                    this.demandLoadHelper(resource2);
                }
                catch (Exception ex) {
                    resource2.unload();
                    break;
                }
            }
            if (map != null) {
                map.put(uri, resource2);
            }
            return resource2;
        }
        if (loadOnDemand) {
            Resource resource2;
            resource2 = this.demandCreateResource(uri, kind);
            if (resource2 == null) {
                throw new RuntimeException("Cannot create a resource for '" + uri + "'; a registered resource factory is needed");
            }
            this.demandLoadHelper(resource2);
            if (map != null) {
                map.put(uri, resource2);
            }
            return resource2;
        }
        return null;
    }

    protected Resource demandCreateResource(URI uri, String kind) {
        return this.createResource(uri, kind);
    }

    public Resource.Factory.Registry getResourceFactoryRegistry() {
        if (this.resourceFactoryRegistry == null) {
            this.resourceFactoryRegistry = new ResourceFactoryRegistryImpl(){

                protected Resource.Factory delegatedGetFactory(URI uri, String contentTypeIdentifier) {
                    Map extensionToFactoryMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
                    Object wsilFactory = extensionToFactoryMap.get("wsil");
                    Object wsdlFactory = extensionToFactoryMap.get("wsdl");
                    Map contentTypeToFactoryMap = Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap();
                    if (wsilFactory != null) {
                        contentTypeToFactoryMap.put("wsil", wsilFactory);
                    }
                    if (wsdlFactory != null) {
                        contentTypeToFactoryMap.put("wsdl", wsdlFactory);
                    }
                    return 1.convert((Object)this.getFactory(uri, Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap(), extensionToFactoryMap, contentTypeToFactoryMap, contentTypeIdentifier, false));
                }

                protected URIConverter getURIConverter() {
                    return BPELResourceSetImpl.this.getURIConverter();
                }

                protected Map<?, ?> getContentDescriptionOptions() {
                    return BPELResourceSetImpl.this.getLoadOptions();
                }
            };
        }
        return this.resourceFactoryRegistry;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] deltas = event.getDelta().getAffectedChildren(6, 1);
        this.processDeltas(deltas);
    }

    void processDeltas(IResourceDelta[] deltas) {
        IResourceDelta[] iResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            this.processDeltas(delta.getAffectedChildren(6, 1));
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                if (delta.getKind() == 2) {
                    this.resourceChanged((IFile)resource);
                } else if ((delta.getFlags() & 0x100) != 0 && !BPELResourceSetImpl.isBPELFile(resource)) {
                    this.resourceChanged((IFile)resource);
                }
            }
            ++n2;
        }
    }

    public void setLoadOptions(Map<Object, Object> options) {
        this.loadOptions = options;
    }

    public void resourceChanged(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        if (this.uriResourceMap != null) {
            this.uriResourceMap.remove(uri);
            this.uriResourceMap.remove(normalizedURI);
        }
        EList resourceList = this.getResources();
        if (this.resources.size() < 1) {
            return;
        }
        for (Resource r : new ArrayList(resourceList)) {
            if (!uri.equals(r.getURI()) && !normalizedURI.equals(r.getURI())) continue;
            this.resources.remove((Object)r);
        }
    }

    public static boolean isBPELFile(IResource res) {
        try {
            IContentType type;
            IContentDescription desc;
            if (res.getType() == 1 && (desc = ((IFile)res).getContentDescription()) != null && (type = desc.getContentType()).getId().equals(BPEL_CONTENT_TYPE)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

