/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.debug.model;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.net.URI;
import org.eclipse.ant.internal.launching.debug.model.AntLineBreakpoint;
import org.eclipse.ant.internal.launching.debug.model.AntProperties;
import org.eclipse.ant.internal.launching.debug.model.AntProperty;
import org.eclipse.ant.internal.launching.debug.model.AntStackFrame;
import org.eclipse.ant.internal.launching.debug.model.AntThread;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.debug.model.DebugModelMessages;
import org.eclipse.ant.internal.ui.preferences.AntObjectLabelProvider;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.IDebugModelPresentationExtension;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class AntDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentationExtension {
    public void setAttribute(String attribute, Object value) {
    }

    public Image getImage(Object element) {
        if (element instanceof AntProperty) {
            return AntObjectLabelProvider.getPropertyImage();
        }
        if (element instanceof AntProperties) {
            return AntObjectLabelProvider.getPropertyImage();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof AntStackFrame) {
            AntStackFrame frame = (AntStackFrame)element;
            return this.getStackFrameText(frame);
        }
        if (element instanceof AntThread) {
            AntThread thread = (AntThread)element;
            return this.getThreadText(thread);
        }
        if (element instanceof AntProperty) {
            AntProperty property = (AntProperty)element;
            return property.getText();
        }
        if (element instanceof AntProperties) {
            return ((AntProperties)element).getName();
        }
        return null;
    }

    private String getThreadText(AntThread thread) {
        String name = thread.getName();
        if (name != null) {
            StringBuilder text = new StringBuilder(name);
            if (thread.isSuspended()) {
                IBreakpoint[] breakpoints = thread.getBreakpoints();
                if (breakpoints.length > 0) {
                    AntLineBreakpoint breakpoint = (AntLineBreakpoint)breakpoints[0];
                    IMarker marker = breakpoint.getMarker();
                    String fileName = marker.getResource().getFullPath().lastSegment();
                    String lineNumber = Integer.toString(marker.getAttribute("lineNumber", -1));
                    String breakpointString = null;
                    breakpointString = breakpoint.isRunToLine() ? MessageFormat.format((String)DebugModelMessages.AntDebugModelPresentation_5, (Object[])new Object[]{lineNumber, fileName}) : MessageFormat.format((String)DebugModelMessages.AntDebugModelPresentation_2, (Object[])new Object[]{lineNumber, fileName});
                    text.append(MessageFormat.format((String)DebugModelMessages.AntDebugModelPresentation_3, (Object[])new Object[]{breakpointString}));
                } else {
                    text.append(DebugModelMessages.AntDebugModelPresentation_4);
                }
            }
            return text.toString();
        }
        return null;
    }

    private String getStackFrameText(AntStackFrame frame) {
        String name = frame.getName();
        if (name != null) {
            StringBuilder text = new StringBuilder(name);
            int lineNumber = frame.getLineNumber();
            String lineNumberString = null;
            lineNumberString = lineNumber == 0 ? DebugModelMessages.AntDebugModelPresentation_0 : Integer.toString(lineNumber);
            text.append(MessageFormat.format((String)DebugModelMessages.AntDebugModelPresentation_1, (Object[])new Object[]{lineNumberString}));
            return text.toString();
        }
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        String detail = "";
        try {
            detail = value.getValueString();
        }
        catch (DebugException debugException) {}
        listener.detailComputed(value, detail);
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ILineBreakpoint) {
            return new FileEditorInput((IFile)((ILineBreakpoint)element).getMarker().getResource());
        }
        if (element instanceof LocalFileStorage) {
            File file = ((LocalFileStorage)element).getFile();
            try {
                IFileStore fileStore = EFS.getStore((URI)file.toURI());
                return new FileStoreEditorInput(fileStore);
            }
            catch (CoreException e) {
                AntUIPlugin.log(e);
                return null;
            }
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        return "org.eclipse.ant.ui.internal.editor.AntEditor";
    }

    public boolean requiresUIThread(Object element) {
        return !AntUIImages.isInitialized();
    }
}

