/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.animation.ParallelTimeline;
import org.eclipse.xwt.animation.TimeSpan;
import org.eclipse.xwt.animation.Timeline;
import org.eclipse.xwt.animation.internal.AnimationManager;
import org.eclipse.xwt.animation.internal.ITimeline;
import org.eclipse.xwt.animation.internal.ITimelineGroup;
import org.eclipse.xwt.animation.internal.ScenarioTimeline;
import org.eclipse.xwt.animation.internal.TridentTimeline;
import org.eclipse.xwt.annotation.Containment;
import org.pushingpixels.trident.TimelineScenario;

public class TimelineGroup
extends Timeline {
    private Timeline[] children = EMPTY_ARRAY;
    private Map<Widget, ITimeline> timelines = new WeakHashMap<Widget, ITimeline>();

    @Containment
    public Timeline[] getChildren() {
        return this.children;
    }

    public void setChildren(Timeline[] children) {
        this.children = children;
    }

    protected ITimelineGroup createTimelineGroup(Object target) {
        return new ScenarioTimeline(this, new TimelineScenario(), target);
    }

    @Override
    public void initialize(Object target) {
        Timeline[] timelineArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Timeline child = timelineArray[n2];
            child.initialize(target);
            ++n2;
        }
    }

    @Override
    public void endFinalize(Object target) {
        Timeline[] timelineArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Timeline child = timelineArray[n2];
            child.endFinalize(target);
            ++n2;
        }
    }

    public void start(Event event, Object target, Runnable endRunnable) {
        ITimelineGroup timeline = this.createTimelineGroup(this.findTarget(target));
        this.timelines.put(event.widget, timeline);
        AnimationManager.getInstance().addTimeline(timeline);
        this.updateTimeline(timeline, target);
        timeline.addStateChangedRunnable(endRunnable);
        AnimationManager.getInstance().play(timeline);
    }

    public void stop(Event event, Runnable stateChangedRunnable) {
        ITimeline timeline = this.timelines.get(event.widget);
        if (timeline != null) {
            timeline.addStateChangedRunnable(stateChangedRunnable);
            AnimationManager.getInstance().stop(timeline);
        }
    }

    public void pause(Event event, Runnable endRunnable) {
        ITimeline timeline = this.timelines.get(event.widget);
        if (timeline != null) {
            timeline.addStateChangedRunnable(endRunnable);
            AnimationManager.getInstance().pause(timeline);
        }
    }

    public void resume(Event event, Runnable endRunnable) {
        ITimeline timeline = this.timelines.get(event.widget);
        if (timeline != null) {
            timeline.addStateChangedRunnable(endRunnable);
            AnimationManager.getInstance().resume(timeline);
        }
    }

    public void playReverse(Event event, Runnable endRunnable) {
        ITimeline timeline = this.timelines.get(event.widget);
        if (timeline != null) {
            timeline.addStateChangedRunnable(endRunnable);
            AnimationManager.getInstance().playReverse(timeline);
        }
    }

    @Override
    protected void updateTimeline(ITimeline timeline, Object target) {
        super.updateTimeline(timeline, target);
        ITimelineGroup timelineGroup = (ITimelineGroup)timeline;
        HashMap map = new HashMap();
        Timeline[] timelineArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            ScenarioTimeline scenarioTimeline;
            TimelineScenario.Parallel scenario;
            Timeline child = timelineArray[n2];
            if (child instanceof ParallelTimeline) {
                scenario = new TimelineScenario.Parallel();
                scenarioTimeline = new ScenarioTimeline(child, (TimelineScenario)scenario, child.findTarget(target));
                child.updateTimeline(scenarioTimeline, target);
                timelineGroup.addTimeline(scenarioTimeline);
            } else if (child instanceof TimelineGroup) {
                scenario = new TimelineScenario.Sequence();
                scenarioTimeline = new ScenarioTimeline(child, (TimelineScenario)scenario, child.findTarget(target));
                child.updateTimeline(scenarioTimeline, target);
                timelineGroup.addTimeline(scenarioTimeline);
            } else {
                Object resolveTarget = child.findTarget(target);
                HashMap<TimeSpan, TridentTimeline> tridentTimelineMap = (HashMap<TimeSpan, TridentTimeline>)map.get(resolveTarget);
                if (tridentTimelineMap == null) {
                    tridentTimelineMap = new HashMap<TimeSpan, TridentTimeline>();
                    map.put(resolveTarget, tridentTimelineMap);
                }
                TimeSpan timeSpan = child.getBeginTime();
                TridentTimeline tridentTimeline = (TridentTimeline)tridentTimelineMap.get(child.getBeginTime());
                if (tridentTimeline == null) {
                    if (!(resolveTarget instanceof Widget)) {
                        throw new XWTException("The target of animation should be a Widget");
                    }
                    tridentTimeline = new TridentTimeline(child, (Widget)resolveTarget);
                    timelineGroup.addTimeline(tridentTimeline);
                    tridentTimelineMap.put(timeSpan, tridentTimeline);
                }
                child.updateTimeline(tridentTimeline, target);
            }
            ++n2;
        }
    }
}

