/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;

abstract class PropertyPreferencePage
extends PropertyPage
implements IWorkbenchPreferencePage {
    private static final boolean _debugPreferences = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/preferences-properties"));
    private static final Object DISABLE_LINK = "DISABLE_LINK";
    private Map Data = null;
    private Button EnableProjectSettings;
    private Link ProjectSettingsLink;
    private Control Common;
    private ControlEnableState Enablements;

    public final void applyData(Object data) {
        super.applyData(data);
        if (data instanceof Map) {
            this.Data = (Map)data;
            this.updateLinkEnablement();
        }
    }

    protected abstract Control createCommonContents(Composite var1);

    public final Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Composite checkLinkComposite = new Composite(composite, 0);
        checkLinkComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        checkLinkComposite.setLayout((Layout)new GridLayout(2, false));
        if (this.getProject() != null) {
            this.EnableProjectSettings = new Button(checkLinkComposite, 32);
            this.EnableProjectSettings.setText(SSEUIMessages.EnableProjectSettings);
            this.EnableProjectSettings.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            boolean enabledForProject = this.createPreferenceScopes()[0].getNode(this.getPreferenceNodeQualifier()).getBoolean(this.getProjectSettingsKey(), false);
            this.EnableProjectSettings.setSelection(enabledForProject);
        } else {
            Label spacer = new Label(checkLinkComposite, 32);
            spacer.setLayoutData((Object)new GridData());
        }
        this.ProjectSettingsLink = new Link(checkLinkComposite, 0);
        this.ProjectSettingsLink.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        if (this.getProject() != null) {
            this.ProjectSettingsLink.setText("<a>" + SSEUIMessages.ConfigureWorkspaceSettings + "</a>");
        } else {
            this.ProjectSettingsLink.setText("<a>" + SSEUIMessages.ConfigureProjectSettings + "</a>");
        }
        this.updateLinkEnablement();
        this.ProjectSettingsLink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (PropertyPreferencePage.this.getProject() == null) {
                    PropertyPreferencePage.this.openProjectSettings();
                } else {
                    PropertyPreferencePage.this.openWorkspaceSettings();
                }
            }
        });
        if (this.getProject() != null) {
            Label line = new Label(composite, 258);
            line.setLayoutData((Object)new GridData(256));
        }
        this.Common = this.createCommonContents(composite);
        this.Common.setLayoutData((Object)new GridData(1808));
        if (this.EnableProjectSettings != null) {
            SelectionAdapter selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    PropertyPreferencePage.this.enablePreferenceContent(PropertyPreferencePage.this.EnableProjectSettings.getSelection());
                }
            };
            selectionAdapter.widgetSelected(null);
            this.EnableProjectSettings.addSelectionListener((SelectionListener)selectionAdapter);
        }
        this.applyDialogFont(composite);
        return composite;
    }

    protected IScopeContext[] createPreferenceScopes() {
        IProject project = this.getProject();
        if (project != null) {
            return new IScopeContext[]{new ProjectScope(project), new InstanceScope(), new DefaultScope()};
        }
        return new IScopeContext[]{new InstanceScope(), new DefaultScope()};
    }

    protected abstract String getPreferenceNodeQualifier();

    protected abstract String getPreferencePageID();

    protected IProject getProject() {
        if (this.getElement() != null) {
            if (this.getElement() instanceof IProject) {
                return (IProject)this.getElement();
            }
            Object adapter = this.getElement().getAdapter(IProject.class);
            if (adapter instanceof IProject) {
                return (IProject)adapter;
            }
            adapter = this.getElement().getAdapter(IResource.class);
            if (adapter instanceof IProject) {
                return (IProject)adapter;
            }
        }
        return null;
    }

    protected abstract String getProjectSettingsKey();

    protected abstract String getPropertyPageID();

    protected boolean isElementSettingsEnabled() {
        return this.EnableProjectSettings != null && this.EnableProjectSettings.getSelection();
    }

    void openProjectSettings() {
        Object[] result;
        ListDialog dialog = new ListDialog(this.getShell()){

            protected Control createDialogArea(Composite container) {
                Control area = super.createDialogArea(container);
                this.getTableViewer().setSorter((ViewerSorter)new ResourceSorter(1));
                return area;
            }
        };
        dialog.setMessage(SSEUIMessages.PropertyPreferencePage_02);
        dialog.setContentProvider(new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((IWorkspace)inputElement).getRoot().getProjects();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        dialog.setLabelProvider((ILabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), SSEUIPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        dialog.setInput((Object)ResourcesPlugin.getWorkspace());
        dialog.setTitle(SSEUIMessages.PropertyPreferencePage_01);
        if (dialog.open() == 0 && (result = dialog.getResult()).length > 0) {
            IProject project = (IProject)dialog.getResult()[0];
            HashMap<Object, Boolean> data = new HashMap<Object, Boolean>();
            data.put(DISABLE_LINK, Boolean.TRUE);
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)this.getPropertyPageID(), (String[])new String[]{this.getPropertyPageID()}, data).open();
        }
    }

    void openWorkspaceSettings() {
        HashMap<Object, Boolean> data = new HashMap<Object, Boolean>();
        data.put(DISABLE_LINK, Boolean.TRUE);
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)this.getPreferencePageID(), (String[])new String[]{this.getPreferencePageID()}, data).open();
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        IScopeContext[] preferenceScopes = this.createPreferenceScopes();
        if (this.getProject() != null) {
            if (this.isElementSettingsEnabled()) {
                if (_debugPreferences) {
                    System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + " setting " + "use-project-settings" + " (" + true + ") in scope " + preferenceScopes[0].getName() + ":" + preferenceScopes[0].getLocation());
                }
                preferenceScopes[0].getNode(this.getPreferenceNodeQualifier()).putBoolean(this.getProjectSettingsKey(), this.EnableProjectSettings.getSelection());
            } else {
                if (_debugPreferences) {
                    System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + " removing " + "use-project-settings" + " from scope " + preferenceScopes[0].getName() + ":" + preferenceScopes[0].getLocation());
                }
                preferenceScopes[0].getNode(this.getPreferenceNodeQualifier()).remove(this.getProjectSettingsKey());
            }
        }
        return ok;
    }

    protected void performDefaults() {
        if (this.getProject() != null && this.EnableProjectSettings != null) {
            this.EnableProjectSettings.setSelection(false);
            this.enablePreferenceContent(false);
        }
        super.performDefaults();
    }

    private void updateLinkEnablement() {
        if (this.Data != null && this.ProjectSettingsLink != null) {
            this.ProjectSettingsLink.setEnabled(!Boolean.TRUE.equals(this.Data.get(DISABLE_LINK)));
        }
    }

    protected void enablePreferenceContent(boolean enable) {
        if (enable) {
            if (this.Enablements != null) {
                this.Enablements.restore();
                this.Enablements = null;
            }
        } else if (this.Enablements == null) {
            this.Enablements = ControlEnableState.disable((Control)this.Common);
        }
    }
}

