/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJarEntryResource;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.corext.CorextMessages;
import org.eclipse.wst.jsdt.internal.corext.ValidateEditException;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstall2;
import org.eclipse.wst.jsdt.launching.JavaRuntime;

public final class JavaModelUtil {
    public static final String DEFAULT_CU_SUFFIX = ".js";

    public static IType findType(IJavaScriptProject jproject, String fullyQualifiedName) throws JavaScriptModelException {
        IType type = jproject.findType(fullyQualifiedName);
        if (type != null) {
            return type;
        }
        IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            type = JavaModelUtil.findType(root, fullyQualifiedName);
            if (type != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public static IType findType(IJavaScriptProject jproject, String fullyQualifiedName, WorkingCopyOwner owner) throws JavaScriptModelException {
        IType type = jproject.findType(fullyQualifiedName, owner);
        if (type != null) {
            return type;
        }
        IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            type = JavaModelUtil.findType(root, fullyQualifiedName);
            if (type != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private static IType findType(IPackageFragmentRoot root, String fullyQualifiedName) throws JavaScriptModelException {
        IJavaScriptElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            IType type;
            IPackageFragment pack;
            IJavaScriptElement element = children[i];
            if (element.getElementType() == 4 && fullyQualifiedName.startsWith((pack = (IPackageFragment)element).getElementName()) && (type = JavaModelUtil.findType(pack, fullyQualifiedName)) != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private static IType findType(IPackageFragment pack, String fullyQualifiedName) throws JavaScriptModelException {
        IJavaScriptUnit[] cus = pack.getJavaScriptUnits();
        int i = 0;
        while (i < cus.length) {
            IJavaScriptUnit unit = cus[i];
            IType type = JavaModelUtil.findType(unit, fullyQualifiedName);
            if (type != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private static IType findType(IJavaScriptUnit cu, String fullyQualifiedName) throws JavaScriptModelException {
        IType[] types = cu.getAllTypes();
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            if (JavaModelUtil.getFullyQualifiedName(type).equals(fullyQualifiedName)) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public static IJavaScriptElement findTypeContainer(IJavaScriptProject jproject, String typeContainerName) throws JavaScriptModelException {
        Path path;
        IType result = jproject.findType(typeContainerName);
        if (result == null && !((result = jproject.findElement((IPath)(path = new Path(typeContainerName.replace('.', '/'))))) instanceof IPackageFragment)) {
            result = null;
        }
        return result;
    }

    public static IType findTypeInCompilationUnit(IJavaScriptUnit cu, String typeQualifiedName) throws JavaScriptModelException {
        IType[] types = cu.getAllTypes();
        int i = 0;
        while (i < types.length) {
            String currName = JavaModelUtil.getTypeQualifiedName(types[i]);
            if (typeQualifiedName.equals(currName)) {
                return types[i];
            }
            ++i;
        }
        return null;
    }

    public static IJavaScriptElement findInCompilationUnit(IJavaScriptUnit cu, IJavaScriptElement element) {
        IJavaScriptElement[] elements = cu.findElements(element);
        if (elements != null && elements.length > 0) {
            return elements[0];
        }
        return null;
    }

    public static String getTypeQualifiedName(IType type) {
        try {
            IType declaringType;
            if (type.isBinary() && !type.isAnonymous() && (declaringType = type.getDeclaringType()) != null) {
                return String.valueOf(JavaModelUtil.getTypeQualifiedName(declaringType)) + '.' + type.getElementName();
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        return type.getTypeQualifiedName('.');
    }

    public static String getFullyQualifiedName(IType type) {
        try {
            IType declaringType;
            if (type.isBinary() && !type.isAnonymous() && (declaringType = type.getDeclaringType()) != null) {
                return String.valueOf(JavaModelUtil.getFullyQualifiedName(declaringType)) + '.' + type.getElementName();
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        return type.getFullyQualifiedName('.');
    }

    public static String getTypeContainerName(IType type) {
        IType outerType = type.getDeclaringType();
        if (outerType != null) {
            return JavaModelUtil.getFullyQualifiedName(outerType);
        }
        return type.getPackageFragment().getElementName();
    }

    public static String concatenateName(String name1, String name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static String concatenateName(char[] name1, char[] name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static boolean isVisible(IMember member, IPackageFragment pack) throws JavaScriptModelException {
        int type = member.getElementType();
        if (type == 10 || type == 9 && member.getElementName().startsWith("<")) {
            return false;
        }
        int otherflags = member.getFlags();
        if (Flags.isPublic((int)otherflags)) {
            return true;
        }
        if (Flags.isPrivate((int)otherflags)) {
            return false;
        }
        IPackageFragment otherpack = (IPackageFragment)member.getAncestor(4);
        return pack != null && otherpack != null && JavaModelUtil.isSamePackage(pack, otherpack);
    }

    public static boolean isVisibleInHierarchy(IMember member, IPackageFragment pack) throws JavaScriptModelException {
        int type = member.getElementType();
        return type != 10 && (type != 9 || !member.getElementName().startsWith("<"));
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaScriptElement element) {
        return (IPackageFragmentRoot)element.getAncestor(3);
    }

    public static IFunction findMethod(String name, String[] paramTypes, boolean isConstructor, IType type) throws JavaScriptModelException {
        IFunction[] methods = type.getFunctions();
        int i = 0;
        while (i < methods.length) {
            if (JavaModelUtil.isSameMethodSignature(name, paramTypes, isConstructor, methods[i])) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static IFunction findMethodInHierarchy(ITypeHierarchy hierarchy, IType type, String name, String[] paramTypes, boolean isConstructor) throws JavaScriptModelException {
        IFunction res;
        IFunction method = JavaModelUtil.findMethod(name, paramTypes, isConstructor, type);
        if (method != null) {
            return method;
        }
        IType superClass = hierarchy.getSuperclass(type);
        if (superClass != null && (res = JavaModelUtil.findMethodInHierarchy(hierarchy, superClass, name, paramTypes, isConstructor)) != null) {
            return res;
        }
        return method;
    }

    public static boolean isSameMethodSignature(String name, String[] paramTypes, boolean isConstructor, IFunction curr) throws JavaScriptModelException {
        String[] currParamTypes;
        if ((isConstructor || name.equals(curr.getElementName())) && isConstructor == curr.isConstructor() && paramTypes.length == (currParamTypes = curr.getParameterTypes()).length) {
            int i = 0;
            while (i < paramTypes.length) {
                String t2;
                String t1 = Signature.getSimpleName((String)Signature.toString((String)paramTypes[i]));
                if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)currParamTypes[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isSamePackage(IPackageFragment pack1, IPackageFragment pack2) {
        return pack1.getElementName().equals(pack2.getElementName());
    }

    public static boolean isBoolean(IField field) throws JavaScriptModelException {
        return field.getTypeSignature().equals("LBoolean;");
    }

    public static String getResolvedTypeName(String refTypeSig, IType declaringType) throws JavaScriptModelException {
        int arrayCount = Signature.getArrayCount((String)refTypeSig);
        char type = refTypeSig.charAt(arrayCount);
        if (type == 'Q') {
            String name = "";
            int semi = refTypeSig.indexOf(59, arrayCount + 1);
            if (semi == -1) {
                throw new IllegalArgumentException();
            }
            name = refTypeSig.substring(arrayCount + 1, semi);
            String[][] resolvedNames = declaringType.resolveType(name);
            if (resolvedNames != null && resolvedNames.length > 0) {
                return JavaModelUtil.concatenateName(resolvedNames[0][0], resolvedNames[0][1]);
            }
            return null;
        }
        return Signature.toString((String)refTypeSig.substring(arrayCount));
    }

    public static boolean isEditable(IJavaScriptUnit cu) {
        Assert.isNotNull((Object)cu);
        IResource resource = cu.getPrimary().getResource();
        return resource.exists() && !resource.getResourceAttributes().isReadOnly();
    }

    public static boolean isPrimary(IJavaScriptUnit cu) {
        return cu.getOwner() == null;
    }

    public static boolean isExceptionToBeLogged(CoreException exception) {
        if (!(exception instanceof JavaScriptModelException)) {
            return true;
        }
        JavaScriptModelException je = (JavaScriptModelException)((Object)exception);
        if (!je.isDoesNotExist()) {
            return true;
        }
        IJavaScriptElement[] elements = je.getJavaScriptModelStatus().getElements();
        int i = 0;
        while (i < elements.length) {
            IJavaScriptElement element = elements[i];
            if (element.getElementType() != 5) {
                IJavaScriptUnit unit = (IJavaScriptUnit)element.getAncestor(5);
                if (unit == null) {
                    return true;
                }
                if (!unit.isWorkingCopy()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static IType[] getAllSuperTypes(IType type, IProgressMonitor pm) throws JavaScriptModelException {
        IType[] superTypes = SuperTypeHierarchyCache.getTypeHierarchy(type).getAllSuperclasses(type);
        return superTypes;
    }

    public static boolean isSuperType(ITypeHierarchy hierarchy, IType possibleSuperType, IType type) {
        IType superClass = hierarchy.getSuperclass(type);
        return superClass != null && (possibleSuperType.equals(superClass) || JavaModelUtil.isSuperType(hierarchy, possibleSuperType, superClass));
    }

    public static boolean isExcludedPath(IPath resourcePath, IPath[] exclusionPatterns) {
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            char[] pattern = exclusionPatterns[i].toString().toCharArray();
            if (CharOperation.pathMatch((char[])pattern, (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] exclusionPatterns) {
        if (exclusionPatterns == null) {
            return false;
        }
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            if (CharOperation.pathMatch((char[])exclusionPatterns[i], (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void reconcile(IJavaScriptUnit unit) throws JavaScriptModelException {
        unit.reconcile(0, false, null, null);
    }

    public static IIncludePathEntry getClasspathEntryToEdit(IJavaScriptProject jproject, IPath containerPath, IPath libPath) throws JavaScriptModelException {
        IJsGlobalScopeContainer container = JavaScriptCore.getJsGlobalScopeContainer((IPath)containerPath, (IJavaScriptProject)jproject);
        JsGlobalScopeContainerInitializer initializer = JavaScriptCore.getJsGlobalScopeContainerInitializer((String)containerPath.segment(0));
        if (container != null && initializer != null && initializer.canUpdateJsGlobalScopeContainer(containerPath, jproject)) {
            return JavaModelUtil.findEntryInContainer(container, libPath);
        }
        return null;
    }

    public static IIncludePathEntry findEntryInContainer(IJsGlobalScopeContainer container, IPath libPath) {
        IIncludePathEntry[] entries = container.getIncludepathEntries();
        int i = 0;
        while (i < entries.length) {
            IIncludePathEntry curr = entries[i];
            IIncludePathEntry resolved = JavaScriptCore.getResolvedIncludepathEntry((IIncludePathEntry)curr);
            if (resolved != null && libPath.equals((Object)resolved.getPath())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public static IJavaScriptUnit[] getAllCompilationUnits(IJavaScriptElement[] javaElements) throws JavaScriptModelException {
        HashSet result = new HashSet();
        int i = 0;
        while (i < javaElements.length) {
            JavaModelUtil.addAllCus(result, javaElements[i]);
            ++i;
        }
        return result.toArray(new IJavaScriptUnit[result.size()]);
    }

    private static void addAllCus(HashSet collector, IJavaScriptElement javaElement) throws JavaScriptModelException {
        switch (javaElement.getElementType()) {
            case 2: {
                IJavaScriptProject javaProject = (IJavaScriptProject)javaElement;
                IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < packageFragmentRoots.length) {
                    JavaModelUtil.addAllCus(collector, (IJavaScriptElement)packageFragmentRoots[i]);
                    ++i;
                }
                return;
            }
            case 3: {
                IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)javaElement;
                if (packageFragmentRoot.getKind() != 1) {
                    return;
                }
                IJavaScriptElement[] packageFragments = packageFragmentRoot.getChildren();
                int j = 0;
                while (j < packageFragments.length) {
                    JavaModelUtil.addAllCus(collector, packageFragments[j]);
                    ++j;
                }
                return;
            }
            case 4: {
                IPackageFragment packageFragment = (IPackageFragment)javaElement;
                collector.addAll(Arrays.asList(packageFragment.getJavaScriptUnits()));
                return;
            }
            case 5: {
                collector.add(javaElement);
                return;
            }
        }
        IJavaScriptElement cu = javaElement.getAncestor(5);
        if (cu != null) {
            collector.add(cu);
        }
    }

    public static void set50CompilanceOptions(Map map) {
        JavaModelUtil.setCompilanceOptions(map, "1.5");
    }

    public static void setCompilanceOptions(Map map, String compliance) {
        if ("1.6".equals(compliance)) {
            map.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.6");
            map.put("org.eclipse.wst.jsdt.core.compiler.source", "1.6");
            map.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.6");
            map.put("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier", "error");
        } else if ("1.5".equals(compliance)) {
            map.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            map.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            map.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            map.put("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier", "error");
        } else if ("1.4".equals(compliance)) {
            map.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.4");
            map.put("org.eclipse.wst.jsdt.core.compiler.source", "1.3");
            map.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.2");
            map.put("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier", "warning");
        } else if ("1.3".equals(compliance)) {
            map.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.3");
            map.put("org.eclipse.wst.jsdt.core.compiler.source", "1.3");
            map.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.1");
            map.put("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier", "ignore");
        } else {
            throw new IllegalArgumentException("Unsupported compliance: " + compliance);
        }
    }

    public static void setDefaultClassfileOptions(Map map, String compliance) {
        map.put("org.eclipse.wst.jsdt.core.compiler.codegen.inlineJsrBytecode", JavaModelUtil.is50OrHigher(compliance) ? "enabled" : "disabled");
        map.put("org.eclipse.wst.jsdt.core.compiler.debug.localVariable", "generate");
        map.put("org.eclipse.wst.jsdt.core.compiler.debug.lineNumber", "generate");
        map.put("org.eclipse.wst.jsdt.core.compiler.debug.sourceFile", "generate");
        map.put("org.eclipse.wst.jsdt.core.compiler.codegen.unusedLocal", "preserve");
    }

    public static boolean isVersionLessThan(String version1, String version2) {
        return version1.compareTo(version2) < 0;
    }

    public static boolean is50OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "1.5");
    }

    public static boolean is50OrHigher(IJavaScriptProject project) {
        return JavaModelUtil.is50OrHigher(project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true));
    }

    public static boolean is50OrHigherJRE(IJavaScriptProject project) throws CoreException {
        IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaScriptProject)project);
        if (!(vmInstall instanceof IVMInstall2)) {
            return true;
        }
        String compliance = JavaModelUtil.getCompilerCompliance((IVMInstall2)vmInstall, null);
        if (compliance == null) {
            return true;
        }
        return compliance.startsWith("1.5") || compliance.startsWith("1.6");
    }

    public static String getCompilerCompliance(IVMInstall2 vMInstall, String defaultCompliance) {
        String version = vMInstall.getJavaVersion();
        if (version == null) {
            return defaultCompliance;
        }
        if (version.startsWith("1.6")) {
            return "1.6";
        }
        if (version.startsWith("1.5")) {
            return "1.5";
        }
        if (version.startsWith("1.4")) {
            return "1.4";
        }
        if (version.startsWith("1.3")) {
            return "1.3";
        }
        if (version.startsWith("1.2")) {
            return "1.3";
        }
        if (version.startsWith("1.1")) {
            return "1.3";
        }
        return defaultCompliance;
    }

    public static String getRenamedCUName(IJavaScriptUnit cu, String newMainName) {
        String oldName = cu.getElementName();
        int i = oldName.lastIndexOf(46);
        if (i != -1) {
            return String.valueOf(newMainName) + oldName.substring(i);
        }
        return newMainName;
    }

    public static void applyEdit(IJavaScriptUnit cu, TextEdit edit, boolean save, IProgressMonitor monitor) throws CoreException, ValidateEditException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(CorextMessages.JavaModelUtil_applyedit_operation, 3);
        try {
            IDocument document = null;
            try {
                try {
                    document = JavaModelUtil.aquireDocument(cu, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (save) {
                        JavaModelUtil.commitDocument(cu, document, edit, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        new RewriteSessionEditProcessor(document, edit, 2).performEdits();
                    }
                }
                catch (BadLocationException e) {
                    throw new CoreException(JavaUIStatus.createError(4, e));
                }
            }
            finally {
                JavaModelUtil.releaseDocument(cu, document, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private static IDocument aquireDocument(IJavaScriptUnit cu, IProgressMonitor monitor) throws CoreException {
        IFile file;
        if (JavaModelUtil.isPrimary(cu) && (file = (IFile)cu.getResource()).exists()) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            IPath path = cu.getPath();
            bufferManager.connect(path, LocationKind.IFILE, monitor);
            return bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
        }
        monitor.done();
        return new Document(cu.getSource());
    }

    private static void commitDocument(IJavaScriptUnit cu, IDocument document, TextEdit edit, IProgressMonitor monitor) throws CoreException, MalformedTreeException, BadLocationException {
        IFile file;
        if (JavaModelUtil.isPrimary(cu) && (file = (IFile)cu.getResource()).exists()) {
            IStatus status = Resources.makeCommittable((IResource)file, null);
            if (!status.isOK()) {
                throw new ValidateEditException(status);
            }
            new RewriteSessionEditProcessor(document, edit, 2).performEdits();
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            bufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE).commit(monitor, true);
            return;
        }
        new RewriteSessionEditProcessor(document, edit, 2).performEdits();
    }

    private static void releaseDocument(IJavaScriptUnit cu, IDocument document, IProgressMonitor monitor) throws CoreException {
        IFile file;
        if (JavaModelUtil.isPrimary(cu) && (file = (IFile)cu.getResource()).exists()) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            bufferManager.disconnect(file.getFullPath(), LocationKind.IFILE, monitor);
            return;
        }
        cu.getBuffer().setContents(document.get());
        monitor.done();
    }

    public static boolean isImplicitImport(String qualifier, IJavaScriptUnit cu) {
        if ("java.lang".equals(qualifier)) {
            return true;
        }
        String packageName = cu.getParent().getElementName();
        if (qualifier.equals(packageName)) {
            return true;
        }
        String typeName = JavaScriptCore.removeJavaScriptLikeExtension((String)cu.getElementName());
        String mainTypeName = JavaModelUtil.concatenateName(packageName, typeName);
        return qualifier.equals(mainTypeName);
    }

    public static boolean isOpenableStorage(Object storage) {
        if (storage instanceof IJarEntryResource) {
            return ((IJarEntryResource)storage).isFile();
        }
        return storage instanceof IStorage;
    }

    public static boolean isParameter(ILocalVariable currentLocal) throws JavaScriptModelException {
        IJavaScriptElement parent = currentLocal.getParent();
        if (parent instanceof IFunction) {
            String[] params = ((IFunction)parent).getParameterNames();
            int i = 0;
            while (i < params.length) {
                if (params[i].equals(currentLocal.getElementName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String getFilePackage(IJavaScriptElement javaElement) {
        IJavaScriptElement rootElement;
        IPath rootPath;
        IPath filePath;
        String relativePath;
        int index;
        IJavaScriptElement fileAncestor = javaElement.getAncestor(5);
        if (fileAncestor == null) {
            fileAncestor = javaElement.getAncestor(6);
        }
        if ((index = Util.indexOfJavaLikeExtension((String)(relativePath = (filePath = fileAncestor.getResource().getFullPath()).removeFirstSegments((rootPath = (rootElement = fileAncestor.getAncestor(3)).getResource().getFullPath()).segmentCount()).toPortableString()))) >= 0) {
            relativePath = relativePath.substring(0, index);
        }
        relativePath = relativePath.replace('/', '.');
        return relativePath;
    }
}

