/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.single;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.memories.TimestampReplacement;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.TimelyMemory;
import org.eclipse.viatra.query.runtime.rete.index.ProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.index.SpecializedProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.index.timely.TimelyMemoryIdentityIndexer;
import org.eclipse.viatra.query.runtime.rete.index.timely.TimelyMemoryNullIndexer;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timely.TimelyMailbox;
import org.eclipse.viatra.query.runtime.rete.single.AbstractUniquenessEnforcerNode;

public class TimelyUniquenessEnforcerNode
extends AbstractUniquenessEnforcerNode {
    protected final TimelyMemory<Timestamp> memory = new TimelyMemory();

    public TimelyUniquenessEnforcerNode(ReteContainer reteContainer, int tupleWidth) {
        super(reteContainer, tupleWidth);
        reteContainer.registerClearable((Clearable)this.memory);
        this.mailbox = this.instantiateMailbox();
        reteContainer.registerClearable(this.mailbox);
    }

    @Override
    protected Mailbox instantiateMailbox() {
        return new TimelyMailbox(this, this.reteContainer);
    }

    @Override
    public Collection<Tuple> getMemory() {
        return this.memory.keySet();
    }

    @Override
    public void update(Direction direction, Tuple update, Timestamp timestamp) {
        if (direction == Direction.INSERT) {
            TimestampReplacement pair = this.memory.put(update, (Comparable)timestamp);
            Timestamp oldLeast = (Timestamp)pair.oldValue;
            Timestamp newLeast = (Timestamp)pair.newValue;
            if (oldLeast != null) {
                int comparisonResult = newLeast.compareTo(oldLeast);
                if (comparisonResult > 0) {
                    this.issueError("[INTERNAL ERROR] Illegal least timestamp detected for " + update + " in " + this.getClass().getName() + " " + this + " for pattern(s) " + this.getTraceInfoPatternsEnumerated(), null);
                } else if (comparisonResult != 0) {
                    this.propagate(Direction.REVOKE, update, oldLeast);
                    this.propagate(Direction.INSERT, update, newLeast);
                }
            } else {
                this.propagate(Direction.INSERT, update, newLeast);
            }
        } else {
            TimestampReplacement pair = null;
            try {
                pair = this.memory.remove(update, (Comparable)timestamp);
            }
            catch (IllegalStateException e) {
                this.issueError("[INTERNAL ERROR] Duplicate deletion of " + update + " was detected in " + this.getClass().getName() + " " + this + " for pattern(s) " + this.getTraceInfoPatternsEnumerated(), e);
                return;
            }
            Timestamp oldLeast = (Timestamp)pair.oldValue;
            Timestamp newLeast = (Timestamp)pair.newValue;
            if (newLeast != null) {
                int comparisonResult = newLeast.compareTo(oldLeast);
                if (comparisonResult < 0) {
                    this.issueError("[INTERNAL ERROR] Illegal least timestamp detected for " + update + " in " + this.getClass().getName() + " " + this + " for pattern(s) " + this.getTraceInfoPatternsEnumerated(), null);
                } else if (comparisonResult != 0) {
                    this.propagate(Direction.REVOKE, update, oldLeast);
                    this.propagate(Direction.INSERT, update, newLeast);
                }
            } else {
                this.propagate(Direction.REVOKE, update, oldLeast);
            }
        }
    }

    @Override
    public void pullIntoWithTimestamp(Map<Tuple, Timestamp> collector, boolean flush) {
        collector.putAll(this.memory.asMap());
    }

    @Override
    public ProjectionIndexer getNullIndexer() {
        if (this.memoryNullIndexer == null) {
            this.memoryNullIndexer = new TimelyMemoryNullIndexer(this.reteContainer, this.tupleWidth, this.memory, (Supplier)this, (Receiver)this, (List<SpecializedProjectionIndexer.ListenerSubscription>)this.specializedListeners);
            this.getCommunicationTracker().registerDependency(this, this.memoryNullIndexer);
        }
        return this.memoryNullIndexer;
    }

    @Override
    public ProjectionIndexer getIdentityIndexer() {
        if (this.memoryIdentityIndexer == null) {
            this.memoryIdentityIndexer = new TimelyMemoryIdentityIndexer(this.reteContainer, this.tupleWidth, this.memory, (Supplier)this, (Receiver)this, (List<SpecializedProjectionIndexer.ListenerSubscription>)this.specializedListeners);
            this.getCommunicationTracker().registerDependency(this, this.memoryIdentityIndexer);
        }
        return this.memoryIdentityIndexer;
    }
}

