/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableFolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.tags.BranchPromptDialog;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class BranchOperation
extends RepositoryProviderOperation {
    private boolean update;
    private CVSTag rootVersionTag;
    private CVSTag branchTag;

    public BranchOperation(IWorkbenchPart part, ResourceMapping[] mappers) {
        super(part, mappers);
    }

    public void setTags(CVSTag rootVersionTag, CVSTag branchTag, boolean updateToBranch) {
        this.rootVersionTag = rootVersionTag;
        this.branchTag = branchTag;
        this.update = updateToBranch;
    }

    protected boolean shouldRun() {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, monitor -> {
                try {
                    this.buildScope(monitor);
                }
                catch (CVSException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e1) {
            CVSUIPlugin.openError(this.getShell(), null, null, e1);
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        IResource[] resources = this.getTraversalRoots();
        boolean allSticky = this.areAllResourcesSticky(resources);
        String initialVersionName = this.calculateInitialVersionName(resources, allSticky);
        BranchPromptDialog dialog = new BranchPromptDialog(this.getShell(), CVSUIMessages.BranchWizard_title, resources, allSticky, initialVersionName);
        if (dialog.open() != 0) {
            return false;
        }
        String tagString = dialog.getBranchTagName();
        this.update = dialog.getUpdate();
        this.branchTag = new CVSTag(tagString, 1);
        String versionString = dialog.getVersionTagName();
        if (!(versionString == null || initialVersionName != null && versionString.equals(initialVersionName))) {
            this.rootVersionTag = new CVSTag(versionString, 2);
        }
        if (this.update) {
            try {
                if (!CVSAction.checkForMixingTags(this.getShell(), resources, this.branchTag)) {
                    return false;
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        return super.shouldRun();
    }

    @Override
    protected void execute(CVSTeamProvider provider, IResource[] providerResources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        try {
            try {
                monitor.beginTask(null, 100);
                this.makeBranch(provider, providerResources, this.rootVersionTag, this.branchTag, this.update, recurse, Policy.subMonitorFor(monitor, 90));
                this.updateRememberedTags(providerResources);
                if (this.update) {
                    this.updateWorkspaceSubscriber(provider, this.getCVSArguments(providerResources), recurse, Policy.subMonitorFor(monitor, 10));
                }
                this.collectStatus(Status.OK_STATUS);
            }
            catch (TeamException e) {
                this.collectStatus(e.getStatus());
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void makeBranch(CVSTeamProvider provider, IResource[] resources, CVSTag versionTag, CVSTag branchTag, boolean moveToBranch, boolean recurse, IProgressMonitor monitor) throws TeamException {
        int totalWork = (versionTag != null ? 60 : 40) + (moveToBranch ? 20 : 0);
        monitor.beginTask(CVSUIMessages.CVSTeamProvider_makeBranch, totalWork);
        try {
            ICVSResource[] arguments = this.getCVSArguments(resources);
            Command.LocalOption[] localOptions = this.getLocalOptions(recurse);
            IStatus status = null;
            if (versionTag != null) {
                session.open(Policy.subMonitorFor(monitor, 5), true);
                try (Session session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);){
                    status = Command.CUSTOM_TAG.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions, versionTag, arguments, null, Policy.subMonitorFor(monitor, 35));
                }
                if (status.isOK()) {
                    session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);
                    session.open(Policy.subMonitorFor(monitor, 5), true);
                    try {
                        status = Command.CUSTOM_TAG.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions, branchTag, arguments, null, Policy.subMonitorFor(monitor, 15));
                    }
                    finally {
                        session.close();
                    }
                }
            } else {
                session.open(Policy.subMonitorFor(monitor, 5), true);
                try (Session session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);){
                    status = Command.CUSTOM_TAG.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions, branchTag, arguments, null, Policy.subMonitorFor(monitor, 35));
                }
            }
            if (!status.isOK()) {
                throw new CVSServerException(status);
            }
            if (moveToBranch) {
                this.setTag(provider, resources, branchTag, recurse, Policy.subMonitorFor(monitor, 20));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void setTag(CVSTeamProvider provider, IResource[] resources, final CVSTag tag, boolean recurse, IProgressMonitor monitor) throws TeamException {
        this.getLocalRoot(provider).run(progress -> {
            try {
                progress.beginTask(null, 100);
                final IProgressMonitor monitor1 = Policy.infiniteSubMonitorFor(progress, 100);
                monitor1.beginTask(NLS.bind((String)CVSUIMessages.CVSTeamProvider_folderInfo, (Object[])new String[]{provider.getProject().getName()}), 512);
                IResource[] iResourceArray2 = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray2[n2];
                    CVSWorkspaceRoot.getCVSResourceFor((IResource)resource).accept(new ICVSResourceVisitor(){

                        public void visitFile(ICVSFile file) throws CVSException {
                            monitor1.worked(1);
                            byte[] syncBytes = file.getSyncBytes();
                            if (syncBytes != null) {
                                monitor1.subTask(NLS.bind((String)CVSUIMessages.CVSTeamProvider_updatingFile, (Object[])new String[]{file.getName()}));
                                file.setSyncBytes(ResourceSyncInfo.setTag((byte[])syncBytes, (CVSTag)tag), 0);
                            }
                        }

                        public void visitFolder(ICVSFolder folder) throws CVSException {
                            monitor1.worked(1);
                            FolderSyncInfo info = folder.getFolderSyncInfo();
                            if (info != null) {
                                monitor1.subTask(NLS.bind((String)CVSUIMessages.CVSTeamProvider_updatingFolder, (Object[])new String[]{info.getRepository()}));
                                MutableFolderSyncInfo newInfo = info.cloneMutable();
                                newInfo.setTag(tag);
                                folder.setFolderSyncInfo((FolderSyncInfo)newInfo);
                            }
                        }
                    }, recurse);
                    ++n2;
                }
            }
            finally {
                progress.done();
            }
        }, monitor);
    }

    private void updateRememberedTags(IResource[] providerResources) throws CVSException {
        if (this.rootVersionTag != null || this.update) {
            IResource[] iResourceArray = providerResources;
            int n = providerResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource providerResource = iResourceArray[n2];
                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)providerResource);
                RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
                if (this.rootVersionTag != null) {
                    manager.addTags(cvsResource, new CVSTag[]{this.rootVersionTag});
                }
                if (this.update) {
                    manager.addTags(cvsResource, new CVSTag[]{this.branchTag});
                }
                ++n2;
            }
        }
    }

    @Override
    protected String getTaskName() {
        return CVSUIMessages.BranchOperation_0;
    }

    @Override
    protected String getTaskName(CVSTeamProvider provider) {
        return NLS.bind((String)CVSUIMessages.BranchOperation_1, (Object[])new String[]{provider.getProject().getName()});
    }

    private boolean areAllResourcesSticky(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (!this.hasStickyTag(resource)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean hasStickyTag(IResource resource) {
        try {
            int tagType;
            CVSTag tag;
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
            if (cvsResource.isFolder()) {
                FolderSyncInfo folderInfo = ((ICVSFolder)cvsResource).getFolderSyncInfo();
                tag = folderInfo.getTag();
            } else {
                ResourceSyncInfo info = cvsResource.getSyncInfo();
                tag = info.getTag();
            }
            return tag != null && (tagType = tag.getType()) == 2;
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return false;
        }
    }

    private String calculateInitialVersionName(IResource[] resources, boolean allSticky) {
        String versionName = "";
        try {
            if (allSticky) {
                IResource stickyResource = resources[0];
                if (stickyResource.getType() == 1) {
                    ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)stickyResource));
                    versionName = cvsFile.getSyncInfo().getTag().getName();
                } else {
                    ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)((IContainer)stickyResource));
                    versionName = cvsFolder.getFolderSyncInfo().getTag().getName();
                }
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            versionName = "";
        }
        return versionName;
    }

    @Override
    protected boolean isReportableError(IStatus status) {
        return super.isReportableError(status) || status.getCode() == -15;
    }
}

