/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.model;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.model.CVSModelElement;
import org.eclipse.team.internal.ccvs.ui.model.RepositoryLocationSchedulingRule;
import org.eclipse.team.internal.ccvs.ui.model.VersionCategory;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class RemoteModule
extends CVSModelElement
implements IAdaptable,
IDeferredWorkbenchAdapter {
    ICVSRemoteFolder folder;
    VersionCategory parent;

    public RemoteModule(ICVSRemoteFolder folder, VersionCategory parent) {
        this.folder = folder;
        this.parent = parent;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return adapter.cast(this);
        }
        if (adapter == IDeferredWorkbenchAdapter.class) {
            return adapter.cast(this);
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return CVSUIPlugin.getPlugin().getImageDescriptor("obj16/prjversions_rep.gif");
    }

    public String getLabel(Object o) {
        return this.folder.getName();
    }

    public Object getParent(Object o) {
        return this.parent;
    }

    public ICVSRepositoryLocation getRepository(Object o) {
        return this.folder.getRepository();
    }

    public String toString() {
        return "RemoteModule(" + this.folder.getName() + ")";
    }

    public ICVSRemoteResource getCVSResource() {
        return this.folder;
    }

    @Override
    public Object[] fetchChildren(Object o, IProgressMonitor monitor) throws TeamException {
        RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
        try {
            manager.refreshDefinedTags((ICVSFolder)this.folder, false, false, monitor);
        }
        catch (TeamException teamException) {}
        CVSTag[] tags = CVSUIPlugin.getPlugin().getRepositoryManager().getKnownTags((ICVSFolder)this.folder, 2);
        Object[] versions = new Object[tags.length];
        int i = 0;
        while (i < versions.length) {
            versions[i] = this.folder.forTag(tags[i]);
            ++i;
        }
        return versions;
    }

    public void fetchDeferredChildren(Object o, IElementCollector collector, IProgressMonitor monitor) {
        try {
            collector.add(this.fetchChildren(o, monitor), monitor);
        }
        catch (TeamException e) {
            this.handle(collector, e);
        }
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object element) {
        return new RepositoryLocationSchedulingRule(this.folder.getRepository());
    }
}

