/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.operation;

import java.util.List;
import java.util.Optional;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.ConnectionLayerEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.RectilinearRouter;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.description.CenteringStyle;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.EdgeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.graphical.figures.CanonicalRectilinearRouter;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEditPart;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.routers.RectilinearEdgeUtil;
import org.eclipse.sirius.diagram.ui.tools.internal.util.GMFNotationUtilities;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.ui.IEditorPart;

public class CenterEdgeEndModelChangeOperation
extends AbstractModelChangeOperation<Void> {
    private Edge edge;
    private PrecisionPoint existingSourceAnchorAbsoluteLocation;
    private PrecisionPoint existingTargetAnchorAbsoluteLocation;
    private PrecisionPoint newTargetAnchorAbsoluteLocation;
    private PrecisionPoint newSourceAnchorAbsoluteLocation;
    private ConnectionEditPart connectionEditPart;
    private Connection connection;
    private boolean useFigure = true;
    private Dimension sourceFigureSize;
    private Dimension targetFigureSize;
    private static final String CENTERED_ANCHOR = GMFNotationUtilities.getTerminalString(0.5, 0.5);

    public CenterEdgeEndModelChangeOperation(ConnectionEditPart connectionEditPart, Edge edge) {
        this(edge);
        this.connectionEditPart = connectionEditPart;
        this.connection = (Connection)connectionEditPart.getFigure();
    }

    public CenterEdgeEndModelChangeOperation(Edge edge) {
        this.edge = edge;
    }

    public CenterEdgeEndModelChangeOperation(Edge edge, boolean useFigure) {
        this(edge);
        this.useFigure = useFigure;
    }

    public void setSourceAndTargetSize(Dimension sourceFigureSize, Dimension targetFigureSize) {
        this.sourceFigureSize = sourceFigureSize;
        this.targetFigureSize = targetFigureSize;
    }

    @Override
    public Void execute() {
        Routing routingValue = this.getRoutingValue();
        if (!Routing.TREE_LITERAL.equals(routingValue)) {
            if (this.isEdgeSourceCentered() && this.isEdgeTargetCentered()) {
                this.centerEdgeEnds(CenteringStyle.BOTH, routingValue);
            } else if (this.isEdgeSourceCentered()) {
                this.centerEdgeEnds(CenteringStyle.SOURCE, routingValue);
            } else if (this.isEdgeTargetCentered()) {
                this.centerEdgeEnds(CenteringStyle.TARGET, routingValue);
            }
        }
        return null;
    }

    private Routing getRoutingValue() {
        Routing routingValue = Routing.MANUAL_LITERAL;
        EdgeQuery edgeQuery = new EdgeQuery(this.edge);
        if (edgeQuery.isEdgeWithTreeRoutingStyle()) {
            routingValue = Routing.TREE_LITERAL;
        } else if (edgeQuery.isEdgeWithRectilinearRoutingStyle()) {
            routingValue = Routing.RECTILINEAR_LITERAL;
        }
        return routingValue;
    }

    private void centerEdgeEnds(CenteringStyle center, Routing routingValue) {
        Bendpoints bendpoints = this.edge.getBendpoints();
        if (bendpoints instanceof RelativeBendpoints) {
            View edgeSourceView = this.edge.getSource();
            View edgeTargetView = this.edge.getTarget();
            if (edgeSourceView instanceof Node && edgeTargetView instanceof Node) {
                this.setConnectionIfNull();
                Option<Rectangle> sourceBounds = this.getAbsoluteSourceBounds(edgeSourceView);
                Option<Rectangle> targetBounds = this.getAbsoluteTargetBounds(edgeTargetView);
                if (sourceBounds.some() && targetBounds.some()) {
                    this.retrieveAndSetExistingAnchorsAbsoluteLocation((Rectangle)sourceBounds.get(), (Rectangle)targetBounds.get());
                    this.computeAndSetNewAnchorsAbsoluteCoordinates((Rectangle)sourceBounds.get(), (Rectangle)targetBounds.get(), center);
                    PointList newPointList = new PointList();
                    newPointList = new ConnectionQuery(this.connection).getAbsolutePointList((RelativeBendpoints)bendpoints, this.existingSourceAnchorAbsoluteLocation, this.existingTargetAnchorAbsoluteLocation);
                    if (!Routing.RECTILINEAR_LITERAL.getLiteral().equals(routingValue.getLiteral())) {
                        this.handleStraightCase(center, (Rectangle)sourceBounds.get(), (Rectangle)targetBounds.get(), newPointList);
                    } else {
                        this.handleRectilinearCase(center, (Rectangle)sourceBounds.get(), (Rectangle)targetBounds.get(), newPointList);
                    }
                    GMFNotationUtilities.setGMFBendpoints(this.edge, newPointList, (Point)this.newSourceAnchorAbsoluteLocation, (Point)this.newTargetAnchorAbsoluteLocation);
                }
            }
        }
    }

    private Option<Rectangle> getAbsoluteBounds(View gmfView, boolean isSource) {
        if (this.connectionEditPart != null) {
            EditPart editPart = null;
            editPart = isSource ? this.connectionEditPart.getSource() : this.connectionEditPart.getTarget();
            if (editPart instanceof GraphicalEditPart) {
                return Options.newSome((Object)GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)((GraphicalEditPart)editPart)));
            }
        }
        return GMFHelper.getAbsoluteBounds(gmfView, true);
    }

    private Option<Rectangle> getAbsoluteSourceBounds(View edgeSourceView) {
        Option<Rectangle> option = this.getAbsoluteBounds(edgeSourceView, true);
        if (this.sourceFigureSize != null && option.some()) {
            Rectangle rectangle = (Rectangle)option.get();
            rectangle.setSize(this.sourceFigureSize);
        }
        return option;
    }

    private Option<Rectangle> getAbsoluteTargetBounds(View edgeTargetView) {
        Option<Rectangle> option = this.getAbsoluteBounds(edgeTargetView, false);
        if (this.targetFigureSize != null && option.some()) {
            Rectangle rectangle = (Rectangle)option.get();
            rectangle.setSize(this.targetFigureSize);
        }
        return option;
    }

    private void handleStraightCase(CenteringStyle center, Rectangle sourceBounds, Rectangle targetBounds, PointList existingPointList) {
        PrecisionPoint sourceLineOrigin = this.newTargetAnchorAbsoluteLocation;
        PrecisionPoint targetLineOrigin = this.newSourceAnchorAbsoluteLocation;
        PrecisionPoint sourceLineTerminus = this.newSourceAnchorAbsoluteLocation;
        PrecisionPoint targetLineTerminus = this.newTargetAnchorAbsoluteLocation;
        if (existingPointList.size() > 2) {
            sourceLineOrigin = existingPointList.getPoint(1);
            targetLineOrigin = existingPointList.getPoint(existingPointList.size() - 2);
        } else if (existingPointList.size() < 2) {
            existingPointList = new PointList(new int[4]);
        }
        Optional sourceConnectionPoint = Optional.empty();
        Optional targetConnectionPoint = Optional.empty();
        if (center == CenteringStyle.BOTH || center == CenteringStyle.SOURCE) {
            sourceConnectionPoint = GraphicalHelper.getIntersection((Point)sourceLineOrigin, (Point)sourceLineTerminus, (Rectangle)sourceBounds, (boolean)false);
        }
        if (center == CenteringStyle.BOTH || center == CenteringStyle.TARGET) {
            targetConnectionPoint = GraphicalHelper.getIntersection((Point)targetLineOrigin, (Point)targetLineTerminus, (Rectangle)targetBounds, (boolean)false);
        }
        if (sourceConnectionPoint.isPresent() || targetConnectionPoint.isPresent()) {
            if (sourceConnectionPoint.isPresent()) {
                existingPointList.setPoint((Point)sourceConnectionPoint.get(), 0);
                this.centerSourceAnchor();
            }
            if (targetConnectionPoint.isPresent()) {
                existingPointList.setPoint((Point)targetConnectionPoint.get(), existingPointList.size() - 1);
                this.centerTargetAnchor();
            }
        }
    }

    private void handleRectilinearCase(CenteringStyle center, Rectangle sourceBounds, Rectangle targetBounds, PointList existingPointList) {
        PointList rectilinear = null;
        if (this.connection != null) {
            rectilinear = this.getRectilinearPointListFromConnection();
        } else {
            rectilinear = existingPointList.getCopy();
            if (rectilinear.size() <= 2) {
                this.computePointListByIntersections(rectilinear, sourceBounds, targetBounds);
            }
            if (rectilinear.size() >= 2) {
                CanonicalRectilinearRouter rectilinearRouter = new CanonicalRectilinearRouter();
                rectilinearRouter.routeLine(this.edge, 0, rectilinear, sourceBounds, targetBounds);
            }
        }
        if (rectilinear.size() >= 2) {
            RectilinearEdgeUtil.centerEdgeEnds(rectilinear, (Point)this.newSourceAnchorAbsoluteLocation, (Point)this.newTargetAnchorAbsoluteLocation, center);
            if (center == CenteringStyle.BOTH || center == CenteringStyle.SOURCE) {
                this.centerSourceAnchor();
            }
            if (center == CenteringStyle.BOTH || center == CenteringStyle.TARGET) {
                this.centerTargetAnchor();
            }
            existingPointList.removeAllPoints();
            existingPointList.addAll(rectilinear);
        }
    }

    private void computePointListByIntersections(PointList rectilinear, Rectangle sourceBounds, Rectangle targetBounds) {
        Optional sourceConnectionPoint = GraphicalHelper.getIntersection((Point)this.existingSourceAnchorAbsoluteLocation, (Point)this.existingTargetAnchorAbsoluteLocation, (Rectangle)sourceBounds, (boolean)false);
        Optional targetConnectionPoint = GraphicalHelper.getIntersection((Point)this.existingSourceAnchorAbsoluteLocation, (Point)this.existingTargetAnchorAbsoluteLocation, (Rectangle)targetBounds, (boolean)false);
        if (sourceConnectionPoint.isPresent() && targetConnectionPoint.isPresent()) {
            rectilinear.removeAllPoints();
            rectilinear.addPoint((Point)sourceConnectionPoint.get());
            rectilinear.addPoint((Point)targetConnectionPoint.get());
        }
    }

    private void computeAndSetNewAnchorsAbsoluteCoordinates(Rectangle sourceBounds, Rectangle targetBounds, CenteringStyle center) {
        this.newSourceAnchorAbsoluteLocation = this.existingSourceAnchorAbsoluteLocation;
        this.newTargetAnchorAbsoluteLocation = this.existingTargetAnchorAbsoluteLocation;
        if (center == CenteringStyle.BOTH || center == CenteringStyle.SOURCE) {
            PrecisionPoint newSourceAnchor = new PrecisionPoint(0.5, 0.5);
            this.newSourceAnchorAbsoluteLocation = this.getAbsoluteAnchorCoordinates(sourceBounds, newSourceAnchor);
        }
        if (center == CenteringStyle.BOTH || center == CenteringStyle.TARGET) {
            PrecisionPoint newTargetAnchor = new PrecisionPoint(0.5, 0.5);
            this.newTargetAnchorAbsoluteLocation = this.getAbsoluteAnchorCoordinates(targetBounds, newTargetAnchor);
        }
    }

    private void retrieveAndSetExistingAnchorsAbsoluteLocation(Rectangle sourceBounds, Rectangle targetBounds) {
        this.existingSourceAnchorAbsoluteLocation = this.getAbsoluteAnchorCoordinates(sourceBounds, this.getAnchorId(this.edge.getSourceAnchor()));
        this.existingTargetAnchorAbsoluteLocation = this.getAbsoluteAnchorCoordinates(targetBounds, this.getAnchorId(this.edge.getTargetAnchor()));
    }

    private PrecisionPoint getAnchorId(Anchor anchor) {
        PrecisionPoint anchorId = new PrecisionPoint(0.5, 0.5);
        if (anchor instanceof IdentityAnchor) {
            anchorId = BaseSlidableAnchor.parseTerminalString((String)((IdentityAnchor)anchor).getId());
        }
        return anchorId;
    }

    private void centerSourceAnchor() {
        Anchor currentAnchor = this.edge.getSourceAnchor();
        IdentityAnchor newAnchor = this.setOrCreateNewAnchorIfNeeded(currentAnchor);
        if (newAnchor != currentAnchor) {
            this.edge.setSourceAnchor((Anchor)newAnchor);
        }
    }

    private void centerTargetAnchor() {
        Anchor currentAnchor = this.edge.getTargetAnchor();
        IdentityAnchor newAnchor = this.setOrCreateNewAnchorIfNeeded(currentAnchor);
        if (newAnchor != currentAnchor) {
            this.edge.setTargetAnchor((Anchor)newAnchor);
        }
    }

    private IdentityAnchor setOrCreateNewAnchorIfNeeded(Anchor anchor) {
        if (anchor instanceof IdentityAnchor) {
            if (!((IdentityAnchor)anchor).getId().equals(CENTERED_ANCHOR)) {
                ((IdentityAnchor)anchor).setId(CENTERED_ANCHOR);
            }
            return (IdentityAnchor)anchor;
        }
        IdentityAnchor a = NotationFactory.eINSTANCE.createIdentityAnchor();
        a.setId(CENTERED_ANCHOR);
        return a;
    }

    private PrecisionPoint getAbsoluteAnchorCoordinates(Rectangle absoluteBounds, PrecisionPoint precisionPoint) {
        return new PrecisionPoint((double)absoluteBounds.x() + (double)absoluteBounds.width() * precisionPoint.preciseX(), (double)absoluteBounds.y() + (double)absoluteBounds.height() * precisionPoint.preciseY());
    }

    private boolean isEdgeSourceCentered() {
        return this.isCentered(true);
    }

    private boolean isEdgeTargetCentered() {
        return this.isCentered(false);
    }

    private boolean isCentered(boolean source) {
        boolean centered = false;
        EObject element = this.edge.getElement();
        if (element instanceof DEdge) {
            EdgeStyle edgeStyle = ((DEdge)element).getOwnedStyle();
            CenteringStyle centeringStyle = edgeStyle.getCentered();
            centered = source ? centeringStyle == CenteringStyle.BOTH || centeringStyle == CenteringStyle.SOURCE : centeringStyle == CenteringStyle.BOTH || centeringStyle == CenteringStyle.TARGET;
        }
        return centered;
    }

    private void setConnectionIfNull() {
        GraphicalEditPart editPart;
        if (this.connection != null || !this.useFigure) {
            return;
        }
        Option<GraphicalEditPart> option = Options.newNone();
        IEditorPart editorPart = EclipseUIUtil.getActiveEditor();
        if (editorPart instanceof DiagramEditor) {
            option = GMFHelper.getGraphicalEditPart((View)this.edge, (DiagramEditor)editorPart);
        } else {
            List diagramEditors = EditorService.getInstance().getRegisteredEditorParts();
            for (Object object : diagramEditors) {
                if (object instanceof DiagramEditor) {
                    option = GMFHelper.getGraphicalEditPart((View)this.edge, (DiagramEditor)object);
                }
                if (option.some()) break;
            }
        }
        if (option.some() && (editPart = (GraphicalEditPart)option.get()) instanceof DEdgeEditPart) {
            this.connectionEditPart = (DEdgeEditPart)editPart;
            this.connection = ((DEdgeEditPart)editPart).getConnectionFigure();
        }
    }

    private PointList getRectilinearPointListFromConnection() {
        ConnectionRouter oldConnectionRouter = this.connection.getConnectionRouter();
        boolean needToRetrieveOldRouter = false;
        if (!(oldConnectionRouter instanceof RectilinearRouter)) {
            ConnectionLayer cLayer;
            RectilinearRouter connectionRouter = null;
            LayerManager layerManager = LayerManager.Helper.find((EditPart)this.connectionEditPart);
            if (layerManager != null && (cLayer = (ConnectionLayer)layerManager.getLayer((Object)"Connection Layer")) instanceof ConnectionLayerEx) {
                connectionRouter = ((ConnectionLayerEx)cLayer).getRectilinearRouter();
            }
            if (connectionRouter == null) {
                connectionRouter = new RectilinearRouter();
            }
            this.connection.setConnectionRouter((ConnectionRouter)connectionRouter);
            needToRetrieveOldRouter = true;
        }
        this.connection.getConnectionRouter().route(this.connection);
        PointList pointList = this.connection.getPoints().getCopy();
        if (needToRetrieveOldRouter) {
            this.connection.setConnectionRouter(oldConnectionRouter);
            this.connection.getConnectionRouter().route(this.connection);
        }
        return pointList;
    }
}

