/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.table;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.handler.TableItemHandler;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.api.Control;
import org.eclipse.reddeer.swt.api.Table;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.widgets.AbstractItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableItem;
import org.hamcrest.Matcher;

public abstract class AbstractTableItem
extends AbstractItem<TableItem>
implements org.eclipse.reddeer.swt.api.TableItem {
    private static final Logger log = Logger.getLogger(AbstractTableItem.class);

    protected AbstractTableItem(ReferencedComposite refComposite, int index, Matcher<?> ... matchers) {
        super(TableItem.class, refComposite, index, matchers);
    }

    protected AbstractTableItem(TableItem swtTableItem) {
        super(swtTableItem);
    }

    @Override
    public void setChecked(boolean check) {
        log.info(String.valueOf(check ? "Check" : "Uncheck") + " table Item " + this.getText() + ":");
        TableItemHandler.getInstance().setChecked((TableItem)this.swtWidget, check);
    }

    @Override
    public boolean isChecked() {
        return TableItemHandler.getInstance().isChecked((TableItem)this.swtWidget);
    }

    @Override
    public String getText(int cellIndex) {
        return TableItemHandler.getInstance().getText((TableItem)this.swtWidget, cellIndex);
    }

    @Override
    public boolean isSelected() {
        return TableItemHandler.getInstance().isSelected((TableItem)this.swtWidget);
    }

    @Override
    public void select() {
        TableItemHandler.getInstance().select((TableItem)this.swtWidget);
    }

    @Override
    public boolean isGrayed() {
        return TableItemHandler.getInstance().isGrayed((TableItem)this.swtWidget);
    }

    @Override
    public Image getImage(int imageIndex) {
        return TableItemHandler.getInstance().getImage((TableItem)this.swtWidget, imageIndex);
    }

    @Override
    public Table getParent() {
        return new DefaultTable(TableItemHandler.getInstance().getParent((TableItem)this.swtWidget));
    }

    @Override
    public void doubleClick() {
        log.info("Double click table item " + this.getText());
        TableItemHandler.getInstance().doubleClick((TableItem)this.swtWidget, 0);
    }

    @Override
    public void click() {
        this.click(0);
    }

    @Override
    public void click(int column) {
        log.info("Double click table item " + this.getText());
        TableItemHandler.getInstance().click((TableItem)this.swtWidget, column);
    }

    @Override
    public void doubleClick(int column) {
        log.info("Double click column " + column + " of table item " + this.getText());
        TableItemHandler.getInstance().doubleClick((TableItem)this.swtWidget, column);
    }

    @Override
    public Control<?> getParentControl() {
        return this.getParent();
    }
}

