/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;

public class TableSelectionWrapper {
    private final Collection<PositionCoordinate> selectedCells;
    private final Map<Integer, Object> fullySelectedRowsObject;
    private final Map<Integer, Object> fullySelectionColumnsObject;
    private final INattableModelManager manager;

    public TableSelectionWrapper(Collection<PositionCoordinate> selectionCells) {
        this(selectionCells, Collections.emptyMap(), Collections.emptyMap());
    }

    public TableSelectionWrapper(Collection<PositionCoordinate> selectionCells, Map<Integer, Object> fullySelectedRowObject, Map<Integer, Object> fullySelectedColumnObject) {
        this.selectedCells = selectionCells;
        this.fullySelectedRowsObject = fullySelectedRowObject;
        this.fullySelectionColumnsObject = fullySelectedColumnObject;
        this.manager = null;
    }

    public TableSelectionWrapper(INattableModelManager manager, Collection<PositionCoordinate> selectionCells) {
        this(manager, selectionCells, Collections.emptyMap(), Collections.emptyMap());
    }

    public TableSelectionWrapper(INattableModelManager manager, Collection<PositionCoordinate> selectionCells, Map<Integer, Object> fullySelectedRowObject, Map<Integer, Object> fullySelectedColumnObject) {
        this.selectedCells = selectionCells;
        this.fullySelectedRowsObject = fullySelectedRowObject;
        this.fullySelectionColumnsObject = fullySelectedColumnObject;
        this.manager = manager;
    }

    public Collection<PositionCoordinate> getSelectedCells() {
        return this.selectedCells;
    }

    public Map<Integer, Object> getFullySelectedRows() {
        return this.fullySelectedRowsObject;
    }

    public Map<Integer, Object> getFullySelectedColumns() {
        return this.fullySelectionColumnsObject;
    }

    public boolean isCellsOutsideOfAxis() {
        boolean result = false;
        if (this.selectedCells != null && !this.selectedCells.isEmpty() && (this.fullySelectedRowsObject != null && !this.fullySelectedRowsObject.isEmpty() || this.fullySelectionColumnsObject != null && !this.fullySelectionColumnsObject.isEmpty())) {
            Iterator<PositionCoordinate> selectedCells = this.selectedCells.iterator();
            while (!result && selectedCells.hasNext()) {
                PositionCoordinate selectedCell = selectedCells.next();
                boolean contains = false;
                if (this.fullySelectedRowsObject != null && !this.fullySelectedRowsObject.isEmpty() && this.fullySelectedRowsObject.containsKey(selectedCell.getRowPosition())) {
                    contains = true;
                }
                if (this.fullySelectionColumnsObject != null && !this.fullySelectionColumnsObject.isEmpty() && this.fullySelectionColumnsObject.containsKey(selectedCell.getColumnPosition())) {
                    contains = true;
                }
                boolean bl = result = !contains;
            }
        }
        return result;
    }

    public boolean isContinuousRows() {
        int firstRowIndex = -1;
        int lastRowIndex = -1;
        for (int rowIndex : this.getFullySelectedRows().keySet()) {
            if (-1 == firstRowIndex || rowIndex < firstRowIndex) {
                firstRowIndex = rowIndex;
            }
            if (-1 != lastRowIndex && rowIndex <= lastRowIndex) continue;
            lastRowIndex = rowIndex;
        }
        return lastRowIndex - firstRowIndex + 1 == this.getFullySelectedRows().size();
    }

    public boolean isContinuousColumns() {
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        for (int rowIndex : this.getFullySelectedColumns().keySet()) {
            if (-1 == firstColumnIndex || rowIndex < firstColumnIndex) {
                firstColumnIndex = rowIndex;
            }
            if (-1 != lastColumnIndex && rowIndex <= lastColumnIndex) continue;
            lastColumnIndex = rowIndex;
        }
        return lastColumnIndex - firstColumnIndex + 1 == this.getFullySelectedColumns().size();
    }

    public boolean isContinuousCells() {
        int firstRowIndex = -1;
        int lastRowIndex = -1;
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        for (PositionCoordinate currentPosition : this.getSelectedCells()) {
            if (-1 == firstRowIndex || currentPosition.getRowPosition() < firstRowIndex) {
                firstRowIndex = currentPosition.getRowPosition();
            }
            if (-1 == firstColumnIndex || currentPosition.getColumnPosition() < firstColumnIndex) {
                firstColumnIndex = currentPosition.getColumnPosition();
            }
            if (-1 == lastRowIndex || currentPosition.getRowPosition() > lastRowIndex) {
                lastRowIndex = currentPosition.getRowPosition();
            }
            if (-1 != lastColumnIndex && currentPosition.getColumnPosition() <= lastColumnIndex) continue;
            lastColumnIndex = currentPosition.getColumnPosition();
        }
        return (lastColumnIndex - firstColumnIndex + 1) * (lastRowIndex - firstRowIndex + 1) == this.getSelectedCells().size();
    }

    public void clearWrappedSelection() {
        this.fullySelectedRowsObject.clear();
        this.fullySelectionColumnsObject.clear();
        this.selectedCells.clear();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TableSelectionWrapper)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        TableSelectionWrapper w2 = (TableSelectionWrapper)o;
        if (w2.getNatTableModelManager() != this.manager) {
            return false;
        }
        return w2.getNatTableModelManager() == this.manager && w2.getFullySelectedColumns().equals(this.fullySelectionColumnsObject) && w2.getFullySelectedRows().equals(this.fullySelectedRowsObject) && w2.getSelectedCells().equals(this.selectedCells);
    }

    public INattableModelManager getNatTableModelManager() {
        return this.manager;
    }
}

