/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.navigation.ui;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.navigation.Activator;
import org.eclipse.papyrus.infra.gmfdiag.navigation.ui.DynamicNavigate;
import org.eclipse.papyrus.infra.gmfdiag.navigation.ui.DynamicNavigateLabelProvider;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DiagramDynamicNavigate
extends DynamicNavigate {
    View selectedView;

    public void fill(Menu menu, int index) {
        List navigableElements;
        EObject selectedObject = this.getSelection();
        if (this.navigationService != null && (navigableElements = this.navigationService.getNavigableElements((Object)selectedObject)) != null) {
            for (final NavigableElement navigableElement : navigableElements) {
                List<Object> viewsToSelect = this.getViewsToSelect(navigableElement, false);
                MenuItem menuItem = new MenuItem(menu, 64);
                menuItem.setText(navigableElement.getLabel());
                menuItem.setImage(navigableElement.getImage());
                menuItem.setToolTipText(navigableElement.getDescription());
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DiagramDynamicNavigate.this.showInModelExplorer(navigableElement);
                    }
                });
                menuItem.setMenu(new Menu(menuItem));
                Menu subMenu = menuItem.getMenu();
                MenuItem subMenuItem = new MenuItem(subMenu, 32);
                subMenuItem.setText("Model Explorer");
                subMenuItem.setImage(Activator.getDefault().getIcon("modelexplorer"));
                subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DiagramDynamicNavigate.this.showInModelExplorer(navigableElement);
                    }
                });
                for (final Object view : viewsToSelect) {
                    if (!(view instanceof EObject) || this.selectedView == view) continue;
                    MenuItem subMenuViewItem = new MenuItem(subMenu, 32);
                    subMenuViewItem.setText(DynamicNavigateLabelProvider.getText(view));
                    subMenuViewItem.setToolTipText(DynamicNavigateLabelProvider.getToolTipText(view));
                    subMenuViewItem.setImage(DynamicNavigateLabelProvider.getImage(view));
                    subMenuViewItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            DiagramDynamicNavigate.this.revealObject(view);
                        }
                    });
                }
            }
        }
    }

    protected EObject getSelection() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            ISelection selection = activeWorkbenchWindow.getSelectionService().getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return null;
            }
            for (Object object : ((IStructuredSelection)selection).toList()) {
                View view;
                if (!(object instanceof IGraphicalEditPart) || object instanceof DiagramEditPart || (view = ((IGraphicalEditPart)object).getNotationView()).getEAnnotation("Shortcut") != null) continue;
                try {
                    ServicesRegistry registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)view);
                    if (registry == null) continue;
                    this.navigationService = (NavigationService)registry.getService(NavigationService.class);
                    this.selectedView = view;
                    return EMFHelper.getEObject(object);
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }
}

