/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.catalog.DirectionKind;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.modisco.infra.discovery.core.IDiscoverer;
import org.eclipse.modisco.infra.discovery.core.IDiscoveryManager;
import org.eclipse.modisco.infra.discovery.core.Messages;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.infra.discovery.core.internal.Activator;
import org.eclipse.modisco.infra.discovery.core.internal.DiscoveryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDiscoverer<T>
implements IDiscoverer<T> {
    private boolean refreshSourceBeforeDiscovery = false;

    @Parameter(name="REFRESH_SOURCE_BEFORE", description="Whether to refresh the source at the beginning of the discovery. Refresh behavior depends on the Discoverer implementation. The standard refresh behavior is to test if the source is an org.eclipse.core.resources.IResource and call its refreshLocal() method.")
    public void setRefreshSourceBeforeDiscovery(boolean value) {
        this.refreshSourceBeforeDiscovery = value;
    }

    protected boolean getRefreshSourceBeforeDiscovery() {
        return this.refreshSourceBeforeDiscovery;
    }

    protected abstract void basicDiscoverElement(T var1, IProgressMonitor var2) throws DiscoveryException;

    @Override
    public void discoverElement(T source, IProgressMonitor monitor) throws DiscoveryException {
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(Messages.AbstractDiscoverer_testingApplicability);
        if (!this.isApplicableTo(source)) {
            throw new DiscoveryException("Cannot launch discoverer because it is not applicable to " + source.toString());
        }
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(Messages.AbstractDiscoverer_checkingParamValues);
        this.checkParameterValues();
        if (monitor.isCanceled()) {
            return;
        }
        if (this.refreshSourceBeforeDiscovery) {
            monitor.subTask(Messages.AbstractDiscoverer_refreshingSource);
            AbstractDiscoverer.refreshSource(source);
        }
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(Messages.AbstractDiscoverer_discovering);
        this.basicDiscoverElement(source, monitor);
    }

    protected static void refreshSource(Object source) throws DiscoveryException {
        if (source instanceof IResource) {
            try {
                ((IResource)source).refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new DiscoveryException(e);
            }
        }
    }

    public static boolean isAJavaProject(Object source) {
        boolean result = false;
        if (source instanceof IJavaProject) {
            result = ((IJavaProject)source).getProject().isAccessible();
        } else if (source instanceof IProject) {
            IProject project = (IProject)source;
            try {
                if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                    result = true;
                }
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    public static boolean isAFolder(Object source) {
        return source instanceof IFolder;
    }

    public static boolean isAProject(Object source) {
        return source instanceof IProject;
    }

    public static boolean isAnIFileWithExtension(Object source, String fileExtension) {
        boolean result = false;
        if (source instanceof IFile) {
            IFile iFile = (IFile)source;
            String sourceExtension = iFile.getFileExtension();
            result = sourceExtension != null ? (fileExtension.length() == 0 || fileExtension.charAt(0) != '.' ? sourceExtension.equals(fileExtension) : sourceExtension.equals(fileExtension.substring(1))) : fileExtension == null;
        }
        return result;
    }

    protected void checkParameterValues() throws DiscoveryException {
        DiscovererDescription discoDesc = DiscoveryManager.getDiscovererDescription(this.getClass());
        if (discoDesc != null) {
            for (DiscovererParameter aParameterDescription : discoDesc.getParameterDefinitions()) {
                if (!aParameterDescription.getDirection().equals((Object)DirectionKind.IN) && !aParameterDescription.getDirection().equals((Object)DirectionKind.INOUT) || !aParameterDescription.isRequiredInput() || !IDiscoveryManager.INSTANCE.canRetrieveValue(aParameterDescription)) continue;
                Object parameterValue = null;
                try {
                    parameterValue = IDiscoveryManager.INSTANCE.getValue(aParameterDescription, this);
                }
                catch (Exception e) {
                    MoDiscoLogger.logWarning((Throwable)e, (String)Messages.AbstractDiscoverer_CannotCheck, (Plugin)Activator.getDefault());
                }
                if (parameterValue != null) continue;
                throw new DiscoveryException(String.valueOf(Messages.AbstractDiscoverer_CannotLaunch_2) + aParameterDescription.getId());
            }
        }
    }
}

