/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.AbstractExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFillRatioQuery {
    protected void runQuantizer(IProgressListener listener, Quantize quantize, ICollectionExtractor specificExtractor, String specificClass, ISnapshot snapshot, Iterable<int[]> objects) throws SnapshotException {
        Iterator<int[]> iterator = objects.iterator();
        while (iterator.hasNext()) {
            int[] objectIds;
            int[] nArray = objectIds = iterator.next();
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int objectId = nArray[n2];
                if (listener.isCanceled()) {
                    return;
                }
                IObject obj = snapshot.getObject(objectId);
                try {
                    Double fillRatio;
                    AbstractExtractedCollection<?, ?> coll = CollectionExtractionUtils.extractCollection(obj, specificClass, specificExtractor);
                    if (coll != null && (fillRatio = coll.getFillRatio()) != null) {
                        quantize.addValue(objectId, new Object[]{fillRatio, 1, coll.getUsedHeapSize()});
                    }
                }
                catch (RuntimeException e) {
                    listener.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.CollectionFillRatioQuery_IgnoringCollection, (Object[])new Object[]{obj.getTechnicalName()}), (Throwable)e);
                }
                ++n2;
            }
        }
    }
}

