/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.driver;

import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RobotConfiguration;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.swt.driver.SwtRobot;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class WindowActivationMethod {
    private static final int ACTIVATE_BTN = 524288;
    private final SwtRobot m_robot;
    private final IEventThreadQueuer m_queuer;

    protected WindowActivationMethod(SwtRobot robot, IEventThreadQueuer queuer) {
        this.m_robot = robot;
        this.m_queuer = queuer;
    }

    protected abstract Point getClickPoint(Shell var1);

    public void activate(final Shell window) {
        this.m_queuer.invokeAndWait("window activate", (IRunnable)new IRunnable<Void>(){

            public Void run() throws StepExecutionException {
                Point pos = window.getLocation();
                Point cp = WindowActivationMethod.this.getClickPoint(window);
                WindowActivationMethod.this.m_robot.mouseMove(pos.x + cp.x, pos.y + cp.y);
                WindowActivationMethod.this.m_robot.mousePress(524288);
                WindowActivationMethod.this.m_robot.mouseRelease(524288);
                RobotTiming.sleepPostWindowActivationDelay();
                return null;
            }
        });
    }

    public static WindowActivationMethod createWindowActivationMethod(String method, SwtRobot robot, IEventThreadQueuer queuer) {
        if (ValueSets.AUTActivationMethod.autDefault.rcValue().equals(method)) {
            return WindowActivationMethod.createWindowActivationMethod(RobotConfiguration.getInstance().getDefaultActivationMethod(), robot, queuer);
        }
        if (ValueSets.AUTActivationMethod.none.rcValue().equals(method)) {
            return new NoneMethod(robot, queuer);
        }
        if (ValueSets.AUTActivationMethod.titlebar.rcValue().equals(method)) {
            return new TitleMethod(robot, queuer);
        }
        if (ValueSets.AUTActivationMethod.northwest.rcValue().equals(method)) {
            return new NorthWestMethod(robot, queuer);
        }
        if (ValueSets.AUTActivationMethod.northeast.rcValue().equals(method)) {
            return new NorthEastMethod(robot, queuer);
        }
        if (ValueSets.AUTActivationMethod.southwest.rcValue().equals(method)) {
            return new SouthWestMethod(robot, queuer);
        }
        if (ValueSets.AUTActivationMethod.southeast.rcValue().equals(method)) {
            return new SouthEastMethod(robot, queuer);
        }
        if (ValueSets.AUTActivationMethod.center.rcValue().equals(method)) {
            return new CenterMethod(robot, queuer);
        }
        return new NoneMethod(robot, queuer);
    }

    private static class CenterMethod
    extends WindowActivationMethod {
        public CenterMethod(SwtRobot robot, IEventThreadQueuer queuer) {
            super(robot, queuer);
        }

        protected Point getClickPoint(Shell window) {
            return new Point(SwtUtils.getWidgetBounds((Widget)window).width / 2, SwtUtils.getWidgetBounds((Widget)window).height / 2);
        }
    }

    private static class NoneMethod
    extends WindowActivationMethod {
        public NoneMethod(SwtRobot robot, IEventThreadQueuer queuer) {
            super(robot, queuer);
        }

        protected Point getClickPoint(Shell window) {
            return null;
        }

        public void activate(Shell window) {
        }
    }

    private static class NorthEastMethod
    extends WindowActivationMethod {
        public NorthEastMethod(SwtRobot robot, IEventThreadQueuer queuer) {
            super(robot, queuer);
        }

        protected Point getClickPoint(Shell window) {
            return new Point(SwtUtils.getWidgetBounds((Widget)window).width - 1, 0);
        }
    }

    private static class NorthWestMethod
    extends WindowActivationMethod {
        public NorthWestMethod(SwtRobot robot, IEventThreadQueuer queuer) {
            super(robot, queuer);
        }

        protected Point getClickPoint(Shell window) {
            return new Point(0, 0);
        }
    }

    private static class SouthEastMethod
    extends WindowActivationMethod {
        public SouthEastMethod(SwtRobot robot, IEventThreadQueuer queuer) {
            super(robot, queuer);
        }

        protected Point getClickPoint(Shell window) {
            return new Point(SwtUtils.getWidgetBounds((Widget)window).width - 1, SwtUtils.getWidgetBounds((Widget)window).height - 1);
        }
    }

    private static class SouthWestMethod
    extends WindowActivationMethod {
        public SouthWestMethod(SwtRobot robot, IEventThreadQueuer queuer) {
            super(robot, queuer);
        }

        protected Point getClickPoint(Shell window) {
            return new Point(0, SwtUtils.getWidgetBounds((Widget)window).height - 1);
        }
    }

    private static class TitleMethod
    extends WindowActivationMethod {
        public TitleMethod(SwtRobot robot, IEventThreadQueuer queuer) {
            super(robot, queuer);
        }

        protected Point getClickPoint(Shell window) {
            return new Point(SwtUtils.getWidgetBounds((Widget)window).width / 2, 3);
        }
    }
}

