/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.propertysources;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.contentassist.TestDataCubeRefContentProposalProvider;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.ContentAssistedTextPropertyDescriptor;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.ParamTextPropertyDescriptor;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractNodePropertySource;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractPropertySource;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.SpecTestCaseGUIPropertySource;
import org.eclipse.jubula.client.ui.rcp.factory.TestDataControlFactory;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.DisabledLabelProvider;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.ParameterValueLabelProvider;
import org.eclipse.jubula.client.ui.rcp.validator.TestDataCubeReferenceValidator;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ParamValueSet;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ExecTestCaseGUIPropertySource
extends SpecTestCaseGUIPropertySource {
    public static final String P_SPECNAME_DISPLAY_NAME = org.eclipse.jubula.client.ui.rcp.i18n.Messages.ExecTestCaseGUIPropertySourceSpecificationName;
    public static final String P_REFERNCE_DISPLAY_NAME = org.eclipse.jubula.client.ui.rcp.i18n.Messages.ExecTestCaseGUIPropertySourceTestCaseReferenceName;
    private IPropertyDescriptor m_namePropDesc = null;
    private IPropertyDescriptor m_specNamePropDesc = null;
    private IPropertyDescriptor m_commentPropDesc = null;
    private PropertyDescriptor m_extDataPropDesc = null;
    private PropertyDescriptor m_referencedCubePropDesc = null;
    private List<IPropertyDescriptor> m_paramPropDescList = new ArrayList<IPropertyDescriptor>();
    private ComboBoxPropertyDescriptor m_comBoxJUnitTestSuite;
    private boolean m_isTestSuite;

    public ExecTestCaseGUIPropertySource(IExecTestCasePO testCase) {
        super((ITestCasePO)testCase);
    }

    @Override
    protected void initPropDescriptor() {
        if (!this.getPropertyDescriptorList().isEmpty()) {
            this.clearPropertyDescriptors();
        }
        if (this.m_namePropDesc == null) {
            this.m_namePropDesc = new TextPropertyDescriptor((Object)new ExecNameController(), P_REFERNCE_DISPLAY_NAME);
        }
        this.addPropertyDescriptor(this.m_namePropDesc);
        if (this.m_specNamePropDesc == null) {
            PropertyDescriptor propDes = new PropertyDescriptor((Object)new SpecNameController(), P_SPECNAME_DISPLAY_NAME);
            propDes.setLabelProvider((ILabelProvider)new DisabledLabelProvider());
            this.m_specNamePropDesc = propDes;
        }
        this.addPropertyDescriptor(this.m_specNamePropDesc);
        if (this.m_commentPropDesc == null) {
            this.m_commentPropDesc = new TextPropertyDescriptor((Object)new AbstractNodePropertySource.CommentController(this), P_ELEMENT_DISPLAY_COMMENT);
        }
        this.addPropertyDescriptor(this.m_commentPropDesc);
        if (this.getTaskIdPropDesc() == null) {
            this.createJPropertyDescriptor();
        }
        this.addPropertyDescriptor(this.getTaskIdPropDesc());
        this.addPropertyDescriptor(this.getDataSourcePropertyDescr(new ExecTestCaseTestDataSourceController((AbstractNodePropertySource)this)));
        JUnitTestSuiteController jsC = new JUnitTestSuiteController();
        this.createJUnitComboBox(jsC);
        if (this.m_extDataPropDesc == null) {
            this.m_extDataPropDesc = new TextPropertyDescriptor((Object)new SpecTestCaseGUIPropertySource.ExternalDataController(this), P_ELEMENT_DISPLAY_DATEFILE);
            this.m_extDataPropDesc.setCategory(P_TESTDATA_CAT);
        }
        this.addPropertyDescriptor((IPropertyDescriptor)this.m_extDataPropDesc);
        if (this.m_referencedCubePropDesc == null) {
            IProjectPO activeProject = GeneralStorage.getInstance().getProject();
            TestDataCubeRefContentProposalProvider dataCubeRefProposalProvider = null;
            TestDataCubeReferenceValidator dataCubeRefValidator = null;
            if (activeProject != null) {
                dataCubeRefProposalProvider = new TestDataCubeRefContentProposalProvider(activeProject, (IParameterInterfacePO)this.getPoNode());
                dataCubeRefValidator = new TestDataCubeReferenceValidator(activeProject);
            }
            this.m_referencedCubePropDesc = new ContentAssistedTextPropertyDescriptor(new SpecTestCaseGUIPropertySource.ReferenceTestDataController(this), P_ELEMENT_DISPLAY_REFDATA, dataCubeRefProposalProvider, dataCubeRefValidator, 2);
            this.m_referencedCubePropDesc.setCategory(P_TESTDATA_CAT);
        }
        this.addPropertyDescriptor((IPropertyDescriptor)this.m_referencedCubePropDesc);
        this.addPropertyDescriptor(this.createParamDescriptors());
    }

    private void createJPropertyDescriptor() {
        PropertyDescriptor taskIdPropDesc = new PropertyDescriptor((Object)new AbstractNodePropertySource.ReadOnlyTaskIdController(this), Messages.AbstractGuiNodePropertySourceTaskId);
        taskIdPropDesc.setLabelProvider((ILabelProvider)new DisabledLabelProvider());
        this.setTaskIdPropDesc((IPropertyDescriptor)taskIdPropDesc);
    }

    private void createJUnitComboBox(final JUnitTestSuiteController jsC) {
        this.m_comBoxJUnitTestSuite = new ComboBoxPropertyDescriptor((Object)jsC, org.eclipse.jubula.client.ui.rcp.i18n.Messages.ExecTestCaseGUIPropertySourceJUnitTestSuite, jsC.getLabelList());
        this.addPropertyDescriptor((IPropertyDescriptor)this.m_comBoxJUnitTestSuite);
        this.m_comBoxJUnitTestSuite.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Integer) {
                    if ((Integer)element == -1) {
                        return Boolean.toString(false);
                    }
                    return jsC.getLabelList()[(Integer)element];
                }
                Assert.notReached((String)(String.valueOf(org.eclipse.jubula.client.ui.rcp.i18n.Messages.WrongAUT) + "."));
                return String.valueOf(element);
            }
        });
    }

    protected List<IPropertyDescriptor> createParamDescriptors() {
        if (this.m_paramPropDescList.isEmpty()) {
            IParamNodePO paramNodePO = (IParamNodePO)this.getPoNode();
            List paramList = paramNodePO.getParameterList();
            IParamNameMapper activeParamNameMapper = this.getActiveParamNameMapper();
            for (IParamDescriptionPO paramDescr : paramList) {
                ParamValueSet valueSet = ParamTextPropertyDescriptor.getValuesSet(paramNodePO, paramDescr.getUniqueId());
                PropertyDescriptor propDes = TestDataControlFactory.createValuePropertyDescriptor(new ParameterValueController((AbstractNodePropertySource)this, paramDescr, activeParamNameMapper), this.getParameterNameDescr(paramDescr), ParamTextPropertyDescriptor.getValuesWithComment(valueSet), valueSet != null ? valueSet.isCombinable() : false);
                propDes.setCategory(P_PARAMETER_CAT);
                propDes.setLabelProvider((ILabelProvider)new ParameterValueLabelProvider(INCOMPL_DATA_IMAGE));
                this.m_paramPropDescList.add((IPropertyDescriptor)propDes);
            }
        }
        return this.m_paramPropDescList;
    }

    public boolean getIsTestSuite() {
        return this.m_isTestSuite;
    }

    public void setTestSuite(boolean isTestSuite) {
        this.m_isTestSuite = isTestSuite;
    }

    public ComboBoxPropertyDescriptor getComBoxJUnitTestSuite() {
        return this.m_comBoxJUnitTestSuite;
    }

    public void setComBoxJUnitTestSuite(ComboBoxPropertyDescriptor comBoxJUnitTestSuite) {
        this.m_comBoxJUnitTestSuite = comBoxJUnitTestSuite;
    }

    protected class ExecNameController
    extends AbstractNodePropertySource.ElementNameController {
        protected ExecNameController() {
            super(ExecTestCaseGUIPropertySource.this);
        }

        @Override
        public Object getProperty() {
            IExecTestCasePO exTc;
            String name;
            if (ExecTestCaseGUIPropertySource.this.getPoNode() != null && (name = (exTc = (IExecTestCasePO)ExecTestCaseGUIPropertySource.this.getPoNode()).getRealName()) != null) {
                return name;
            }
            return "";
        }
    }

    public class ExecTestCaseTestDataSourceController
    extends SpecTestCaseGUIPropertySource.SpecTestCaseTestDataSourceController {
        protected static final String DATA_SOURCE_REFERENCED = "TestDataSource.spec";

        public ExecTestCaseTestDataSourceController(AbstractNodePropertySource s) {
            super(s);
            this.getDataSource().add(DATA_SOURCE_REFERENCED);
        }

        @Override
        public Object getProperty() {
            this.getPropertySource().setReadOnly(true);
            if (ExecTestCaseGUIPropertySource.this.getPoNode() instanceof IParamNodePO) {
                IParamNodePO node = (IParamNodePO)ExecTestCaseGUIPropertySource.this.getPoNode();
                String dataSource = this.getDataSource(node);
                if (dataSource == "TestDataSource.unkown" && node instanceof IExecTestCasePO) {
                    IExecTestCasePO exec = (IExecTestCasePO)node;
                    this.getPropertySource().setReadOnly(false);
                    if (exec.getHasReferencedTD()) {
                        return this.getDataSource().indexOf(DATA_SOURCE_REFERENCED);
                    }
                    return this.getDataSource().indexOf("TestDataSource.local");
                }
                return this.getDataSource().indexOf(dataSource);
            }
            return this.getDataSource().indexOf("TestDataSource.unkown");
        }

        @Override
        public String[] getUserChoosableDataSource() {
            if (this.getUserChoosableValues().isEmpty()) {
                this.getUserChoosableValues().add(I18n.getString((String)"TestDataSource.local"));
                this.getUserChoosableValues().add(I18n.getString((String)DATA_SOURCE_REFERENCED));
            }
            return this.getUserChoosableValues().toArray(new String[this.getUserChoosableValues().size()]);
        }

        @Override
        public boolean setProperty(Object value) {
            IParamNodePO node;
            if (ExecTestCaseGUIPropertySource.this.getPoNode() instanceof IParamNodePO && (node = (IParamNodePO)ExecTestCaseGUIPropertySource.this.getPoNode()) instanceof IExecTestCasePO) {
                IExecTestCasePO exec = (IExecTestCasePO)node;
                int index = Integer.valueOf(String.valueOf(value));
                if (index >= 0) {
                    boolean isLocal;
                    String newDataSource = this.getUserChoosableValues().get(index);
                    boolean shouldBeLocal = newDataSource == I18n.getString((String)"TestDataSource.local");
                    boolean bl = isLocal = !exec.getHasReferencedTD();
                    if (shouldBeLocal == isLocal) {
                        return false;
                    }
                    if (shouldBeLocal) {
                        exec.resolveTDReference();
                    } else {
                        exec.setHasReferencedTD(true);
                    }
                    DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)node, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
                    return true;
                }
            }
            return false;
        }
    }

    protected class JUnitTestSuiteController
    extends AbstractPropertySource.AbstractPropertyController {
        private String[] m_labelList = new String[]{"false", "true"};

        protected JUnitTestSuiteController() {
        }

        public boolean setProperty(Object value) {
            Integer integer;
            if (value instanceof Integer && ((integer = (Integer)value) == 0 || integer == 1)) {
                boolean isJUnitTestSuite = Boolean.valueOf(this.m_labelList[integer]);
                ExecTestCaseGUIPropertySource.this.getPoNode().setJUnitTestSuite(isJUnitTestSuite);
                return true;
            }
            return false;
        }

        public Object getProperty() {
            Integer labelIDs = this.getLabelIDs();
            return labelIDs;
        }

        public String[] getLabelList() {
            return this.m_labelList;
        }

        Integer getLabelIDs() {
            Boolean boolJUnitSuite = ExecTestCaseGUIPropertySource.this.getPoNode().isJUnitTestSuite();
            int autListLength = this.m_labelList.length;
            int i = 0;
            while (i < autListLength) {
                if (Boolean.parseBoolean(this.m_labelList[i]) == boolJUnitSuite) {
                    return i;
                }
                ++i;
            }
            return new Integer(0);
        }
    }

    public class ParameterValueController
    extends AbstractNodePropertySource.AbstractParamValueController {
        public ParameterValueController(AbstractNodePropertySource s, IParamDescriptionPO paramDescr, IParamNameMapper paramNameMapper) {
            super(ExecTestCaseGUIPropertySource.this, s, paramDescr, paramNameMapper);
        }
    }

    protected class SpecNameController
    extends AbstractPropertySource.AbstractPropertyController {
        protected SpecNameController() {
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public Object getProperty() {
            IExecTestCasePO exTc = (IExecTestCasePO)ExecTestCaseGUIPropertySource.this.getPoNode();
            if (exTc.getSpecTestCase() != null) {
                return exTc.getSpecTestCase().getName();
            }
            return "";
        }

        @Override
        public Image getImage() {
            return READONLY_IMAGE;
        }
    }
}

