/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;

public class CleanupObjectMapping {
    private CleanupObjectMapping() {
    }

    public static boolean cleanupObjectMapping(IObjectMappingPO objMap) {
        HashSet<String> existing = new HashSet<String>();
        CleanupObjectMapping.recCollectMappedCNs(existing, objMap.getMappedCategory());
        return CleanupObjectMapping.recRemoveDoubledCNs(existing, objMap.getUnmappedLogicalCategory());
    }

    private static void recCollectMappedCNs(Set<String> mapped, IObjectMappingCategoryPO cat) {
        for (IObjectMappingAssoziationPO assoc : cat.getUnmodifiableAssociationList()) {
            for (String guid : assoc.getLogicalNames()) {
                mapped.add(guid);
            }
        }
        for (IObjectMappingCategoryPO childCat : cat.getUnmodifiableCategoryList()) {
            CleanupObjectMapping.recCollectMappedCNs(mapped, childCat);
        }
    }

    private static boolean recRemoveDoubledCNs(Set<String> existing, IObjectMappingCategoryPO cat) {
        boolean wasChange = false;
        for (IObjectMappingCategoryPO child : cat.getUnmodifiableCategoryList()) {
            wasChange |= CleanupObjectMapping.recRemoveDoubledCNs(existing, child);
        }
        ArrayList<IObjectMappingAssoziationPO> toRemove = new ArrayList<IObjectMappingAssoziationPO>();
        for (IObjectMappingAssoziationPO assoc : cat.getUnmodifiableAssociationList()) {
            for (String guid : assoc.getLogicalNames()) {
                if (existing.contains(guid)) {
                    toRemove.add(assoc);
                    continue;
                }
                existing.add(guid);
            }
        }
        for (IObjectMappingAssoziationPO assoc : toRemove) {
            cat.removeAssociation(assoc);
        }
        return wasChange || !toRemove.isEmpty();
    }
}

