/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.AbstractToStringGenerator;

public class StringFormatGenerator
extends AbstractToStringGenerator {
    private List<Expression> arguments;
    private StringBuffer buffer;

    @Override
    protected void initialize() {
        super.initialize();
        this.arguments = new ArrayList<Expression>();
        this.buffer = new StringBuffer();
    }

    @Override
    protected void complete() throws CoreException {
        super.complete();
        ReturnStatement rStatement = this.fAst.newReturnStatement();
        String formatClass = this.getContext().is50orHigher() ? "java.lang.String" : "java.text.MessageFormat";
        MethodInvocation formatInvocation = this.createMethodInvocation((Expression)this.addImport(formatClass), "format", null);
        StringLiteral literal = this.fAst.newStringLiteral();
        literal.setLiteralValue(this.buffer.toString());
        formatInvocation.arguments().add(literal);
        if (this.getContext().is50orHigher()) {
            formatInvocation.arguments().addAll(this.arguments);
        } else {
            ArrayCreation arrayCreation = this.fAst.newArrayCreation();
            arrayCreation.setType(this.fAst.newArrayType((Type)this.fAst.newSimpleType(this.addImport("java.lang.Object"))));
            ArrayInitializer initializer = this.fAst.newArrayInitializer();
            arrayCreation.setInitializer(initializer);
            initializer.expressions().addAll(this.arguments);
            formatInvocation.arguments().add(arrayCreation);
        }
        rStatement.setExpression((Expression)formatInvocation);
        this.toStringMethod.getBody().statements().add(rStatement);
    }

    @Override
    protected Object processElement(String templateElement, Object member) {
        if (templateElement == "${member.value}") {
            return this.createMemberAccessExpression(member, false, false);
        }
        return super.processElement(templateElement, member);
    }

    @Override
    protected void addElement(Object element) {
        if (element instanceof String) {
            this.buffer.append((String)element);
        }
        if (element instanceof Expression) {
            this.arguments.add((Expression)element);
            if (this.getContext().is50orHigher()) {
                this.buffer.append("%s");
            } else {
                this.buffer.append("{" + (this.arguments.size() - 1) + "}");
            }
        }
    }

    @Override
    protected Expression createMemberAccessExpression(Object member, boolean ignoreArraysCollections, boolean ignoreNulls) {
        ITypeBinding type = this.getMemberType(member);
        if (!this.getContext().is50orHigher() && type.isPrimitive()) {
            String nonPrimitiveType = null;
            String typeName = type.getName();
            if (typeName.equals("byte")) {
                nonPrimitiveType = "java.lang.Byte";
            }
            if (typeName.equals("short")) {
                nonPrimitiveType = "java.lang.Short";
            }
            if (typeName.equals("char")) {
                nonPrimitiveType = "java.lang.Character";
            }
            if (typeName.equals("int")) {
                nonPrimitiveType = "java.lang.Integer";
            }
            if (typeName.equals("long")) {
                nonPrimitiveType = "java.lang.Long";
            }
            if (typeName.equals("float")) {
                nonPrimitiveType = "java.lang.Float";
            }
            if (typeName.equals("double")) {
                nonPrimitiveType = "java.lang.Double";
            }
            if (typeName.equals("boolean")) {
                nonPrimitiveType = "java.lang.Boolean";
            }
            ClassInstanceCreation classInstance = this.fAst.newClassInstanceCreation();
            classInstance.setType((Type)this.fAst.newSimpleType(this.addImport(nonPrimitiveType)));
            classInstance.arguments().add(super.createMemberAccessExpression(member, true, true));
            return classInstance;
        }
        return super.createMemberAccessExpression(member, ignoreArraysCollections, ignoreNulls);
    }
}

