/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.logical.IModelMinimizer;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;

public class ModelMinimizerRegistryListener
extends AbstractRegistryEventListener {
    private static final String TAG_MODEL_MINIMIZER = "modelMinimizer";
    private static final String ATTRIBUTE_CLASS = "class";
    private IModelMinimizer.Registry registry;

    public ModelMinimizerRegistryListener(String pluginID, String extensionPointID, ILog log, IModelMinimizer.Registry registry) {
        super(pluginID, extensionPointID, log);
        this.registry = registry;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        return true;
    }

    protected boolean addedValid(IConfigurationElement element) {
        if (element.getName().equals(TAG_MODEL_MINIMIZER)) {
            try {
                IModelMinimizer minimizer = (IModelMinimizer)element.createExecutableExtension(ATTRIBUTE_CLASS);
                this.registry.addMinimizer(minimizer);
            }
            catch (CoreException e) {
                String message = EMFCompareIDEUIMessages.getString("ModelMinimizerRegistry.invalidClass", element.getAttribute(ATTRIBUTE_CLASS));
                Status status = new Status(4, element.getDeclaringExtension().getContributor().getName(), message, (Throwable)e);
                EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)status);
            }
            return true;
        }
        return false;
    }

    protected boolean removedValid(IConfigurationElement element) {
        String className = element.getAttribute(ATTRIBUTE_CLASS);
        this.registry.removeMinimizer(className);
        return true;
    }
}

