/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.decorator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.bpel.common.ui.decorator.EditPartMarkerDecorator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;

public class LinkEditPartMarkerDecorator
extends EditPartMarkerDecorator {
    private Connection fConnection;
    private List<IFigure> fMarkerFigures = new ArrayList<IFigure>();

    public LinkEditPartMarkerDecorator(EObject aModelObject, Connection aConnection) {
        super(aModelObject);
        this.fConnection = aConnection;
    }

    @Override
    protected Object getConstraint(IMarker marker) {
        try {
            String anchorString;
            if (marker.isSubtypeOf("org.eclipse.bpel.common.ui.graphicalMarker") && (anchorString = (String)marker.getAttribute("org.eclipse.bpel.common.ui.graphicalMarker.anchorPoint")) != null) {
                if (anchorString.equals("SOURCE")) {
                    ConnectionEndpointLocator locator = new ConnectionEndpointLocator(this.fConnection, false);
                    locator.setUDistance(4);
                    locator.setVDistance(0);
                    return locator;
                }
                if (anchorString.equals("TARGET")) {
                    ConnectionEndpointLocator locator = new ConnectionEndpointLocator(this.fConnection, true);
                    locator.setUDistance(4);
                    locator.setVDistance(0);
                    return locator;
                }
                if (anchorString.equals("CENTRE")) {
                    return new ConnectionLocator(this.fConnection, 4);
                }
            }
        }
        catch (CoreException coreException) {}
        return new ConnectionLocator(this.fConnection, 4);
    }

    public void removeAllMarkerFigures() {
        for (IFigure figure : this.fMarkerFigures) {
            this.fConnection.remove(figure);
        }
        this.fMarkerFigures.clear();
    }

    public void addMarkerFigure(IFigure figure) {
        this.fMarkerFigures.add(figure);
    }

    public Connection getConnection() {
        return this.fConnection;
    }

    @Override
    protected void refreshMarkers() {
        if (this.getConnection() != null) {
            this.removeAllMarkerFigures();
            Map<Object, IMarker> constraintToMarkerMap = this.getMarkerMap();
            for (Map.Entry<Object, IMarker> entry : constraintToMarkerMap.entrySet()) {
                Object constraint = entry.getKey();
                IMarker marker = entry.getValue();
                IFigure markerFigure = this.createFigureForMarker(marker);
                if (markerFigure == null) continue;
                this.addMarkerFigure(markerFigure);
                this.getConnection().add(markerFigure, constraint);
            }
        }
    }
}

