/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import jnr.unixsocket.UnixSocket;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class UnixConnectionSocketFactory
implements ConnectionSocketFactory {
    private File socketFile;

    public UnixConnectionSocketFactory(URI socketUri) {
        String filename = socketUri.toString().replaceAll("^unix:///", "unix://localhost/").replaceAll("^unix://localhost", "");
        this.socketFile = new File(filename);
    }

    public static URI sanitizeUri(URI uri) {
        if (uri.getScheme().equals("unix")) {
            return URI.create("unix://localhost:80");
        }
        return uri;
    }

    public UnixSocket createSocket(HttpContext context) throws IOException {
        return UnixSocketChannel.open().socket();
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        if (!(socket instanceof UnixSocket)) {
            throw new AssertionError((Object)("Unexpected socket: " + socket));
        }
        socket.setSoTimeout(connectTimeout);
        try {
            socket.getChannel().connect((SocketAddress)new UnixSocketAddress(this.socketFile));
        }
        catch (SocketTimeoutException e) {
            throw new ConnectTimeoutException((IOException)e, null, new InetAddress[]{remoteAddress.getAddress()});
        }
        return socket;
    }
}

