/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.runtime.emf.rules.batch;

import java.util.Collections;
import java.util.function.Consumer;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleEngine;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.api.event.EventType;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDEventTypeEnum;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryMatchEventFilter;
import org.eclipse.viatra.transformation.evm.specific.lifecycle.UnmodifiableActivationLifeCycle;
import org.eclipse.viatra.transformation.runtime.emf.rules.ITransformationRule;

public class BatchTransformationRule<MATCH extends IPatternMatch, MATCHER extends ViatraQueryMatcher<MATCH>>
implements ITransformationRule<MATCH, MATCHER> {
    public static final ActivationLifeCycle STATELESS_RULE_LIFECYCLE = BatchTransformationRule.getStatelessRuleLifecycle();
    public static final ActivationLifeCycle STATEFUL_RULE_LIFECYCLE = Lifecycles.getDefault((boolean)false, (boolean)false);
    protected String ruleName;
    private final ActivationLifeCycle lifecycle;
    private RuleSpecification<MATCH> ruleSpec;
    private final IQuerySpecification<MATCHER> precondition;
    private final Consumer<MATCH> action;
    private final EventFilter<? super MATCH> filter;

    private static ActivationLifeCycle getStatelessRuleLifecycle() {
        ActivationLifeCycle cycle = ActivationLifeCycle.create((ActivationState)CRUDActivationStateEnum.INACTIVE);
        cycle.addStateTransition((ActivationState)CRUDActivationStateEnum.INACTIVE, (EventType)CRUDEventTypeEnum.CREATED, (ActivationState)CRUDActivationStateEnum.CREATED);
        cycle.addStateTransition((ActivationState)CRUDActivationStateEnum.CREATED, (EventType)EventType.RuleEngineEventType.FIRE, (ActivationState)CRUDActivationStateEnum.CREATED);
        cycle.addStateTransition((ActivationState)CRUDActivationStateEnum.CREATED, (EventType)CRUDEventTypeEnum.DELETED, (ActivationState)CRUDActivationStateEnum.INACTIVE);
        return UnmodifiableActivationLifeCycle.copyOf((ActivationLifeCycle)cycle);
    }

    protected BatchTransformationRule() {
        this("", null, STATELESS_RULE_LIFECYCLE, null);
    }

    public BatchTransformationRule(String rulename, IQuerySpecification<MATCHER> matcher, ActivationLifeCycle lifecycle, Consumer<MATCH> action) {
        this(rulename, matcher, lifecycle, action, (EventFilter<MATCH>)ViatraQueryMatchEventFilter.createFilter((IPatternMatch)matcher.newEmptyMatch().toImmutable()));
    }

    public BatchTransformationRule(String rulename, IQuerySpecification<MATCHER> matcher, ActivationLifeCycle lifecycle, Consumer<MATCH> action, EventFilter<? super MATCH> filter) {
        this.ruleName = rulename;
        this.precondition = matcher;
        this.action = action;
        this.lifecycle = lifecycle;
        this.filter = filter;
    }

    public BatchTransformationRule(BatchTransformationRule<MATCH, MATCHER> rule, EventFilter<MATCH> filter) {
        this.ruleName = rule.ruleName;
        this.precondition = rule.precondition;
        this.action = rule.action;
        this.lifecycle = rule.lifecycle;
        this.filter = filter;
    }

    @Override
    public String getName() {
        return this.ruleName;
    }

    @Override
    public RuleSpecification<MATCH> getRuleSpecification() {
        if (this.ruleSpec == null) {
            Job job = Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, this.action);
            this.ruleSpec = Rules.newMatcherRuleSpecification(this.precondition, (ActivationLifeCycle)this.lifecycle, Collections.singleton(job), (String)this.getName());
        }
        return this.ruleSpec;
    }

    @Override
    public IQuerySpecification<MATCHER> getPrecondition() {
        return this.precondition;
    }

    public Consumer<MATCH> getAction() {
        return this.action;
    }

    @Override
    public EventFilter<? super MATCH> getFilter() {
        return this.filter;
    }

    public boolean registerRule(RuleEngine engine) {
        return engine.addRule(this.getRuleSpecification(), this.filter);
    }

    public boolean unregisterRule(RuleEngine engine) {
        return engine.removeRule(this.getRuleSpecification(), this.filter);
    }
}

