/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.index;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.viatra.query.runtime.matchers.memories.MaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.memories.TimestampReplacement;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.index.StandardIndexer;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.NetworkStructureChangeSensitiveNode;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless.BehaviorChangingMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timely.TimelyMailbox;

public abstract class IndexerWithMemory
extends StandardIndexer
implements Receiver,
NetworkStructureChangeSensitiveNode {
    protected MaskedTupleMemory<Timestamp> memory;
    protected NetworkStructureChangeSensitiveLogic logic;
    protected final Mailbox mailbox;
    private final NetworkStructureChangeSensitiveLogic TIMELY = new NetworkStructureChangeSensitiveLogic(){

        @Override
        public void update(Direction direction, Tuple updateElement, Timestamp timestamp) {
            Tuple signature = IndexerWithMemory.this.mask.transform((ITuple)updateElement);
            if (direction == Direction.INSERT) {
                TimestampReplacement pair = IndexerWithMemory.this.memory.addWithTimestamp(updateElement, signature, (Comparable)timestamp);
                if (pair.oldValue == null) {
                    IndexerWithMemory.this.update(Direction.INSERT, updateElement, signature, true, timestamp);
                } else if (((Timestamp)pair.newValue).compareTo((Timestamp)pair.oldValue) < 0) {
                    IndexerWithMemory.this.update(Direction.REVOKE, updateElement, signature, true, (Timestamp)pair.oldValue);
                    IndexerWithMemory.this.update(Direction.INSERT, updateElement, signature, true, (Timestamp)pair.newValue);
                }
            } else {
                TimestampReplacement pair = IndexerWithMemory.this.memory.removeWithTimestamp(updateElement, signature, (Comparable)timestamp);
                if (pair.newValue == null) {
                    IndexerWithMemory.this.update(Direction.REVOKE, updateElement, signature, true, (Timestamp)pair.oldValue);
                } else if (((Timestamp)pair.newValue).compareTo((Timestamp)pair.oldValue) > 0) {
                    IndexerWithMemory.this.update(Direction.REVOKE, updateElement, signature, true, (Timestamp)pair.oldValue);
                    IndexerWithMemory.this.update(Direction.INSERT, updateElement, signature, true, (Timestamp)pair.newValue);
                }
            }
        }
    };
    private final NetworkStructureChangeSensitiveLogic TIMELESS = new NetworkStructureChangeSensitiveLogic(){

        @Override
        public void update(Direction direction, Tuple updateElement, Timestamp timestamp) {
            Tuple signature = IndexerWithMemory.this.mask.transform((ITuple)updateElement);
            boolean change = direction == Direction.INSERT ? IndexerWithMemory.this.memory.add(updateElement, signature) : IndexerWithMemory.this.memory.remove(updateElement, signature);
            IndexerWithMemory.this.update(direction, updateElement, signature, change, timestamp);
        }
    };

    public IndexerWithMemory(ReteContainer reteContainer, TupleMask mask) {
        super(reteContainer, mask);
        this.memory = MaskedTupleMemory.create((TupleMask)mask, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.SETS, (Object)this, (reteContainer.isDifferentialDataFlowEvaluation() && reteContainer.getCommunicationTracker().isInRecursiveGroup(this) ? 1 : 0) != 0);
        reteContainer.registerClearable((Clearable)this.memory);
        this.mailbox = this.instantiateMailbox();
        reteContainer.registerClearable(this.mailbox);
        this.logic = this.createLogic();
    }

    @Override
    public void networkStructureChanged() {
        boolean isTimestampAware;
        super.networkStructureChanged();
        boolean wasTimestampAware = this.memory.isTimely();
        boolean bl = isTimestampAware = this.reteContainer.isDifferentialDataFlowEvaluation() && this.reteContainer.getCommunicationTracker().isInRecursiveGroup(this);
        if (wasTimestampAware != isTimestampAware) {
            MaskedTupleMemory newMemory = MaskedTupleMemory.create((TupleMask)this.mask, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.SETS, (Object)this, (boolean)isTimestampAware);
            newMemory.initializeWith(this.memory, (Comparable)Timestamp.ZERO);
            this.memory.clear();
            this.memory = newMemory;
        }
        this.logic = this.createLogic();
    }

    protected Mailbox instantiateMailbox() {
        if (this.reteContainer.isDifferentialDataFlowEvaluation()) {
            return new TimelyMailbox(this, this.reteContainer);
        }
        return new BehaviorChangingMailbox(this, this.reteContainer);
    }

    @Override
    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public MaskedTupleMemory<Timestamp> getMemory() {
        return this.memory;
    }

    @Override
    public void update(Direction direction, Tuple updateElement, Timestamp timestamp) {
        this.logic.update(direction, updateElement, timestamp);
    }

    protected abstract void update(Direction var1, Tuple var2, Tuple var3, boolean var4, Timestamp var5);

    @Override
    public void appendParent(Supplier supplier) {
        if (this.parent != null) {
            throw new UnsupportedOperationException("Illegal RETE edge: " + this + " already has a parent (" + this.parent + ") and cannot connect to additional parent (" + supplier + "). ");
        }
        this.parent = supplier;
    }

    @Override
    public void removeParent(Supplier supplier) {
        if (this.parent != supplier) {
            throw new IllegalArgumentException("Illegal RETE edge removal: the parent of " + this + " is not " + supplier);
        }
        this.parent = null;
    }

    @Override
    public Collection<Supplier> getParents() {
        return Collections.singleton(this.parent);
    }

    protected NetworkStructureChangeSensitiveLogic createLogic() {
        if (this.reteContainer.isDifferentialDataFlowEvaluation() && this.reteContainer.getCommunicationTracker().isInRecursiveGroup(this)) {
            return this.createTimelyLogic();
        }
        return this.createTimelessLogic();
    }

    protected NetworkStructureChangeSensitiveLogic createTimelessLogic() {
        return this.TIMELESS;
    }

    protected NetworkStructureChangeSensitiveLogic createTimelyLogic() {
        return this.TIMELY;
    }

    protected static abstract class NetworkStructureChangeSensitiveLogic {
        protected NetworkStructureChangeSensitiveLogic() {
        }

        public abstract void update(Direction var1, Tuple var2, Timestamp var3);
    }
}

